/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import java.util.Optional;

@JsModule(value="@vaadin-component-factory/vcf-nav")
@Tag(value="vcf-nav-item")
public class AppNavItem
extends Component {
    private static final long serialVersionUID = 1L;

    public AppNavItem(String label) {
        this.setLabel(label);
    }

    public AppNavItem(String label, String path) {
        this.setPath(path);
        this.setLabel(label);
    }

    public AppNavItem(String label, Class<? extends Component> view) {
        this.setPath(view);
        this.setLabel(label);
    }

    public AppNavItem(String label, String path, Component icon) {
        this.setPath(path);
        this.setLabel(label);
        this.setIcon(icon);
    }

    public AppNavItem(String label, Class<? extends Component> view, Component icon) {
        this.setPath(view);
        this.setLabel(label);
        this.setIcon(icon);
    }

    public AppNavItem addItem(AppNavItem ... appNavItems) {
        for (AppNavItem appNavItem : appNavItems) {
            appNavItem.getElement().setAttribute("slot", "children");
            this.getElement().appendChild(new Element[]{appNavItem.getElement()});
        }
        return this;
    }

    public AppNavItem removeItem(AppNavItem appNavItem) {
        Optional parent = appNavItem.getParent();
        if (parent.isPresent() && parent.get() == this) {
            this.getElement().removeChild(new Element[]{appNavItem.getElement()});
        }
        return this;
    }

    public AppNavItem removeAllItems() {
        this.getElement().removeAllChildren();
        return this;
    }

    public String getLabel() {
        return this.getExistingLabelElement().map(e -> e.getText()).orElse(null);
    }

    public AppNavItem setLabel(String label) {
        this.getLabelElement().setText(label);
        return this;
    }

    private Optional<Element> getExistingLabelElement() {
        return this.getElement().getChildren().filter(child -> !child.hasAttribute("slot")).findFirst();
    }

    private Element getLabelElement() {
        return this.getExistingLabelElement().orElseGet(() -> {
            Element element = Element.createText((String)"");
            this.getElement().appendChild(new Element[]{element});
            return element;
        });
    }

    public AppNavItem setPath(String path) {
        this.getElement().setAttribute("path", path);
        return this;
    }

    public AppNavItem setPath(Class<? extends Component> view) {
        String url = RouteConfiguration.forRegistry((RouteRegistry)this.getRouter().getRegistry()).getUrl(view);
        this.setPath(url);
        return this;
    }

    private Router getRouter() {
        Router router = null;
        if (this.getElement().getNode().isAttached()) {
            StateTree tree = (StateTree)this.getElement().getNode().getOwner();
            router = tree.getUI().getInternals().getRouter();
        }
        if (router == null) {
            router = VaadinService.getCurrent().getRouter();
        }
        if (router == null) {
            throw new IllegalStateException("Implicit router instance is not available. Use overloaded method with explicit router parameter.");
        }
        return router;
    }

    public String getPath() {
        return this.getElement().getAttribute("path");
    }

    private int getIconElementIndex() {
        for (int i = 0; i < this.getElement().getChildCount(); ++i) {
            if (!"prefix".equals(this.getElement().getChild(i).getAttribute("slot"))) continue;
            return i;
        }
        return -1;
    }

    public AppNavItem setIcon(Component icon) {
        icon.getElement().setAttribute("slot", "prefix");
        int iconElementIndex = this.getIconElementIndex();
        if (iconElementIndex != -1) {
            this.getElement().setChild(iconElementIndex, icon.getElement());
        } else {
            this.getElement().appendChild(new Element[]{icon.getElement()});
        }
        return this;
    }

    public AppNavItem setExpanded(boolean value) {
        if (value) {
            this.getElement().setAttribute("expanded", "");
        } else {
            this.getElement().removeAttribute("expanded");
        }
        return this;
    }
}

