/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClienteIntegration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaComplementoService estruturaService;
    @Autowired
    private ClienteService clienteService;

    public void integracao(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        out.print(this.example());
    }

    public void getResponsavel(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        try {
            String token = request.getParameter("token");
            EstruturaComplemento estruturaCompl = this.estruturaService.getByTokenIntegration(token);
            if (estruturaCompl == null) {
                out.print("FORBIDEN");
                return;
            }
            Estrutura estrutura = estruturaCompl.getEstrutura();
            String cpfCnpj = request.getParameter("cpfCnpj");
            if (cpfCnpj.isEmpty()) {
                throw new Exception("cpfCnpj is empty");
            }
            Cliente cliente = this.clienteService.buscarPeloCnpj(cpfCnpj, estrutura);
            if (cliente == null) {
                throw new Exception("Cliente nao encontrado");
            }
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", true);
            jsonRetorno.put("cpfCnpj", (Object)cpfCnpj);
            jsonRetorno.put("nome", (Object)cliente.getNome());
            JSONArray arr = new JSONArray();
            for (ClienteResponsavel cr : cliente.getClienteResponsavel()) {
                JSONObject o = new JSONObject();
                o.put("login", (Object)cr.getEstruturaUsuario().getUsuario().getLogin());
                arr.put((Object)o);
            }
            jsonRetorno.put("responsavel", (Object)arr);
            out.print(jsonRetorno.toString());
        }
        catch (Exception e) {
            JSONObject jsonRetorno = new JSONObject();
            jsonRetorno.put("success", false);
            jsonRetorno.put("erro", (Object)e.getMessage());
            out.print(jsonRetorno.toString());
        }
        out.close();
    }

    private String example() {
        return "<html><head><title>Integra\u00e7\u00e3o Clientes</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o Clientes </u></strong></h4>\n<ul>\n GET RESPONS\u00c1VEIS <li>method - GET</li>\n <li>token - Obrigat\u00f3rio</li>\n <li>cpfCnpj - Obrigat\u00f3rio</li>\n</ul>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }
}

