/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteFornecedor;
import br.com.system.app.features.cliente.model.ClienteProduto;
import br.com.system.app.features.cliente.model.ClienteProdutoCadastro;
import br.com.system.app.features.cliente.model.ClienteProdutoDTO;
import br.com.system.app.features.cliente.repository.ClienteFornecedorRepository;
import br.com.system.app.features.cliente.repository.ClienteProdutoCadastroRepository;
import br.com.system.app.features.cliente.repository.ClienteProdutoRepository;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.datetime.FormatDate;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClienteProdutoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteProdutoRepository clienteProdutoRepository;
    @Autowired
    private ClienteFornecedorRepository clienteFornecedorRepository;
    @Autowired
    private ClienteProdutoCadastroRepository clienteProdutoCadastroRepository;
    @Autowired
    private ClienteLogService clienteLogService;

    public ClienteProduto salvar(ClienteProduto cp, EstruturaUsuario eu) {
        if (cp.getCliente() == null) {
            throw new BusinessException("Cliente \u00e9 obrigatorio.");
        }
        if (cp.getClienteFornecedor() == null) {
            throw new BusinessException("Fornecedor \u00e9 obrigatorio.");
        }
        if (cp.getClienteProdutoCadastro() == null) {
            throw new BusinessException("Produto \u00e9 obrigatorio.");
        }
        Object log = "";
        if (cp.getId() == null) {
            log = "Inserido produto " + cp.getClienteProdutoCadastro().getNome() + " Fornecedor " + cp.getClienteFornecedor().getNome() + " no cliente\n";
        } else {
            ClienteProduto gravado = (ClienteProduto)this.clienteProdutoRepository.findById((Object)cp.getId()).get();
            if (gravado.getClienteProdutoCadastro() != null && cp.getClienteProdutoCadastro() != null && !gravado.getClienteProdutoCadastro().getId().equals(cp.getClienteProdutoCadastro().getId())) {
                log = (String)log + "Produto de " + gravado.getClienteProdutoCadastro().getNome() + " para " + cp.getClienteProdutoCadastro().getNome() + "\n";
            }
            if (gravado.getClienteFornecedor() != null && cp.getClienteFornecedor() != null && !gravado.getClienteFornecedor().getId().equals(cp.getClienteFornecedor().getId())) {
                log = (String)log + "Fornecedor de " + gravado.getClienteFornecedor().getNome() + " para " + cp.getClienteFornecedor().getNome() + "\n";
            }
            if (gravado.getQuantidade() == null && cp.getQuantidade() != null || cp.getQuantidade() != null && !gravado.getQuantidade().equals(cp.getQuantidade())) {
                log = (String)log + "Quantidade de " + gravado.getQuantidade() + " para " + cp.getQuantidade() + "\n";
            }
            if (gravado.getValor() == null && cp.getValor() != null || cp.getValor() != null && !gravado.getValor().equals(cp.getValor())) {
                log = (String)log + "Valor de " + String.valueOf(gravado.getValor()) + " para " + String.valueOf(cp.getValor()) + "\n";
            }
            if (gravado.getDataAtivacao() == null && cp.getDataAtivacao() != null || gravado.getDataAtivacao() != null && cp.getDataAtivacao() == null || gravado.getDataAtivacao() != null && cp.getDataAtivacao() != null && !gravado.getDataAtivacao().equals(cp.getDataAtivacao())) {
                log = (String)log + "Ativacao de " + (gravado.getDataAtivacao() == null ? "" : gravado.getDataAtivacao().format(FormatDate.DATE_BR.toDTF()));
                log = (String)log + " para " + (cp.getDataAtivacao() == null ? "" : cp.getDataAtivacao().format(FormatDate.DATE_BR.toDTF())) + "\n";
            }
            if (gravado.getDataFidelidade() == null && cp.getDataFidelidade() != null || gravado.getDataFidelidade() != null && cp.getDataFidelidade() == null || gravado.getDataFidelidade() != null && cp.getDataFidelidade() != null && !gravado.getDataFidelidade().equals(cp.getDataFidelidade())) {
                log = (String)log + "Fideliade de " + (gravado.getDataFidelidade() == null ? "" : gravado.getDataFidelidade().format(FormatDate.DATE_BR.toDTF()));
                log = (String)log + " para " + (cp.getDataFidelidade() == null ? "" : cp.getDataFidelidade().format(FormatDate.DATE_BR.toDTF())) + "\n";
            }
        }
        this.clienteLogService.salvar(cp.getCliente(), eu, (String)log);
        return (ClienteProduto)this.clienteProdutoRepository.save((Object)cp);
    }

    public ClienteProduto getByClienteAndFornecedorAndProduto(Cliente cliente, ClienteFornecedor fornecedor, ClienteProdutoCadastro cpc) {
        return this.clienteProdutoRepository.findFirstByClienteAndClienteFornecedorAndClienteProdutoCadastro(cliente, fornecedor, cpc);
    }

    public List<ClienteProduto> getByCliente(Cliente cliente) {
        return this.clienteProdutoRepository.findByCliente(cliente);
    }

    public void delete(ClienteProduto cp, EstruturaUsuario eu) {
        this.clienteLogService.salvar(cp.getCliente(), eu, "Produto " + cp.getClienteProdutoCadastro().getNome() + " operadora " + cp.getClienteProdutoCadastro().getNome() + " excluido");
        this.clienteProdutoRepository.delete((Object)cp);
    }

    public void deleteByCliente(Cliente cliente) {
        this.clienteProdutoRepository.deleteByCliente(cliente);
    }

    public List<ClienteFornecedor> getFornecedores(EstruturaTipo et) {
        return this.clienteFornecedorRepository.findByEstruturaTipo(et);
    }

    public ClienteFornecedor getFornecedorByNome(EstruturaTipo et, String nome) {
        return this.clienteFornecedorRepository.findByEstruturaTipoAndNome(et, nome);
    }

    public List<ClienteProdutoCadastro> getProdutos(EstruturaTipo et) {
        return this.clienteProdutoCadastroRepository.findByEstruturaTipo(et);
    }

    public ClienteProdutoCadastro getProdutoByNome(EstruturaTipo et, String nome) {
        return this.clienteProdutoCadastroRepository.findFirstByEstruturaTipoAndNome(et, nome);
    }

    public List<ClienteProdutoDTO> getProdutos(EstruturaUsuario eu, Set<Long> clientesId) {
        try {
            return this.clienteProdutoRepository.findProdutos(eu, clientesId);
        }
        catch (Exception e) {
            return null;
        }
    }
}

