/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteAnexo;
import br.com.system.app.features.cliente.model.ClienteClassificacao;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoDTO;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteFilter;
import br.com.system.app.features.cliente.model.ClienteLastOrderDTO;
import br.com.system.app.features.cliente.model.ClienteProdutoDTO;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.model.ClienteResponsavelDTO;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.model.ClienteTagsActionEnum;
import br.com.system.app.features.cliente.model.ClienteTrigger;
import br.com.system.app.features.cliente.model.ClienteVencimento;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.repository.ClienteClassificacaoRepository;
import br.com.system.app.features.cliente.repository.ClienteContatoRepository;
import br.com.system.app.features.cliente.repository.ClienteRepository;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.cliente.service.ClienteCopyMailing;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.cliente.service.ClienteVencimentoService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.naoperturbe.service.NaoPerturbeService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.pessoa.model.PessoaDTO;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private EstruturaTipoService estruturaTipoService;
    @Autowired
    private ClienteTagService clienteTagService;
    @Autowired
    private ClienteContatoRepository clienteContatoRepository;
    @Autowired
    private ClienteLogService clienteLogService;
    @Autowired
    private ClienteClassificacaoRepository clienteClassificacaoRepository;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private ClienteProdutoService clienteProdutoService;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private NaoPerturbeService naoPerturbeService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoTagsService pedidoTagsService;
    @Autowired
    private ClienteAnexoService clienteAnexoService;
    @Autowired
    private ClienteVencimentoService clienteVencimentoService;

    public boolean possoAlterar(Cliente cliente, EstruturaUsuario eu) {
        if (!eu.haveRole("CLIENTE_CARTEIRA_APENAS_ENCARTEIRADO")) {
            return true;
        }
        if (cliente == null || cliente.getClienteResponsavel() == null || cliente.getClienteResponsavel().size() <= 0) {
            return true;
        }
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        for (Long h : hierarquia) {
            for (ClienteResponsavel cr : cliente.getClienteResponsavel()) {
                if (!cr.getEstruturaUsuario().equals((Object)eu) && !cr.getEstruturaUsuario().getId().equals(h)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean souResponsavel(Cliente cliente, EstruturaUsuario eu, PedidoTipoEnum tipo, Boolean criarMesmoEncarteirado) {
        if (cliente.getClienteResponsavel().size() <= 0) {
            return true;
        }
        if (criarMesmoEncarteirado.booleanValue()) {
            return true;
        }
        if (eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO)) {
            return true;
        }
        if (eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.ADMINISTRATIVO) && tipo.equals((Object)PedidoTipoEnum.POS_VENDA)) {
            return true;
        }
        boolean estou = false;
        for (ClienteResponsavel cr : cliente.getClienteResponsavel()) {
            if (!cr.getEstruturaUsuario().equals((Object)eu)) continue;
            estou = true;
            break;
        }
        return estou;
    }

    public String exportarContatos(EstruturaUsuario eu, Set<ClienteDTO> clientes) {
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        HashSet<String> cnpjs = new HashSet<String>();
        for (ClienteDTO d : clientes) {
            cnpjs.add(d.getCpfCnpj());
        }
        HashMap lista = this.prepara(eu.getEstrutura(), cnpjs);
        try {
            isModelo = StorageUtil.getObjectModelo((String)"ExportacaoContatos-v3.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            Sheet aba = appXls.getSheet("Exportacao");
            int l = 1;
            for (ClienteDTO c : clientes) {
                try {
                    HashMap contatos = this.getContatos(c.getCpfCnpj(), lista);
                    for (Map.Entry hmContatos : contatos.entrySet()) {
                        try {
                            if (hmContatos.getKey() == null || ((String)hmContatos.getKey()).isEmpty()) continue;
                            Row row = aba.createRow(l);
                            row.createCell(0).setCellValue(c.getCpfCnpj());
                            row.createCell(1).setCellValue(c.getNome());
                            row.createCell(2).setCellValue(c.getTags());
                            row.createCell(3).setCellValue(((ClienteContatoDTO)hmContatos.getValue()).getTipo());
                            row.createCell(4).setCellValue((String)hmContatos.getKey());
                            row.createCell(5).setCellValue(((ClienteContatoDTO)hmContatos.getValue()).getVerificado());
                            row.createCell(6).setCellValue(((ClienteContatoDTO)hmContatos.getValue()).getNivelRelevancia());
                            ++l;
                            row = null;
                        }
                        catch (Exception exception) {}
                    }
                    contatos.clear();
                    contatos = null;
                }
                catch (Exception exception) {}
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                lista = null;
                cnpjs = null;
                isModelo.close();
                appXls.close();
                isModelo = null;
                appXls = null;
            }
            catch (Exception exception) {}
        }
    }

    private HashMap<String, Set<ClienteContatoDTO>> prepara(Estrutura estrutura, Set<String> cnpjs) {
        List lista = this.clienteContatoRepository.findCnpjs(estrutura, cnpjs);
        HashMap<String, Set<ClienteContatoDTO>> retorno = new HashMap<String, Set<ClienteContatoDTO>>();
        for (ClienteContatoDTO d : lista) {
            Set<Object> s;
            if (retorno.containsKey(d.getCpfCnpj())) {
                s = retorno.get(d.getCpfCnpj());
                s.add(d);
                retorno.put(d.getCpfCnpj(), s);
                continue;
            }
            s = new HashSet<ClienteContatoDTO>();
            s.add(d);
            retorno.put(d.getCpfCnpj(), s);
        }
        return retorno;
    }

    private HashMap<String, ClienteContatoDTO> getContatos(String cnpj, HashMap<String, Set<ClienteContatoDTO>> map) {
        HashMap<String, ClienteContatoDTO> retorno = new HashMap<String, ClienteContatoDTO>();
        Set<ClienteContatoDTO> contatos = map.get(cnpj);
        for (ClienteContatoDTO d : contatos) {
            try {
                boolean valido = d.getTipo().equals(TipoContatoEnum.EMAIL.name()) && ValidationUtil.isValidEmail((String)d.getValor()) || d.getTipo().equals(TipoContatoEnum.TELEFONE.name()) && TelefoneUtil.isValid((String)d.getValor());
                if (!valido || retorno.containsKey(d.getValor())) continue;
                retorno.put(d.getValor(), d);
            }
            catch (Exception exception) {}
        }
        return retorno;
    }

    public boolean permiteAbrirDadosExtras(EstruturaUsuario eu, Cliente cliente) {
        if (eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO)) {
            return true;
        }
        if (eu.haveRole("CLIENTE_CARTEIRA_VER_TUDO")) {
            return true;
        }
        for (ClienteResponsavel cr : cliente.getClienteResponsavel()) {
            if (!cr.getEstruturaUsuario().getId().equals(eu.getId())) continue;
            return true;
        }
        return false;
    }

    public Cliente getById(Long id) {
        if (id == null) {
            return null;
        }
        return (Cliente)this.clienteRepository.findById((Object)id).get();
    }

    public Set<ClienteDTO> filter(ClienteFilter filter, EstruturaUsuario euContext, Pageable pageable) {
        Set result = this.clienteRepository.filterCliente(filter, euContext, pageable);
        return result;
    }

    public int count(ClienteFilter filter, EstruturaUsuario euContext) {
        return (int)this.clienteRepository.countCliente(filter, euContext);
    }

    @Async(value="asyncDefault")
    public void getFromMailing(Estrutura estrutura, String cnpj, Consumer<Cliente> listenerFound, Consumer<String> listenerNotFound, Consumer<String> listenerNotExist) {
        if (cnpj.length() != 14) {
            listenerNotExist.accept("CPF n\u00e3o encontrado, criando...");
            return;
        }
        Mailing mailing = this.mailingService.justGet(cnpj);
        if (mailing != null) {
            listenerFound.accept(this.converMailingToCliente(mailing, estrutura));
            return;
        }
        listenerNotFound.accept("Este cnpj ainda n\u00e3o est\u00e1 na nossa base, vamos sincroniza-lo com a receita agora.<BR>Lamentamos, isso pode demorar um pouquinho...");
        mailing = this.mailingService.getInReceitaws(mailing, cnpj);
        if (mailing == null) {
            listenerNotExist.accept("N\u00e3o achamos esse CNPJ, pode ser que a receita federal esteja com instabilidade. Que tal tentar mais tarde?");
            return;
        }
        listenerFound.accept(this.converMailingToCliente(mailing, estrutura));
    }

    public Cliente getFromMailing(Estrutura estrutura, String cnpj) {
        if (cnpj.length() != 14) {
            return null;
        }
        Mailing mailing = this.mailingService.justGet(cnpj);
        if (mailing != null) {
            return this.converMailingToCliente(mailing, estrutura);
        }
        if ((mailing = this.mailingService.getInReceitaws(mailing, cnpj)) == null) {
            return null;
        }
        return this.converMailingToCliente(mailing, estrutura);
    }

    @Transactional
    public Cliente converMailingToCliente(Mailing mailing, Estrutura estrutura) {
        Cliente clienteMailing = new ClienteCopyMailing().convertMailingToCliente(mailing);
        clienteMailing.setEstrutura(estrutura);
        return clienteMailing;
    }

    @Transactional
    public Cliente salvar(Cliente cliente, EstruturaUsuario eu) {
        return this.salvar(cliente, eu, null);
    }

    @Transactional
    public Cliente salvar(Cliente cliente, EstruturaUsuario eu, Set<ClienteContato> contatos) {
        if (contatos != null) {
            contatos.forEach(e -> {
                if (e.getTipo() != null && e.getTipo().equals((Object)TipoContatoEnum.EMAIL) && e.getValor() != null && ValidationUtil.isValidEmail((String)e.getValor().toLowerCase().trim())) {
                    e.setValor(e.getValor().toLowerCase().trim());
                } else if (e.getTipo() != null && e.getTipo().equals((Object)TipoContatoEnum.TELEFONE) && e.getValor() != null && TelefoneUtil.isValid((String)e.getValor())) {
                    e.setValor(TelefoneUtil.normalize((String)e.getValor()));
                }
                if (e.getNivelRelevancia() == null) {
                    e.setNivelRelevancia(Integer.valueOf(0));
                }
                if (e.getVerificado() == null) {
                    e.setVerificado(ClienteContatoVerficadoEnum.NAO_VERIFICADO);
                }
            });
        }
        cliente.getClienteContato().forEach(e -> {
            if (e.getTipo() != null && e.getTipo().equals((Object)TipoContatoEnum.EMAIL) && e.getValor() != null && ValidationUtil.isValidEmail((String)e.getValor().toLowerCase().trim())) {
                e.setValor(e.getValor().toLowerCase().trim());
            } else if (e.getTipo() != null && e.getTipo().equals((Object)TipoContatoEnum.TELEFONE) && e.getValor() != null && TelefoneUtil.isValid((String)e.getValor())) {
                e.setValor(StringUtil.numbersOnly((String)e.getValor()));
            }
            if (e.getValor() != null && !e.getValor().isEmpty() && e.getTipo().equals((Object)TipoContatoEnum.TELEFONE) && this.naoPerturbeService.isNaoPerturbe(e.getValor())) {
                e.setVerificado(ClienteContatoVerficadoEnum.NAO_PERTURBE);
            }
            if (e.getNivelRelevancia() == null) {
                e.setNivelRelevancia(Integer.valueOf(0));
            }
            if (e.getVerificado() == null) {
                e.setVerificado(ClienteContatoVerficadoEnum.NAO_VERIFICADO);
            }
            if (contatos != null) {
                Iterator iterator = contatos.iterator();
                while (iterator.hasNext()) {
                    ClienteContato contato = (ClienteContato)iterator.next();
                    if (!contato.getTipo().equals((Object)e.getTipo()) || !contato.getValor().equals(e.getValor())) continue;
                    iterator.remove();
                }
            }
        });
        if (contatos != null) {
            for (ClienteContato cc : contatos) {
                if (cc.getValor() == null || cc.getValor().isEmpty()) continue;
                if (cc.getTipo().equals((Object)TipoContatoEnum.TELEFONE) && this.naoPerturbeService.isNaoPerturbe(cc.getValor())) {
                    cc.setVerificado(ClienteContatoVerficadoEnum.NAO_PERTURBE);
                }
                cliente.getClienteContato().add(cc);
            }
        }
        Iterator iterator = cliente.getClienteContato().iterator();
        while (iterator.hasNext()) {
            ClienteContato contato = (ClienteContato)iterator.next();
            if (contato.getValor() != null && !contato.getValor().isEmpty() && (!contato.getTipo().equals((Object)TipoContatoEnum.EMAIL) || ValidationUtil.isValidEmail((String)contato.getValor())) && (!contato.getTipo().equals((Object)TipoContatoEnum.TELEFONE) || TelefoneUtil.isValid((String)contato.getValor()))) continue;
            iterator.remove();
        }
        if (cliente.getCadastroWhatsapp() == null) {
            cliente.setCadastroWhatsapp(Boolean.valueOf(false));
        }
        if (cliente.getEstrutura() == null && cliente.getId() == null) {
            cliente.setEstrutura(eu.getEstrutura());
        }
        if (!cliente.getEstrutura().equals((Object)eu.getEstrutura())) {
            throw new BusinessException("Cliente n\u00e3o pertence a esta estrutura.");
        }
        cliente.setTags(this.clienteTagService.saveTags(cliente.getTags(), eu));
        boolean inserindo = cliente.getId() == null;
        try {
            if (!inserindo) {
                this.clienteLogService.log(cliente, this.getById(cliente.getId()), eu);
            }
        }
        catch (Exception e2) {
            LoggerFactory.getLogger(ClienteService.class).error(e2.getMessage());
        }
        cliente = this.persistir(cliente, eu);
        if (inserindo) {
            this.clienteLogService.salvar(cliente, eu, "Inserindo Cliente");
        }
        return cliente;
    }

    public Cliente getAndCreateCliente(EstruturaUsuario eu, String cpfCnpj, ClienteContato ... contatos) {
        return this.getAndCreateCliente(eu, cpfCnpj, "", contatos);
    }

    public Cliente getAndCreateCliente(EstruturaUsuario eu, String cpfCnpj, String nome, ClienteContato ... contatos) {
        HashSet<ClienteContato> cc = new HashSet<ClienteContato>();
        for (ClienteContato contato : contatos) {
            cc.add(contato);
        }
        return this.getAndCreateCliente(eu, cpfCnpj, nome, cc);
    }

    public Cliente getAndCreateCliente(EstruturaUsuario eu, String cpfCnpj, String nome, Set<ClienteContato> contatos) {
        return this.getAndCreateCliente(eu, cpfCnpj, nome, contatos, "");
    }

    public Cliente getAndCreateCliente(EstruturaUsuario eu, String cpfCnpj, String nome, Set<ClienteContato> contatos, String inscricaoEstadual) {
        if ((cpfCnpj = StringUtil.numbersOnly((String)cpfCnpj)).isEmpty()) {
            throw new BusinessException("Cnpj n\u00e3o informado");
        }
        if (!ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
            throw new BusinessException("Cpf/cnpj inv\u00e1lido");
        }
        if (eu == null || eu.getEstrutura() == null) {
            return null;
        }
        Cliente cliente = this.buscarPeloCnpj(cpfCnpj, eu.getEstrutura());
        if (cliente != null && contatos.size() <= 0) {
            return cliente;
        }
        if (cliente == null) {
            cliente = this.getFromMailing(eu.getEstrutura(), cpfCnpj);
        }
        if (cliente == null) {
            cliente = new Cliente();
            cliente.setCpfCnpj(cpfCnpj);
            cliente.setNome(nome);
        }
        cliente.setInscricaoEstadual(inscricaoEstadual == null ? "" : inscricaoEstadual);
        return this.salvar(cliente, eu, contatos);
    }

    @Transactional
    private Cliente persistir(Cliente cliente, EstruturaUsuario eu) {
        try {
            if (!ValidationUtil.isValidCnpjAndCpf((String)cliente.getCpfCnpj())) {
                throw new BusinessException("Cpf/cnpj inv\u00e1lido");
            }
            if (cliente.getEstrutura() == null) {
                throw new BusinessException("Estrutura obrigatoria");
            }
            cliente.getPessoas().forEach(pessoas -> pessoas.setCliente(cliente));
            cliente.getClienteContato().forEach(contato -> contato.setCliente(cliente));
            if (cliente.getTags() == null) {
                cliente.setTags("");
            }
            return (Cliente)this.clienteRepository.save((Object)cliente);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ClienteService.class).error(e.getMessage());
            return cliente;
        }
    }

    public Cliente buscarPeloId(Long id) {
        if (id == null) {
            return null;
        }
        return this.clienteRepository.findById((Object)id).orElse(null);
    }

    public Cliente buscarPeloCnpj(String cnpj, Estrutura estrutura) {
        return this.clienteRepository.findByCpfCnpjAndEstrutura(cnpj, estrutura);
    }

    public Cliente buscarPeloCnpj(String cnpj, Long idEstrutura) {
        Estrutura estrutura = this.estruturaService.getById(idEstrutura);
        return this.buscarPeloCnpj(cnpj, estrutura);
    }

    public void excluirResponsaveis(EstruturaUsuario eu, Set<ClienteDTO> clientes, HierarquiaDTO hierarquia) {
        for (ClienteDTO dto : clientes) {
            this.excluirResponsaveis(eu, dto.getId(), hierarquia.getEstruturaUsuarioId());
        }
    }

    public void excluirResponsaveis(EstruturaUsuario eu, Long clienteId, Long euId) {
        Cliente cliente = this.getById(clienteId);
        cliente.getClienteResponsavel().forEach(item -> {
            if (item.getEstruturaUsuario().getId().equals(euId)) {
                cliente.getClienteResponsavel().remove(item);
            }
        });
    }

    public void insereResponsaveis(EstruturaUsuario eu, Long clienteId, Long estruturaUsuarioId) {
        Cliente cliente = this.getById(clienteId);
        EstruturaUsuario euH = this.estruturaUsuarioService.getById(estruturaUsuarioId);
        if (this.inserirResponsavel(cliente.getClienteResponsavel(), euH)) {
            cliente.getClienteResponsavel().add(new ClienteResponsavel(cliente, euH));
            this.salvar(cliente, eu);
        }
    }

    @Async(value="asyncDefault")
    public void insereResponsaveis(EstruturaUsuario eu, Set<ClienteDTO> clientes, Set<HierarquiaDTO> hierarquia) {
        Object mensagem = "";
        for (ClienteDTO dto : clientes) {
            Cliente cliente = this.getById(dto.getId());
            mensagem = (String)mensagem + "Cliente " + cliente.getNome() + " atribuido<BR>";
            for (HierarquiaDTO h : hierarquia) {
                EstruturaUsuario euH = this.estruturaUsuarioService.getById(h.getEstruturaUsuarioId());
                if (!this.inserirResponsavel(cliente.getClienteResponsavel(), euH)) continue;
                cliente.getClienteResponsavel().add(new ClienteResponsavel(cliente, euH));
            }
            this.salvar(cliente, eu);
        }
        this.notificacoesService.notify(eu, "Atribui\u00e7\u00e3o respons\u00e1veis", (String)mensagem);
    }

    private boolean inserirResponsavel(Set<ClienteResponsavel> responsaveis, EstruturaUsuario euH) {
        boolean inserir = true;
        for (ClienteResponsavel cr : responsaveis) {
            if (!cr.getEstruturaUsuario().equals((Object)euH)) continue;
            inserir = false;
            break;
        }
        return inserir;
    }

    @Transactional
    public void alterarTags(ClienteTagsActionEnum action, EstruturaUsuario eu, Set<ClienteDTO> clientes, String tags) {
        if (!tags.isEmpty()) {
            tags = this.clienteTagService.saveTags(tags, eu);
        }
        HashSet<Long> l = new HashSet<Long>();
        for (ClienteDTO dto : clientes) {
            l.add(dto.getId());
        }
        this.clienteRepository.updateListaClienteTags(eu.getEstrutura(), action, tags, l);
        this.clienteLogService.logTag(clientes, action, eu, tags);
    }

    public List<ClienteLastOrderDTO> getByTrigger(Estrutura estrutura, ClienteTrigger trigger) {
        ArrayList<ClienteLastOrderDTO> retorno = new ArrayList<ClienteLastOrderDTO>();
        List triggers = this.clienteRepository.getByTriggers(estrutura, trigger);
        for (ClienteLastOrderDTO t : triggers) {
            long dif;
            Pedido last = this.pedidoService.getLast(estrutura, t.getId());
            if (last == null || (dif = DateTimeUtil.diferencaEmDias((LocalDate)last.getDataHoraAtualizacao().toLocalDate(), (LocalDate)LocalDate.now())) < (long)trigger.getDias().intValue()) continue;
            retorno.add(t);
        }
        return retorno;
    }

    public Cliente getByTelefone(String telefone) {
        ClienteContato cc = this.clienteContatoRepository.findFirstByTipoAndValor(TipoContatoEnum.TELEFONE, telefone);
        if (cc == null) {
            return null;
        }
        return cc.getCliente();
    }

    public List<ClienteClassificacao> getClassificacao(EstruturaTipo et) {
        return this.clienteClassificacaoRepository.findByEstruturaTipo(et);
    }

    public ClienteClassificacao getByNome(EstruturaTipo et, String nome) {
        return this.clienteClassificacaoRepository.findFirstByEstruturaTipoAndNome(et, nome);
    }

    public String exportarResponsaveis(EstruturaUsuario eu, Set<ClienteDTO> listaCli) {
        List responsaveis = this.clienteRepository.getResponsaveis(eu.getEstrutura(), listaCli);
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        try {
            isModelo = StorageUtil.getObjectModelo((String)"ExportacaoResponsaveis-v3.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            Sheet aba = appXls.getSheet("Exportacao");
            int l = 1;
            for (ClienteResponsavelDTO r : responsaveis) {
                try {
                    Row row = aba.createRow(l);
                    row.createCell(0).setCellValue(r.getCpfCnpj());
                    row.createCell(1).setCellValue(r.getNomeCliente());
                    row.createCell(2).setCellValue(r.getTagCliente());
                    row.createCell(3).setCellValue(r.getNomeResponsavel());
                    row.createCell(4).setCellValue(r.getLoginResponsavel());
                    row.createCell(5).setCellValue(r.getNomeEquipe());
                    row.createCell(6).setCellValue(r.getTagUsuario());
                    ++l;
                }
                catch (Exception exception) {}
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                responsaveis = null;
                isModelo.close();
                appXls.close();
                isModelo = null;
                appXls = null;
            }
            catch (Exception exception) {}
        }
    }

    public String exportarPessoas(EstruturaUsuario eu, Set<ClienteDTO> listaCli) {
        List pessoas = this.clienteRepository.getPessoas(eu.getEstrutura(), listaCli);
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoPessoas-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            int linha = 1;
            int col = 0;
            for (PessoaDTO p : pessoas) {
                col = 0;
                Row row = aba.createRow(linha);
                row.createCell(col).setCellValue(p.getCpfCnpj());
                row.createCell(++col).setCellValue(p.getNomeCliente());
                row.createCell(++col).setCellValue(p.getNomePessoa() == null ? "" : p.getNomePessoa());
                row.createCell(++col).setCellValue(p.getCelular() == null ? "" : p.getCelular());
                row.createCell(++col).setCellValue(p.getTelefone() == null ? "" : p.getTelefone());
                row.createCell(++col).setCellValue(p.getCpf() == null ? "" : p.getCpf());
                row.createCell(++col).setCellValue(p.getRg() == null ? "" : p.getRg());
                row.createCell(++col).setCellValue(p.getEmail() == null ? "" : p.getEmail());
                row.createCell(++col).setCellValue(p.getNascimento() == null ? "" : p.getNascimento().format(FormatDate.DATE_BR.toDTF()));
                row.createCell(++col).setCellValue(p.getPapel() == null ? "" : p.getPapel());
                ++linha;
                row = null;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }

    public String exportarDadosBasicos(EstruturaUsuario eu, Set<ClienteDTO> listaCli) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoClientes-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            int linha = 1;
            int col = 0;
            for (ClienteDTO p : listaCli) {
                col = 0;
                Row row = aba.createRow(linha);
                row.createCell(col).setCellValue(p.getCpfCnpj());
                row.createCell(++col).setCellValue(this.getField((Object)p.getNome()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getCep()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getLogradouro()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getNumero()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getComplemento()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getBairro()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getCidade()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getEstado()));
                row.createCell(++col).setCellValue(this.getField((Object)p.getTags()));
                ++linha;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
    }

    public List<Cliente> getByEstrutura(Estrutura estrutura) {
        return this.clienteRepository.findByEstrutura(estrutura);
    }

    public List<Cliente> getByEstrutura(Estrutura estrutura, Pageable pageable) {
        return this.clienteRepository.findByEstrutura(estrutura, pageable);
    }

    public Integer countByEstrutura(Estrutura estrutura) {
        return this.clienteRepository.countByEstrutura(estrutura).intValue();
    }

    public String exportarProdutos(EstruturaUsuario eu, Set<ClienteDTO> clientes) {
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        HashSet<Long> ids = new HashSet<Long>();
        for (ClienteDTO d : clientes) {
            ids.add(d.getId());
        }
        List produtos = this.clienteProdutoService.getProdutos(eu, ids);
        try {
            isModelo = StorageUtil.getObjectModelo((String)"ExportacaoClienteProdutos-v1.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            Sheet aba = appXls.getSheet("Exportacao");
            int l = 1;
            if (!this.estruturaTipoService.isTelefonia(eu.getEstrutura())) {
                aba.setColumnHidden(9, true);
            }
            if (!this.estruturaTipoService.isTicket(eu.getEstrutura())) {
                aba.setColumnHidden(6, true);
            }
            for (ClienteDTO c : clientes) {
                try {
                    Set prods = this.getProdutos(c, produtos);
                    if (prods.size() <= 0) {
                        Row row = aba.createRow(l);
                        row.createCell(0).setCellValue(c.getCpfCnpj());
                        row.createCell(1).setCellValue(c.getNome());
                        row.createCell(2).setCellValue(c.getTags());
                        ++l;
                        row = null;
                    }
                    for (ClienteProdutoDTO prod : prods) {
                        Row row = aba.createRow(l);
                        int i = 0;
                        row.createCell(i).setCellValue(c.getCpfCnpj());
                        row.createCell(++i).setCellValue(c.getNome());
                        row.createCell(++i).setCellValue(c.getTags());
                        row.createCell(++i).setCellValue(prod.getFornecedor());
                        row.createCell(++i).setCellValue(prod.getProdutoCadastro());
                        row.createCell(++i).setCellValue(prod.getQuantidade() == null ? 0.0 : (double)prod.getQuantidade().intValue());
                        row.createCell(++i).setCellValue(prod.getQuantidadeDias() == null ? 0.0 : (double)prod.getQuantidadeDias().intValue());
                        row.createCell(++i).setCellValue(prod.getValor() == null ? "" : prod.getValor().toString());
                        row.createCell(++i).setCellValue(prod.getDesconto() == null ? "" : prod.getDesconto().toString());
                        row.createCell(++i).setCellValue(prod.getDataAtivacao() == null ? "" : prod.getDataAtivacao().format(FormatDate.DATE_BR.toDTF()));
                        row.createCell(++i).setCellValue(prod.getDataFidelidade() == null ? "" : prod.getDataFidelidade().format(FormatDate.DATE_BR.toDTF()));
                        ++l;
                        row = null;
                    }
                    prods.clear();
                    prods = null;
                }
                catch (Exception exception) {}
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                ids = null;
                isModelo.close();
                appXls.close();
                isModelo = null;
                appXls = null;
            }
            catch (Exception exception) {}
        }
    }

    public String exportarVencimentos(EstruturaUsuario eu, Set<ClienteDTO> listaCli) {
        Set clientes = this.clienteVencimentoService.getByClienteList(listaCli);
        InputStream isModelo = null;
        XSSFWorkbook appXls = null;
        try {
            isModelo = StorageUtil.getObjectModelo((String)"ExportacaoVencimento-v1.xlsx");
            appXls = new XSSFWorkbook(isModelo);
            Sheet sheet = appXls.getSheet("Exportacao");
            int l = 1;
            for (ClienteVencimento clienteVencimento : clientes) {
                try {
                    Row row = sheet.createRow(l);
                    row.createCell(0).setCellValue(clienteVencimento.getCliente().getCpfCnpj());
                    row.createCell(1).setCellValue(clienteVencimento.getCliente().getNome());
                    row.createCell(2).setCellValue(clienteVencimento.getNome());
                    row.createCell(3).setCellValue((double)clienteVencimento.getDia().intValue());
                    row.createCell(4).setCellValue(clienteVencimento.getApartir().format(FormatDate.DATE_BR.toDTF()));
                    row.createCell(5).setCellValue(clienteVencimento.getAte().format(FormatDate.DATE_BR.toDTF()));
                    ++l;
                }
                catch (Exception exception) {}
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)appXls);
            String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            try {
                clientes = null;
                isModelo.close();
                appXls.close();
                isModelo = null;
                appXls = null;
            }
            catch (Exception exception) {}
        }
    }

    private Set<ClienteProdutoDTO> getProdutos(ClienteDTO c, List<ClienteProdutoDTO> produtos) {
        HashSet<ClienteProdutoDTO> ret = new HashSet<ClienteProdutoDTO>();
        for (ClienteProdutoDTO cp : produtos) {
            if (!cp.getClienteId().equals(c.getId())) continue;
            ret.add(cp);
        }
        return ret;
    }

    @Transactional
    public void removerTag(List<ClienteTag> tags, EstruturaUsuario eu) {
        Thread.currentThread().setName("asyncDefault-excluir-tag");
        StringBuilder msg = new StringBuilder();
        for (ClienteTag tag : tags) {
            try {
                this.removerTag(tag, eu);
                msg.append("Tag ").append(tag.getTag()).append(" excluida com sucesso\n");
            }
            catch (Exception e) {
                msg.append("Tag ").append(tag.getTag()).append(" Erro: ").append(e.getMessage()).append("\n");
            }
        }
        this.notificacoesService.notify(eu, "Exclus\u00e3o de tags Cliente", msg.toString());
    }

    @Transactional
    public void removerTag(ClienteTag tag, EstruturaUsuario eu) throws Exception {
        HashSet<ClienteTag> htag = new HashSet<ClienteTag>();
        htag.add(tag);
        ClienteFilter filter = new ClienteFilter();
        filter.setTags(htag);
        filter.setBairroFilters(new HashSet());
        filter.setCepFilters(new HashSet());
        filter.setCidadeFilters(new HashSet());
        filter.setDocsFilters(new HashSet());
        filter.setEstado("");
        filter.setNome("");
        filter.setTemWhats("Ignorar");
        filter.setResponsaveis(new HashSet());
        HashSet lCliente = new HashSet(this.filter(filter, eu, null));
        if (!lCliente.isEmpty()) {
            this.alterarTags(ClienteTagsActionEnum.EXCLUIR, eu, lCliente, tag.getTag());
        }
    }

    private String getField(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public void distribuir(EstruturaUsuario eu, Set<ClienteDTO> cl, Set<Long> listaEu, String informacoes, PedidoTipoEnum tipo, Set<PedidoTags> tags) {
        StringBuilder s = new StringBuilder();
        int ind = 0;
        ArrayList<Long> u = new ArrayList<Long>(listaEu);
        for (ClienteDTO c : cl) {
            try {
                ind = ind >= u.size() ? 0 : ind;
                EstruturaUsuario euDistribuicao = this.estruturaUsuarioService.getById((Long)u.get(ind));
                Pedido p = new Pedido();
                p.setCliente(this.getById(c.getId()));
                p.setComplementos("Criado em lote via tela de clientes<BR>" + informacoes);
                p.setDataCadastro(LocalDate.now());
                p.setEstruturaUsuario(euDistribuicao);
                p.setPedidoTipo(tipo);
                p.setTags(this.pedidoTagsService.getStringtags(tags));
                this.pedidoService.salvar(p);
                s.append("Cliente ").append(c.getNome()).append(" atividade criada com sucesso\n");
                ++ind;
            }
            catch (Exception ex) {
                s.append("Cliente ").append(c.getNome()).append(" erro: ").append(ex.getMessage()).append("\n");
            }
        }
        this.notificacoesService.notify(eu, "Cria\u00e7\u00e3o Atividades", s.toString());
    }

    public void delete(Cliente cliente, Boolean excluirAnexoBucket) throws Exception {
        List anexo = this.clienteAnexoService.getAnexo(cliente);
        for (ClienteAnexo clienteAnexo : anexo) {
            this.clienteAnexoService.delete(clienteAnexo, excluirAnexoBucket);
        }
        this.clienteLogService.deleteByCliente(cliente);
        this.clienteProdutoService.deleteByCliente(cliente);
    }
}

