/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.view.ClienteContatoComp;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.DialogProgressBar;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteContatoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private ClienteContatoComp clienteContatoComp;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private TelefoneService telefoneService;
    @Autowired
    private PortabilidadeConsultaService portabilidadeConsultaService;
    private final VerticalLayout containerContatos = new VerticalLayout();
    private Cliente cliente;
    private Long pedidoId;
    private final DialogProgressBar progress = new DialogProgressBar();
    private VerticalContainer mainLayout;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void show(Cliente cliente, Long pedidoId) {
        UIUtils.removePadding((com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this});
        this.setCloseOnOutsideClick(false);
        this.containerContatos.setId("containerContatos");
        this.containerContatos.setWidth("100%");
        this.containerContatos.setHeight("100%");
        this.cliente = cliente;
        this.pedidoId = pedidoId;
        this.clienteContatoComp = new ClienteContatoComp(this.telefoneService, this.portabilidadeConsultaService);
        this.removeAll();
        this.containerContatos.removeAll();
        this.mainLayout = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.add(new com.vaadin.flow.component.Component[]{this.mainLayout});
        Button bClose = UIUtils.createSmallButton((String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        Button btnGoBottom = UIUtils.createSmallButton((Icon)VaadinIcon.ARROW_CIRCLE_DOWN.create(), (String)"Ir ao final da conversa");
        btnGoBottom.addClickListener((ComponentEventListener & Serializable)e -> this.goBootom());
        Button btnGoUp = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_CIRCLE_UP, (String)"Ir para o TOPO");
        btnGoBottom.addClickListener((ComponentEventListener & Serializable)e -> this.goUp());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        btnSalvar.setEnabled(this.hasPermission("CLIENTE_SAVE") && this.clienteService.possoAlterar(cliente, this.getEu()));
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            cliente.setClienteContato(new HashSet(this.clienteContatoComp.getValue()));
            this.clienteService.salvar(cliente, this.getEu());
            this.close();
        });
        this.mainLayout.setMargin(false);
        this.mainLayout.setHeight("95%");
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.containerContatos});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{bClose, btnGoUp, btnGoBottom, btnSalvar})});
        this.open();
        this.povoaContatos();
    }

    private void povoaContatos() {
        this.progress.show("Conectando com a meta para verificar se os numeros tem whats...<BR>Este processo pode demorar um pouco dependendo do volume de n\u00fameros, por favor aguarde.");
        this.telefoneService.temWhats(this.cliente.getClienteContato(), arg_0 -> this.listenerContatos(arg_0));
    }

    public void listenerContatos(Set<ClienteContato> contatos) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.progress.close();
            this.cliente.setClienteContato(contatos);
            VerticalLayout c = this.clienteContatoComp.create(this.getEu(), this.cliente, this.pedidoId);
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{c});
        });
    }

    private void goBootom() {
        this.mainLayout.getElement().executeJs("$0.scrollTo(0,$0.scrollHeight);", new Serializable[]{this.mainLayout.getElement()});
    }

    private void goUp() {
        this.mainLayout.getElement().executeJs("$0.scrollTo(0,$100.scrollHeight);", new Serializable[]{this.mainLayout.getElement()});
    }
}

