/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view.form;

import br.com.system.app.components.AudioPlayerView;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteClassificacao;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.cliente.service.ClienteLogService;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.cliente.view.ClienteAnexoView;
import br.com.system.app.features.cliente.view.ClienteAtividadeView;
import br.com.system.app.features.cliente.view.ClienteContatoComp;
import br.com.system.app.features.cliente.view.ClienteLogView;
import br.com.system.app.features.cliente.view.ClienteProdutoView;
import br.com.system.app.features.cliente.view.ClienteTimeLineView;
import br.com.system.app.features.cliente.view.form.ClienteFormBi;
import br.com.system.app.features.cliente.view.form.ClienteFormEnriquecimento;
import br.com.system.app.features.cliente.view.form.ClienteFormSerasa;
import br.com.system.app.features.cliente.view.form.ClienteFormVencimento;
import br.com.system.app.features.cliente.view.form.ClienteFormWhats;
import br.com.system.app.features.creditos.CreditosCompraView;
import br.com.system.app.features.endereco.EnderecoView;
import br.com.system.app.features.endereco.model.Endereco;
import br.com.system.app.features.endereco.model.EnderecoTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.layout.util.Overflow;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.pedido.view.atividade.AtividadeView;
import br.com.system.app.features.pessoa.PessoaView;
import br.com.system.app.features.pessoa.service.PessoaService;
import br.com.system.app.features.portabilidade.service.PortabilidadeConsultaService;
import br.com.system.app.features.shared.service.TelefoneService;
import br.com.system.app.features.trescx.TrescxGravacaoView;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.DialogProgressBar;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ClienteFormView
extends Dialog
implements br.com.system.app.security.SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ClienteTagService clienteTagService;
    @Autowired
    private PessoaService pessoaService;
    @Autowired
    private ClienteAnexoService clienteAnexoService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private ClienteProdutoService clienteProdutoService;
    @Autowired
    private ClienteLogService clienteLogService;
    @Autowired
    private CreditosCompraView ccv;
    @Autowired
    private ClienteFormSerasa clienteFormSerasa;
    @Autowired
    private ClienteFormWhats clienteFormWhats;
    @Autowired
    private ClienteFormEnriquecimento clienteFormEnriquecimento;
    @Autowired
    private ClienteFormBi clienteFormBi;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    @Autowired
    private AudioPlayerView audioPlayerView;
    @Autowired
    private CepService cepService;
    @Autowired
    private TelefoneService telefoneService;
    @Autowired
    private PortabilidadeConsultaService portabilidadeConsultaService;
    private ClienteContatoComp clienteContatoComp;
    private ClienteFormVencimento clienteFormVencimento;
    private Cliente cliente;
    private TextField cpfCnpj;
    private VerticalContainer dadosBasicos;
    private TextField txtNome;
    private TextArea txtObservacao;
    private MultiSelectComboBox<HierarquiaDTO> cbResp;
    private MultiComboBox<ClienteTag> cbTags;
    private String mensagem;
    private H5 header;
    private TextField txtCreditos;
    private ComboBox<ClienteClassificacao> cbClassificacao;
    private NumberField tempoMedio;
    private TextField loginGestor;
    private TextField senhaGestor;
    private TextField loginContaOnline;
    private TextField senhaContaOnline;
    private TextField cpfContaOnline;
    private EstruturaUsuario eu;
    private Long atividadeId;
    private EnderecoView enderecoView;
    private final DialogProgressBar dialogProgressBar = new DialogProgressBar();
    private final VerticalLayout containerContatos = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
    private VerticalLayout mainLayout;
    private Scroller scroller;
    private Boolean aguardarContatos = false;

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.povoaContatos();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setContext(SecurityContext context) {
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    public void setMensagem(String msg) {
        this.mensagem = msg;
    }

    public void create(Cliente cliente) {
        this.create(cliente, null);
    }

    public void create(Cliente cliente, Long atividadeId) {
        this.setDraggable(true);
        this.cliente = cliente;
        this.atividadeId = atividadeId;
        this.eu = this.getEu();
        this.header = UIUtils.createHeader((String)"Cadastro de Clientes");
        this.dadosBasicos = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.open();
        this.create();
    }

    private void create() {
        this.removeAll();
        this.setCloseOnOutsideClick(false);
        this.setWidth("100%");
        this.setMaxWidth("850px");
        this.setHeight("95%");
        VerticalLayout lay = new VerticalLayout();
        lay.setMargin(false);
        lay.setHeight("100%");
        lay.add(new com.vaadin.flow.component.Component[]{this.header});
        lay.add(new com.vaadin.flow.component.Component[]{this.getStart()});
        this.mainLayout = new VerticalLayout();
        lay.setPadding(true);
        lay.setSpacing(true);
        this.enderecoView = new EnderecoView(this.cepService, this.getEnd(this.cliente), EnderecoTipoEnum.COMERCIAL, "Endere\u00e7o");
        this.clienteContatoComp = new ClienteContatoComp(this.telefoneService, this.portabilidadeConsultaService);
        this.clienteFormVencimento = new ClienteFormVencimento(this.cliente);
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.dadosBasicos});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.enderecoView});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.containerContatos});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.clienteFormVencimento});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.clienteFormSerasa.create(this.cliente)});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.clienteFormEnriquecimento.create(this.cliente)});
        this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.clienteFormWhats.create(this.cliente, false, arg_0 -> this.listenerPovoaContatos(arg_0))});
        if (this.isVivo()) {
            this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.clienteFormBi.create(this.cliente)});
        }
        if (this.isTelefonia()) {
            this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.getDadosOperadora()});
        }
        if (this.mensagem != null && !this.mensagem.isBlank()) {
            this.mainLayout.add(new com.vaadin.flow.component.Component[]{this.getBroadMessage()});
        }
        UIUtils.setBorder((BorderStyle)BorderStyle.GROOVE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{this.dadosBasicos, this.clienteFormSerasa, this.clienteFormVencimento, this.clienteFormBi, this.containerContatos, this.enderecoView, this.clienteFormEnriquecimento});
        this.scroller = UIUtils.createScroller((com.vaadin.flow.component.Component)this.mainLayout);
        this.scroller.setWidth("100%");
        this.scroller.setId("scrollerFormVIew");
        lay.add(new com.vaadin.flow.component.Component[]{this.scroller});
        lay.add(new com.vaadin.flow.component.Component[]{this.getRodape()});
        this.add(new com.vaadin.flow.component.Component[]{lay});
    }

    public H5 getCabecalho() {
        return this.header;
    }

    private void atualizarSaldo() {
        this.txtCreditos.setValue("R$ " + this.usuarioService.getCreditos(this.getEu().getUsuario()).toString());
    }

    private void comprarCreditos() {
        this.ccv.create(this.getEu());
        this.ccv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> this.ccv.close());
    }

    private void abreCliente() {
        this.dadosBasicos.removeAll();
        this.dadosBasicos.add(new com.vaadin.flow.component.Component[]{new Hr()});
        this.dadosBasicos.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Dados do Cliente")});
        this.txtObservacao = new TextArea("Dados Complementares");
        this.txtObservacao.setWidthFull();
        this.txtObservacao.setValue(this.cliente.getObservacao() == null ? "" : this.cliente.getObservacao());
        this.txtNome.setValue(this.cliente.getNome() == null ? "" : this.cliente.getNome());
        List hierarquia = this.hierarquiaService.getHierarquiaDto(this.eu);
        this.cbResp = new MultiSelectComboBox("Respons\u00e1veis", (Collection)hierarquia);
        this.cbResp.setWidth("100%");
        this.cbResp.setItemLabelGenerator(HierarquiaDTO::getLoginAndEquipeName);
        this.cbResp.setEnabled(this.hasPermission("CLIENTE_RESPONSAVEL_CHANGE"));
        if (this.cliente != null && this.cliente.getClienteResponsavel() != null && !this.cliente.getClienteResponsavel().isEmpty()) {
            ArrayList<HierarquiaDTO> seleciondaos = new ArrayList<HierarquiaDTO>();
            block0: for (ClienteResponsavel cr : this.cliente.getClienteResponsavel()) {
                for (HierarquiaDTO hd : hierarquia) {
                    if (!hd.getEstruturaUsuarioId().equals(cr.getEstruturaUsuario().getId())) continue;
                    seleciondaos.add(hd);
                    continue block0;
                }
            }
            this.cbResp.setValue(seleciondaos);
        }
        List tags = this.clienteTagService.getTags(this.getEstrutura());
        Set tagsDoCliente = this.clienteTagService.getTags(this.getEstrutura(), this.cliente.getTags());
        this.cbTags = new MultiComboBox("Tags", (Collection)tags);
        this.cbTags.setItemLabelGenerator(ClienteTag::getTag);
        this.cbTags.setEnabled(this.hasPermission("CLIENTE_TAGS_CHANGE"));
        this.cbTags.setWidth("100%");
        if (this.cliente != null && this.cliente.getTags() != null && !this.cliente.getTags().isBlank()) {
            ArrayList<ClienteTag> lct = new ArrayList<ClienteTag>();
            for (ClienteTag ct : tags) {
                for (ClienteTag ctc : tagsDoCliente) {
                    if (!ct.getId().equals(ctc.getId())) continue;
                    lct.add(ct);
                }
            }
            this.cbTags.setValue(lct);
        }
        this.cbClassificacao = new ComboBox("Classifica\u00e7\u00e3o", (Collection)this.clienteService.getClassificacao(this.getEstrutura().getEstruturaTipo()));
        this.cbClassificacao.setItemLabelGenerator(ClienteClassificacao::getNome);
        if (this.cliente != null && this.cliente.getClienteClassificacao() != null) {
            this.cbClassificacao.setValue((Object)this.cliente.getClienteClassificacao());
        }
        this.tempoMedio = new NumberField("Tempo M\u00e9dio");
        this.tempoMedio.setVisible(this.isClaro());
        if (this.cliente != null && this.cliente.getTempoMedio() != null) {
            this.tempoMedio.setValue((Number)this.cliente.getTempoMedio().doubleValue());
        }
        this.dadosBasicos.add(new com.vaadin.flow.component.Component[]{this.cbResp, this.cbTags, this.cbClassificacao, this.tempoMedio, this.txtObservacao});
    }

    private Endereco getEnd(Cliente c) {
        Endereco end = new Endereco();
        if (c == null) {
            return end;
        }
        end.setBairro(c.getBairro());
        end.setCep(c.getCep());
        end.setCidade(c.getCidade());
        end.setComplemento(c.getComplemento());
        end.setEstado(c.getEstado());
        end.setLogradouro(c.getLogradouro());
        end.setNumero(c.getNumero());
        return end;
    }

    private Cliente get() {
        Endereco end = this.enderecoView.getValue();
        BeanUtils.copyProperties((Object)end, (Object)this.cliente, (String[])new String[]{"id"});
        if (this.clienteContatoComp.getValue() != null) {
            this.cliente.setClienteContato(new HashSet(this.clienteContatoComp.getValue()));
        } else {
            this.cliente.setClienteContato(new HashSet());
        }
        if (this.cbResp != null) {
            for (HierarquiaDTO h : this.cbResp.getValue()) {
                boolean incluir = true;
                for (ClienteResponsavel cr : this.cliente.getClienteResponsavel()) {
                    if (!h.getEstruturaUsuarioId().equals(cr.getEstruturaUsuario().getId())) continue;
                    incluir = false;
                    break;
                }
                if (!incluir) continue;
                EstruturaUsuario u = this.estruturaUsuarioService.getById(h.getEstruturaUsuarioId());
                this.cliente.getClienteResponsavel().add(new ClienteResponsavel(this.cliente, u));
            }
        }
        HashSet lcr = new HashSet(this.cliente.getClienteResponsavel());
        for (ClienteResponsavel cr : lcr) {
            boolean excluir = true;
            for (HierarquiaDTO h : this.cbResp.getValue()) {
                if (!h.getEstruturaUsuarioId().equals(cr.getEstruturaUsuario().getId())) continue;
                excluir = false;
                break;
            }
            if (!excluir) continue;
            this.cliente.getClienteResponsavel().remove(cr);
        }
        this.cliente.setVencimentos(this.clienteFormVencimento.getVencs());
        this.cliente.getVencimentos().forEach(e -> e.setCliente(this.cliente));
        this.cliente.setDataHoraAtualizacao(LocalDateTime.now());
        this.cliente.setNome(this.txtNome.getValue());
        this.cliente.setObservacao(this.txtObservacao.getValue() == null ? "" : this.txtObservacao.getValue());
        this.cliente.setTags(this.clienteTagService.getStringtags(this.cbTags.getValue()));
        this.cliente.setTempoMedio(this.tempoMedio.getValue() == null ? null : Integer.valueOf(((Double)this.tempoMedio.getValue()).intValue()));
        this.cliente.setClienteClassificacao((ClienteClassificacao)this.cbClassificacao.getValue());
        if (this.isTelefonia()) {
            this.cliente.setLoginContaOnline(this.loginContaOnline.getValue() == null ? null : this.loginContaOnline.getValue());
            this.cliente.setSenhaContaOnline(this.senhaContaOnline.getValue() == null ? null : this.senhaContaOnline.getValue());
            this.cliente.setCpfContaOnline(this.cpfContaOnline.getValue() == null ? null : this.cpfContaOnline.getValue());
            this.cliente.setLoginGestor(this.loginGestor.getValue() == null ? null : this.loginGestor.getValue());
            this.cliente.setSenhaGestor(this.senhaGestor.getValue() == null ? null : this.senhaGestor.getValue());
        }
        return this.cliente;
    }

    public ClienteDTO getClienteDTO() {
        ClienteDTO dto = new ClienteDTO();
        if (this.cliente == null) {
            return dto;
        }
        dto.setBairro(this.cliente.getBairro() == null ? "" : this.cliente.getBairro());
        dto.setCidade(this.cliente.getCidade() == null ? "" : this.cliente.getCidade());
        dto.setCpfCnpj(this.cliente.getCpfCnpj() == null ? "" : this.cliente.getCpfCnpj());
        dto.setEstado(this.cliente.getEstado() == null ? "" : this.cliente.getEstado());
        dto.setId(this.cliente.getId() == null ? null : this.cliente.getId());
        dto.setTags(this.cliente.getTags() == null ? "" : this.cliente.getTags());
        dto.setNome(this.cliente.getNome() == null ? "" : this.cliente.getNome());
        return dto;
    }

    private VerticalLayout getBroadMessage() {
        VerticalLayout cv = new VerticalLayout();
        UIUtils.setBorder((BorderStyle)BorderStyle.GROOVE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{cv});
        cv.removeAll();
        cv.setEnabled(this.cliente != null && this.cliente.getId() != null);
        cv.add(new com.vaadin.flow.component.Component[]{new Hr()});
        cv.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Coment\u00e1rios")});
        Div div = new Div();
        div.getElement().setProperty("innerHTML", "<span>" + this.mensagem + "</span>");
        div.setWidthFull();
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{div});
        UIUtils.setOverflow((Overflow)Overflow.AUTO, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{div});
        div.setMaxHeight("200px");
        cv.add(new com.vaadin.flow.component.Component[]{div});
        return cv;
    }

    private FooterContainer getRodape() {
        Button btnGoBottom = UIUtils.createTopButton((com.vaadin.flow.component.Component)this.scroller);
        Button btnGoUp = UIUtils.createBottomButton((com.vaadin.flow.component.Component)this.scroller);
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        btnSalvar.setEnabled(this.hasPermission("CLIENTE_SAVE") && this.clienteService.possoAlterar(this.cliente, this.eu));
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.aguardarContatos.booleanValue()) {
                UIUtils.showNotification((String)"Para Salvar, aguarde carregar os contatos");
                return;
            }
            String contatoErros = this.clienteContatoComp.validar();
            if (!contatoErros.isEmpty()) {
                UIUtils.showNotification((String)contatoErros);
                return;
            }
            String contatoVenc = this.clienteFormVencimento.validar();
            if (!contatoVenc.isEmpty()) {
                UIUtils.showNotification((String)contatoVenc);
                return;
            }
            this.cliente = this.clienteService.salvar(this.get(), this.eu);
            UIUtils.showNotification((String)"Salvo com sucesso!");
            this.create(this.cliente);
            this.povoaContatos();
        });
        FooterContainer footer = new FooterContainer(new com.vaadin.flow.component.Component[]{btnFechar, btnGoUp, btnGoBottom, btnSalvar});
        footer.setWidthFull();
        return footer;
    }

    private VerticalContainer getStart() {
        this.cpfCnpj = new TextField("CPF-CNPJ");
        this.cpfCnpj.setMinLength(11);
        this.cpfCnpj.setMaxLength(18);
        this.cpfCnpj.setWidth("150px");
        this.txtNome = new TextField("Raz\u00e3o social/Nome");
        this.txtNome.setWidthFull();
        if (this.cliente != null) {
            this.cpfCnpj.setReadOnly(true);
            this.cpfCnpj.setValue(this.cliente.getCpfCnpj());
            this.abreCliente();
        }
        this.cpfCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            String cc = StringUtil.numbersOnly((String)((String)e.getValue()));
            if (cc.length() != 11 && cc.length() != 14) {
                return;
            }
            if (!ValidationUtil.isValidCnpjAndCpf((String)cc)) {
                UIUtils.showNotification((String)"CPF-CNPJ Inv\u00e1lido");
                return;
            }
            this.cliente = this.clienteService.buscarPeloCnpj(cc, this.getEstrutura());
            if (this.cliente != null) {
                UIUtils.showNotification((String)"Este documento j\u00e1 est\u00e1 cadastrado na base, voc\u00ea deve pesquisar na tela de filtro de clientes.");
                return;
            }
            if (cc.length() == 14) {
                this.dialogProgressBar.show("Trazendo dados da Receita.");
                this.clienteService.getFromMailing(this.getEstrutura(), cc, arg_0 -> this.listenerFound(arg_0), arg_0 -> this.listenerNotFound(arg_0), arg_0 -> this.listenerNotExist(arg_0));
            } else {
                this.cliente = new Cliente();
                this.cliente.setCpfCnpj(this.cpfCnpj.getValue());
                this.abreCliente();
            }
            this.dadosBasicos.setEnabled(true);
            this.cpfCnpj.setReadOnly(true);
        });
        Button bGroup = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.GROUP, (String)"Pessoas do Cliente");
        bGroup.setEnabled(this.cliente != null && this.cliente.getId() != null);
        bGroup.addClickListener((ComponentEventListener & Serializable)e -> {
            PessoaView pessoaView = new PessoaView(this.pessoaService, this.cliente, this.clienteService);
            pessoaView.addOpenedChangeListener((ComponentEventListener & Serializable)ec -> {
                if (!ec.isOpened()) {
                    this.cliente = this.clienteService.buscarPeloCnpj(this.cliente.getCpfCnpj(), this.cliente.getEstrutura());
                }
            });
        });
        Button bClip = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos do Cliente");
        bClip.setEnabled(this.hasPermission("CLIENTE_ANEXO_VIEW") && this.cliente != null && this.cliente.getId() != null);
        bClip.addClickListener((ComponentEventListener & Serializable)e -> new ClienteAnexoView(this.cliente, this.getEu(), this.clienteAnexoService));
        Button bTask = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TASKS, (String)"Criar Atividade para o cliente");
        bTask.setEnabled(this.cliente != null && this.cliente.getId() != null && this.clienteService.souResponsavel(this.cliente, this.eu, PedidoTipoEnum.COMERCIAL, Boolean.valueOf(this.hasPermission("ATIVIDADE_CRIAR_MESMO_ENCARTEIRADO"))));
        bTask.addClickListener((ComponentEventListener & Serializable)e -> {
            AtividadeView atividade = (AtividadeView)this.context.getBean(AtividadeView.class);
            atividade.create(null, this.eu, PedidoTipoEnum.COMERCIAL);
            atividade.setCnpj(this.cliente.getCpfCnpj());
        });
        Button btnTimeline = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TIMER, (String)"Timeline do Cliente");
        btnTimeline.setEnabled(this.cliente != null && this.cliente.getId() != null && this.hasPermission("CLIENTE_TIME_LINE"));
        btnTimeline.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("CLIENTE_TIME_LINE") || !this.clienteService.permiteAbrirDadosExtras(this.eu, this.cliente)) {
                UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem permiss\u00e3o para acessar essa funcionalidade");
                return;
            }
            AtividadeView atividadeView = (AtividadeView)this.context.getBean(AtividadeView.class);
            ClienteTimeLineView tl = new ClienteTimeLineView(this.cliente, this.pedidoService, this.estruturaUsuarioService, atividadeView);
            tl.createContent();
            tl.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> tl.close());
        });
        Button btnProdutos = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CART, (String)"Produtos do Cliente");
        btnProdutos.setEnabled(this.cliente != null && this.cliente.getId() != null && this.hasPermission("CLIENTE_PRODUTO_VIEW"));
        btnProdutos.addClickListener((ComponentEventListener & Serializable)e -> new ClienteProdutoView(this.cliente, this.getEu(), this.clienteProdutoService));
        Button btnLog = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.LINES_LIST, (String)"Log de altera\u00e7\u00f5es do cliente");
        btnLog.setEnabled(this.cliente != null && this.cliente.getId() != null);
        btnLog.addClickListener((ComponentEventListener & Serializable)e -> new ClienteLogView(this.cliente, this.clienteLogService));
        Button btnAtividades = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARCHIVE, (String)"Visualizar Atividades do cliente");
        btnAtividades.setEnabled(this.cliente != null && this.cliente.getId() != null && this.hasPermission("ATIVIDADE_VIEW"));
        btnAtividades.addClickListener((ComponentEventListener & Serializable)e -> {
            ClienteAtividadeView cav = new ClienteAtividadeView(this.cliente, this.getEu(), this.pedidoService, (AtividadeView)this.context.getBean(AtividadeView.class), this.estruturaUsuarioService);
            cav.open();
            cav.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> cav.close());
        });
        Button bGravacao = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.MICROPHONE, (String)"(3CX)GRAVA\u00c7\u00d5ES DA ATIVIDADE");
        bGravacao.setEnabled(this.hasPermission("TRESCX_GRAVACOES_VIEW"));
        bGravacao.setVisible(this.cliente != null && this.cliente.getId() != null);
        bGravacao.addClickListener((ComponentEventListener & Serializable)e -> new TrescxGravacaoView(this.cliente, this.trescxChamadaService, this.audioPlayerView));
        this.txtCreditos = new TextField("Saldo Cr\u00e9ditos");
        this.txtCreditos.setWidth("150px");
        this.atualizarSaldo();
        this.txtCreditos.setReadOnly(true);
        Button btnComprar = UIUtils.createSmallButton((String)"Comprar Cr\u00e9ditos");
        btnComprar.addClickListener((ComponentEventListener & Serializable)e -> this.comprarCreditos());
        HorizontalLayout layE = new HorizontalLayout(new com.vaadin.flow.component.Component[]{this.cpfCnpj, bGroup, bClip, bTask, btnTimeline, btnProdutos, btnAtividades, bGravacao});
        layE.setAlignItems(FlexComponent.Alignment.END);
        HorizontalLayout layD = new HorizontalLayout(new com.vaadin.flow.component.Component[]{this.txtCreditos, btnComprar});
        layD.setAlignItems(FlexComponent.Alignment.END);
        HorizontalLayout lay = new HorizontalLayout(new com.vaadin.flow.component.Component[]{layE, layD});
        lay.setWidth("100%");
        lay.setAlignItems(FlexComponent.Alignment.END);
        lay.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        return new VerticalContainer(new com.vaadin.flow.component.Component[]{lay, this.txtNome});
    }

    public void listenerFound(Cliente cliente) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.dialogProgressBar.close();
            this.cliente = this.clienteService.salvar(cliente, this.getEu());
            this.create(this.cliente);
            this.povoaContatos();
            this.enderecoView.setEndereco(this.getEnd(this.cliente));
        });
    }

    public void listenerNotFound(String msg) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> this.dialogProgressBar.show(msg));
    }

    public void listenerNotExist(String erro) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.dialogProgressBar.close();
            this.cliente = new Cliente();
            this.cliente.setCpfCnpj(this.cpfCnpj.getValue());
            this.abreCliente();
            UIUtils.showNotification((String)erro);
        });
    }

    private VerticalLayout getDadosOperadora() {
        this.loginContaOnline = new TextField("Login Conta Online");
        if (this.cliente != null && this.cliente.getLoginContaOnline() != null) {
            this.loginContaOnline.setValue(this.cliente.getLoginContaOnline());
        }
        this.senhaContaOnline = new TextField("Senha Conta Online");
        if (this.cliente != null && this.cliente.getSenhaContaOnline() != null) {
            this.senhaContaOnline.setValue(this.cliente.getSenhaContaOnline());
        }
        this.cpfContaOnline = new TextField("CPF Conta Online");
        this.cpfContaOnline.setMaxLength(11);
        this.cpfContaOnline.setVisible(this.isVivo());
        if (this.cliente != null && this.cliente.getCpfContaOnline() != null) {
            this.cpfContaOnline.setValue(this.cliente.getCpfContaOnline());
        }
        this.loginGestor = new TextField("Login Gestor Online");
        if (this.cliente != null && this.cliente.getLoginGestor() != null) {
            this.loginGestor.setValue(this.cliente.getLoginGestor());
        }
        this.senhaGestor = new TextField("Senha Gestor Online");
        if (this.cliente != null && this.cliente.getSenhaGestor() != null) {
            this.senhaGestor.setValue(this.cliente.getSenhaGestor());
        }
        VerticalLayout containerDO = new VerticalLayout();
        UIUtils.setBorder((BorderStyle)BorderStyle.GROOVE, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{containerDO});
        containerDO.add(new com.vaadin.flow.component.Component[]{new Hr()});
        containerDO.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Dados Acesso Operadora")});
        containerDO.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.loginGestor, this.senhaGestor, this.loginContaOnline, this.senhaContaOnline, this.cpfContaOnline})});
        containerDO.setVisible(this.isVivo() || this.isClaro() || this.isTim());
        return containerDO;
    }

    public void listenerPovoaContatos(Cliente cliente) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.cliente = cliente;
            this.povoaContatos();
        });
    }

    private void povoaContatos() {
        this.containerContatos.removeAll();
        if (this.cliente == null) {
            VerticalLayout c = this.clienteContatoComp.create(this.eu, this.cliente, this.atividadeId);
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{c});
            return;
        }
        if (this.cliente.getClienteContato() != null && this.cliente.getClienteContato().isEmpty()) {
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{this.clienteContatoComp.create(this.eu, this.cliente, this.atividadeId)});
        } else {
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>Conectando com a meta para verificar se os numeros tem whats...<BR>Este processo pode demorar um pouco dependendo do volume de n\u00fameros, por favor aguarde.</span>");
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Contatos do cliente")});
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{div});
            this.telefoneService.temWhats(this.cliente.getClienteContato(), arg_0 -> this.listenerContatos(arg_0));
            this.aguardarContatos = true;
        }
    }

    public void listenerContatos(Set<ClienteContato> contatos) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.aguardarContatos = false;
            this.containerContatos.removeAll();
            this.cliente.setClienteContato(contatos);
            VerticalLayout c = this.clienteContatoComp.create(this.eu, this.cliente, this.atividadeId);
            this.containerContatos.add(new com.vaadin.flow.component.Component[]{c});
            this.cliente = this.clienteService.salvar(this.cliente, this.eu);
        });
    }
}

