/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cobranca.CobrancaAssinaturaAnexoView;
import br.com.system.app.features.cobranca.CobrancaAssinaturaFormView;
import br.com.system.app.features.cobranca.CobrancaFaturaScreen;
import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaValorDTO;
import br.com.system.app.features.cobranca.model.ProprietarioEnum;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaAnexoService;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="assinatura", layout=MainLayout.class)
@PageTitle(value="Assinatura")
@RolesAllowed(value={"ASSINATURA_VIEW"})
public class CobrancaAssinaturaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final CobrancaAssinaturaService cas;
    private final CobrancaAssinaturaAnexoService caas;
    private final CobrancaAssinaturaFormView formView;
    private final CobrancaFaturaScreen cobrancaFaturaScreen;
    private GridCrud<CobrancaAssinatura> crud;
    private boolean inadimplentes = false;
    private boolean divergentes = false;
    private TextField txtAssinaturasAtivas;
    private TextField txtFaturasVencidas;
    private TextField txtAssinaturasVencidas;
    private TextField txtAGerar;
    private TextField txtAvencer;
    private TextField txtPago;
    private DatePicker pagamentoIni;
    private DatePicker pagamentoFim;

    @Autowired
    public CobrancaAssinaturaView(CobrancaAssinaturaService cobrancaAssinaturaService, CobrancaAssinaturaFormView formView, CobrancaFaturaScreen cobrancaFaturaScreen, CobrancaAssinaturaAnexoService caas) {
        this.caas = caas;
        this.cas = cobrancaAssinaturaService;
        this.cobrancaFaturaScreen = cobrancaFaturaScreen;
        this.formView = formView;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.cas.temPermissao(this.getUsuario().getLogin())) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        VerticalContainer containerV = new VerticalContainer(new Component[0]);
        containerV.setHeightFull();
        this.pagamentoIni = new DatePicker();
        this.pagamentoIni.setId("primeiroPagamento");
        this.pagamentoIni.setLabel("Primeiro Pagto Ini");
        this.pagamentoIni.setLocale(UIUtils.getLocale());
        this.pagamentoFim = new DatePicker();
        this.pagamentoFim.setId("primeiroPagamento");
        this.pagamentoFim.setLabel("Primeiro Pagto Fim");
        this.pagamentoFim.setLocale(UIUtils.getLocale());
        this.txtPago = new TextField("Pago no M\u00eas");
        this.txtPago.setReadOnly(true);
        this.txtAvencer = new TextField("Gerados a Vencer no Mes");
        this.txtAvencer.setReadOnly(true);
        this.txtFaturasVencidas = new TextField("Faturas Vencidas");
        this.txtFaturasVencidas.setReadOnly(true);
        this.txtAssinaturasAtivas = new TextField("Assinaturas Ativas");
        this.txtAssinaturasAtivas.setReadOnly(true);
        this.txtAssinaturasVencidas = new TextField("Assinaturas Inadimplentes");
        this.txtAssinaturasVencidas.setReadOnly(true);
        this.txtAssinaturasVencidas.setWidth("120px");
        this.txtAGerar = new TextField("A gerar no mes");
        this.txtAGerar.setReadOnly(true);
        containerV.add(new Component[]{new HorizontalContainer(new Component[]{this.txtAssinaturasAtivas, this.txtPago, this.txtAvencer, this.txtAGerar, this.txtFaturasVencidas, this.txtAssinaturasVencidas})});
        Button btnRefresh = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        btnRefresh.addClickListener((ComponentEventListener & Serializable)e -> {
            this.inadimplentes = false;
            this.divergentes = false;
            this.crud.refreshGrid();
        });
        TextField filterName = new TextField("Nome");
        filterName.setClearButtonVisible(true);
        filterName.addKeyDownListener(Key.ENTER, (ComponentEventListener & Serializable)keyDownEvent -> btnRefresh.click(), new KeyModifier[0]);
        TextField filterCnpj = new TextField("CPF-CNPJ");
        filterCnpj.setClearButtonVisible(true);
        filterCnpj.addKeyDownListener(Key.ENTER, (ComponentEventListener & Serializable)keyDownEvent -> btnRefresh.click(), new KeyModifier[0]);
        filterName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> filterCnpj.setValue(""));
        filterCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> filterName.setValue(""));
        this.crud = new GridCrud(CobrancaAssinatura.class);
        RadioButtonGroup rbAtivo = new RadioButtonGroup();
        rbAtivo.setItems((Object[])new String[]{"Ignorar", "Ativo", "Inativo"});
        rbAtivo.setValue((Object)"Ativo");
        Button btnAdicionar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Nova assinatura");
        btnAdicionar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.formView.abrir(new CobrancaAssinatura());
            this.formView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> this.crud.refreshGrid());
        });
        Button btnEditar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar assinatura");
        btnEditar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma assinatura para editar");
                return;
            }
            this.formView.abrir((CobrancaAssinatura)this.crud.getGrid().getSelectedItems().iterator().next());
            this.formView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> this.crud.refreshGrid());
        });
        Button btnInadimplentes = UIUtils.createSmallButton((String)"Inadimplentes");
        btnInadimplentes.addClickListener((ComponentEventListener & Serializable)e -> {
            this.inadimplentes = true;
            this.divergentes = false;
            this.crud.refreshGrid();
        });
        Button btnDivergente = UIUtils.createSmallButton((String)"Divergentes");
        btnDivergente.addClickListener((ComponentEventListener & Serializable)e -> {
            this.divergentes = true;
            this.inadimplentes = false;
            this.crud.refreshGrid();
        });
        Button btnFaturas = UIUtils.createSmallButton((String)"Faturas");
        btnFaturas.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione uma assinatura para verificar as faturas");
                return;
            }
            CobrancaAssinatura ca = (CobrancaAssinatura)this.crud.getGrid().getSelectedItems().iterator().next();
            if (this.checkOwner(ca)) {
                this.openScreen(ca);
            }
        });
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{rbAtivo, filterName, filterCnpj, this.pagamentoIni, this.pagamentoFim, btnRefresh, btnAdicionar, btnEditar, btnFaturas, btnInadimplentes, btnDivergente}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Ver anexos");
            btn.addClickListener((ComponentEventListener & Serializable)e -> new CobrancaAssinaturaAnexoView(this.caas, this.getEu(), p));
            return btn;
        })).setHeader("Anexos").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn;
            if (p.isInadimplente()) {
                Icon icon = new Icon(VaadinIcon.FROWN_O);
                icon.setColor(Color.RED.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "INADIMPLENTE");
            } else {
                Icon icon = new Icon(VaadinIcon.SMILEY_O);
                icon.setColor(Color.GREEN.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "ADIMPLENTE");
            }
            return btn;
        })).setHeader("Financeiro").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn;
            if (p.getAtivo().booleanValue()) {
                Icon icon = new Icon(VaadinIcon.CHECK_CIRCLE);
                icon.setColor(Color.GREEN.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "ATIVO, clique para Desativar");
            } else {
                Icon icon = new Icon(VaadinIcon.BAN);
                icon.setColor(Color.RED.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "INATIVO, clique para Ativar");
            }
            btn.addClickListener((ComponentEventListener & Serializable)e -> {
                if (!this.checkOwner(p)) {
                    return;
                }
                ConfirmationDialog cd = new ConfirmationDialog("Mudar status", "Esta assinatura est\u00e1 <B>" + (p.getAtivo() != false ? "ATIVA" : "INATIVA") + "</B><BR>Deseja <B>" + (p.getAtivo() != false ? "INATIVAR?" : "ATIVAR?</B>"));
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.cas.changeStatus(this.getEu(), p);
                    this.crud.refreshGrid();
                    cd.close();
                });
            });
            return btn;
        })).setHeader("Ativo").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn;
            if (!p.isBloqueado()) {
                Icon icon = new Icon(VaadinIcon.CHECK_CIRCLE);
                icon.setColor(Color.GREEN.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "LIBERADO, clique para Bloquear");
            } else {
                Icon icon = new Icon(VaadinIcon.BAN);
                icon.setColor(Color.RED.getValue());
                btn = new Button((Component)icon);
                btn.getElement().setProperty("title", "BLOQUEADO, clique para Liberar");
            }
            btn.addClickListener((ComponentEventListener & Serializable)e -> {
                if (!this.checkOwner(p)) {
                    return;
                }
                ConfirmationDialog cd = new ConfirmationDialog("Bloqueio", "Esta assinatura est\u00e1 <B>" + (p.isBloqueado() ? "BLOQUEADA" : "LIBERADA") + "</B><BR>Deseja <B>" + (p.isBloqueado() ? "LIBERAR?" : "BLOQUEAR?</B>"));
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.cas.changeBloqueio(this.getEu(), p);
                    this.crud.refreshGrid();
                    cd.close();
                });
            });
            return btn;
        })).setHeader("Bloqueio").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProprietario() == null ? "" : p.getProprietario().name())).setHeader("Propriet\u00e1rio").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getTipo().name())).setHeader("Tipo").setFlexGrow(0).setWidth("100px");
        this.crud.getGrid().addColumn("valorMensal").setFlexGrow(0).setWidth("160px");
        this.crud.getGrid().addColumn("valorDesconto").setFlexGrow(0).setWidth("160px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDescontoAte() == null ? "" : p.getDescontoAte().format(FormatDate.DATE_BR.toDTF()))).setHeader("Desconto At\u00e9").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("300px");
        this.crud.getGrid().addColumn("cpfCnpj").setWidth("180px").setFlexGrow(0);
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProximoVencimento() == null ? "" : p.getProximoVencimento().format(FormatDate.DATE_BR.toDTF()))).setHeader("Pr\u00f3ximo").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataCriacao() == null ? "" : p.getDataCriacao().format(FormatDate.DATE_BR.toDTF()))).setHeader("Cria\u00e7\u00e3o").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPrimeiroPagamento() == null ? "" : p.getPrimeiroPagamento().format(FormatDate.DATE_BR.toDTF()))).setHeader("1o Pgto").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getVendedor()))).setHeader("Vendedor").setFlexGrow(0).setWidth("150px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.getFindAllButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        containerV.add(new Component[]{this.crud});
        return containerV;
    }

    private boolean checkOwner(CobrancaAssinatura ca) {
        if (ca == null) {
            return false;
        }
        if (ca.getProprietario() == null && ca.getId() == null) {
            ca.setProprietario(this.getUsuario().getLogin().contains("ricardo") ? ProprietarioEnum.RICARDO : ProprietarioEnum.JERIAM);
            return true;
        }
        return this.getUsuario().getLogin().contains("ricardo") && ca.getProprietario().equals((Object)ProprietarioEnum.RICARDO) || this.getUsuario().getLogin().contains("jeriam") && ca.getProprietario().equals((Object)ProprietarioEnum.JERIAM);
    }

    private void povoa() {
        try {
            CobrancaValorDTO assinaturasAtivas = this.cas.getAssinaturasWithOutNeo(Boolean.valueOf(true));
            CobrancaValorDTO faturasVencidas = this.cas.getFaturasVencidas();
            CobrancaValorDTO assinaturasVencidas = this.cas.getAssinaturasVencidas();
            CobrancaValorDTO mensalAvencer = this.cas.getMensalAvencer();
            CobrancaValorDTO mensalPago = this.cas.getMensalPago();
            CobrancaValorDTO aGerar = this.cas.getAGerar();
            this.txtAssinaturasAtivas.setValue((String)(assinaturasAtivas == null ? "" : assinaturasAtivas.getQuantidade() + " " + CurrencyUtil.toCurrencyWithR$((Double)assinaturasAtivas.getValor())));
            this.txtFaturasVencidas.setValue((String)(faturasVencidas == null ? "" : faturasVencidas.getQuantidade() + " " + CurrencyUtil.toCurrencyWithR$((Double)faturasVencidas.getValor())));
            this.txtAssinaturasVencidas.setValue(assinaturasVencidas == null ? "" : assinaturasVencidas.getQuantidade().toString());
            this.txtAvencer.setValue((String)(mensalAvencer == null ? "" : mensalAvencer.getQuantidade() + " " + CurrencyUtil.toCurrencyWithR$((Double)mensalAvencer.getValor())));
            this.txtPago.setValue((String)(mensalPago == null ? "" : mensalPago.getQuantidade() + " " + CurrencyUtil.toCurrencyWithR$((Double)mensalPago.getValor())));
            this.txtAGerar.setValue((String)(aGerar == null ? "" : aGerar.getQuantidade() + " " + CurrencyUtil.toCurrencyWithR$((Double)aGerar.getValor())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openScreen(CobrancaAssinatura ca) {
        Dialog d = new Dialog();
        d.setWidth("1024px");
        d.setHeight("900px");
        d.add(new Component[]{this.cobrancaFaturaScreen.create(ca, this.getEu())});
        Button btnClose = this.cobrancaFaturaScreen.getBtnClose();
        btnClose.addClickListener((ComponentEventListener & Serializable)c -> {
            d.close();
            this.cas.checarInadimplencia(ca.getCpfCnpj());
            this.cas.checarDivergencia(ca.getCpfCnpj());
        });
        d.open();
    }
}

