/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.enriquecimento.service;

import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.repository.EnriquecimentoItensRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnriquecimentoItensService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EnriquecimentoItensRepository repository;

    public List<EnriquecimentoItens> get(Enriquecimento e) {
        return this.repository.findByEnriquecimento(e);
    }

    public List<EnriquecimentoItens> save(List<EnriquecimentoItens> itens) {
        return this.repository.saveAll(itens);
    }

    public EnriquecimentoItens setCobrado(EnriquecimentoItens item) {
        item.setCobrado(Boolean.TRUE);
        return (EnriquecimentoItens)this.repository.save((Object)item);
    }

    public Boolean cobrar(Enriquecimento enriquecimento, String cnpj) {
        EnriquecimentoItens e = this.repository.findByEnriquecimentoAndCpfCnpj(enriquecimento, cnpj);
        if (e == null) {
            return false;
        }
        if (e.getCobrado() != null && e.getCobrado().booleanValue()) {
            return false;
        }
        e.setCobrado(Boolean.TRUE);
        this.repository.save((Object)e);
        return true;
    }
}

