/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.service;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.model.EquipeFilterEnum;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioEquipeDTO;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioPermissaoDTO;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioSimplifyDTO;
import br.com.system.app.features.estrutura.dto.PermissaoFilterEnum;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.EstruturaUsuarioRepository;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EstruturaUsuarioService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaUsuarioRepository repository;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private EquipeService equipeService;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private UsuarioTagService usuarioTagService;

    public List<EstruturaUsuarioSimplifyDTO> getSessaoAtiva(Estrutura e, Equipe equipe, String nome) {
        return this.repository.findSessaoAtiva(e, equipe, nome);
    }

    public List<EstruturaUsuario> getByWhatsappConta(WhatsAppConta conta) {
        return this.repository.findByUsuarioWhatsappConta(conta);
    }

    public boolean naHierarquia(EstruturaUsuario euLogado, Long estruturaUsuarioId) {
        Long[] hierarquia;
        if (euLogado.getId().equals(estruturaUsuarioId) || euLogado.getUsuario().isMaster()) {
            return true;
        }
        for (Long id : hierarquia = this.hierarquiaService.getHierarquiaLongArray(euLogado)) {
            if (!id.equals(estruturaUsuarioId)) continue;
            return true;
        }
        return false;
    }

    public List<Equipe> getEquipe(Estrutura estrutura) {
        return this.equipeService.getEquipes(estrutura);
    }

    public List<UsuarioTag> getUsuarioTags(EstruturaUsuario eu) {
        return this.usuarioTagService.getTags(eu.getEstrutura());
    }

    public EstruturaUsuario getById(Long id) {
        return (EstruturaUsuario)this.repository.findById((Object)id).get();
    }

    public EstruturaUsuario getMasterEstrutura(Estrutura estrutura) {
        if (estrutura == null) {
            return null;
        }
        Usuario user = this.usuarioRepository.findByLogin("master@" + estrutura.getNome());
        if (user == null) {
            throw new BusinessException("Usuario nao encontrado");
        }
        Optional optEu = this.getByUsuarioAndEstrutura(user, estrutura);
        if (!optEu.isPresent()) {
            throw new BusinessException("Eu nao encontrado");
        }
        return (EstruturaUsuario)optEu.get();
    }

    public List<EstruturaUsuario> getByUserTag(Estrutura estrutura, String tagUnica) {
        ArrayList<EstruturaUsuario> retorno = new ArrayList<EstruturaUsuario>();
        List lista = this.repository.findByTagUsuario(estrutura, tagUnica, Boolean.valueOf(true));
        for (Long id : lista) {
            retorno.add(this.getById(id));
        }
        return retorno;
    }

    public Set<HierarquiaDTO> convert(Set<EstruturaUsuario> leu) {
        HashSet<HierarquiaDTO> lr = new HashSet<HierarquiaDTO>();
        for (EstruturaUsuario eu : leu) {
            lr.add(new HierarquiaDTO(eu));
        }
        return lr;
    }

    public void salvarHierarquia(Long idUsuarioSolicitado, Set<Long> usuariosHierarquiaNova, EstruturaUsuario euContext) {
        Usuario usuarioSolicitado = new Usuario(idUsuarioSolicitado);
        Estrutura estruturaSolicitada = euContext.getEstrutura();
        EstruturaUsuario euSolicitado = (EstruturaUsuario)this.getByUsuarioAndEstrutura(usuarioSolicitado, estruturaSolicitada).orElseThrow(() -> new BusinessException("exceptions.usuario.not-found-in-estrutura"));
        Set novaHierarquia = new HashSet();
        if (!usuariosHierarquiaNova.isEmpty()) {
            novaHierarquia = this.repository.findUsersInEstruturaWithInatives(usuariosHierarquiaNova, estruturaSolicitada);
            novaHierarquia.remove(euSolicitado.getId());
        }
        this.hierarquiaService.setHierarquia(euSolicitado, novaHierarquia);
    }

    public Boolean hasPermission(EstruturaUsuario eu, String permissao) {
        if (eu.getUsuario().isMaster()) {
            return true;
        }
        return this.repository.hasPermission(eu, permissao);
    }

    public EstruturaUsuario getFirstByUsuario(Usuario u) {
        EstruturaUsuario eu = this.repository.findFirstByUsuario(u);
        if (!(eu != null && eu.isAtivo() && eu.getEstrutura().isAtivo() || u.isMaster())) {
            throw new BusinessException("Usu\u00e1rio " + u.getLogin() + " n\u00e3o encontrado ou inativo");
        }
        return eu;
    }

    public Optional<EstruturaUsuario> getByUsuarioAndEstrutura(Usuario usuario, Estrutura estrutura) {
        return Optional.ofNullable(this.repository.findEstruturaUsuarioWithInative(usuario, estrutura));
    }

    public List<EstruturaUsuarioPermissaoDTO> getEstruturaUsuarioPermission(EstruturaUsuario eu, String permissao, PermissaoFilterEnum filter, String filterName, UsuarioPerfilEnum perfil, Boolean justActive) {
        return this.repository.getPermissao(eu, permissao, filter, filterName, perfil, justActive);
    }

    public List<EstruturaUsuarioEquipeDTO> getEstruturaUsuarioEquipe(Estrutura estrutura, Equipe equipe, EquipeFilterEnum filter, String filterName, Boolean justActive) {
        return this.repository.getEquipe(estrutura, equipe, filter, filterName, justActive);
    }

    public List<HierarquiaDTO> getAtivosByEstrutura(Estrutura estrutura) {
        return this.repository.findByEstruturaAndAtivo(estrutura, Boolean.valueOf(true));
    }

    public List<HierarquiaDTO> getAtivosByEstruturaAndPerfil(Estrutura estrutura, UsuarioPerfilEnum perfil) {
        return this.repository.findByEstruturaAndAtivoAndPerfil(estrutura, Boolean.valueOf(true), perfil);
    }

    public List<HierarquiaDTO> getByEstrutura(Estrutura estrutura) {
        return this.repository.findByEstrutura(estrutura);
    }

    public List<HierarquiaDTO> getRamais(Estrutura estrutura) {
        return this.repository.findRamais(estrutura);
    }

    @Transactional
    public void updateEquipe(Set<Long> listaIds, Equipe equipe, Boolean incluir) {
        this.repository.updateEquipe(listaIds, equipe, incluir);
    }

    @Transactional
    public void updatePermission(Set<Long> listaIds, String rule, Boolean ativar) {
        this.repository.updatePermission(listaIds, rule, ativar);
    }

    @Transactional
    public EstruturaUsuario save(EstruturaUsuario eu) {
        if (eu.getUsuario() == null) {
            throw new BusinessException("Usuario invalido");
        }
        if (eu.getRules() == null) {
            eu.setRules("");
        }
        return (EstruturaUsuario)this.repository.save((Object)eu);
    }

    public void deleteHierarquiaByEstrutura(Estrutura e) {
        this.repository.deleteHierarquiaByEstrutura(e);
    }
}

