/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.views;

import br.com.system.app.MainLayout;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.repository.EstruturaSenhasRepository;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.Horizontal;
import br.com.system.app.features.layout.size.Size;
import br.com.system.app.features.layout.size.Top;
import br.com.system.app.features.layout.util.BoxSizing;
import br.com.system.app.features.sistemasexternos.model.SistemasExternos;
import br.com.system.app.features.sistemasexternos.repository.SistemasExternosRepository;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;
import org.vaadin.crudui.form.FieldProvider;

@Route(value="logins-operadora", layout=MainLayout.class)
@PageTitle(value="Cadastro de logins da operadora")
@RolesAllowed(value={"ESTRUTURA_SENHAS_VIEW"})
public class EstruturaSenhasView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaSenhasRepository esr;
    private final SistemasExternosRepository ser;

    @Autowired
    public EstruturaSenhasView(EstruturaSenhasRepository esr, SistemasExternosRepository ser) {
        this.esr = esr;
        this.ser = ser;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        FlexBoxLayout content = new FlexBoxLayout(new Component[]{this.createCrud()});
        content.setBoxSizing(BoxSizing.BORDER_BOX);
        content.setHeightFull();
        content.setPadding(new Size[]{Horizontal.RESPONSIVE_X, Top.RESPONSIVE_X});
        return content;
    }

    private Component createCrud() {
        GridCrud crud = new GridCrud(EstruturaSenhas.class);
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        RadioButtonGroup rbAtivo = new RadioButtonGroup();
        rbAtivo.setItems((Object[])new String[]{"Ativos", "Inativos"});
        rbAtivo.setValue((Object)"Ativos");
        rbAtivo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        crud.getCrudLayout().addToolbarComponent((Component)rbAtivo);
        crud.getCrudLayout().addFilterComponent((Component)filter);
        crud.getAddButton().setText("Adicionar");
        crud.getGrid().setColumns(new String[]{"nome"});
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getSistemasExternos().getSistemaExterno().toString())).setHeader("sistemasExternos");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "Ativo" : "Inativo")).setHeader("Ativo");
        if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO)) {
            crud.getGrid().addColumns(new String[]{"login", "senha"});
            crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getSenhaCorreta() != false ? "SIM" : "N\u00c3O")).setHeader("Senha Correta");
        } else {
            crud.getGrid().addColumns(new String[]{"login"});
        }
        crud.getCrudFormFactory().setUseBeanValidation(true);
        if (this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO)) {
            crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "sistemasExternos", "ativo", "login", "senha", "senhaCorreta"});
        } else {
            crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "sistemasExternos", "ativo", "login"});
        }
        crud.getCrudFormFactory().setFieldProvider("sistemasExternos", (FieldProvider & Serializable)() -> {
            ComboBox cb = new ComboBox("Sistema Externo", (Collection)this.ser.findByEstruturaTipo(this.getEu().getEstrutura().getEstruturaTipo()));
            cb.setItemLabelGenerator(SistemasExternos::getSistemaExternoName);
            return cb;
        });
        crud.getAddButton().setVisible(this.hasPermission("ESTRUTURA_SENHAS_SAVE"));
        crud.getUpdateButton().setVisible(this.hasPermission("ESTRUTURA_SENHAS_SAVE"));
        crud.getDeleteButton().setVisible(this.hasPermission("ESTRUTURA_SENHAS_DELETE"));
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        return crud;
    }
}

