/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.importacoes;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.importacoes.model.ImportacoesTipoEnum;
import br.com.system.app.features.importacoes.service.ImportacoesService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="vivo-pedido-view", layout=MainLayout.class)
@PageTitle(value="Vivo Pedido Atualiza\u00e7\u00e3o")
@RolesAllowed(value={"VIVO_PEDIDO_VIEW"})
public class VivoPedidoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ImportacoesService importacoesService;
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private Upload upload;
    private RadioButtonGroup<ImportacoesTipoEnum> rbTipo;
    private Checkbox cbForcar;

    @Autowired
    public VivoPedidoView(ImportacoesService importacoesService) {
        this.importacoesService = importacoesService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setItems((Object[])ImportacoesTipoEnum.values());
        this.cbForcar = new Checkbox("For\u00e7ar");
        this.mBuffer = new TempFileMultiBuffer();
        this.upload = new Upload((Receiver)this.mBuffer);
        this.upload.setMaxFiles(1);
        this.upload.setDropLabel((Component)new Span("Arraste arquivos pra c\u00e1"));
        this.upload.setAcceptedFileTypes(new String[]{".csv", ".zip"});
        this.upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        this.upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .zip e .csv"));
        Button processar = UIUtils.createSmallButton((String)"Processar Arquivo");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                this.showNotification("Selecione o arquivo.");
                return;
            }
            if (this.rbTipo.getValue() == null) {
                this.showNotification("Selecione o tipo de arquivo.");
                return;
            }
            if (((Boolean)this.cbForcar.getValue()).booleanValue()) {
                ConfirmationDialog cd = new ConfirmationDialog("FOR\u00c7AR", "Deseja realmente for\u00e7ar a atualiza\u00e7\u00e3o? Todos os pedidos/cota\u00e7\u00f5es ser\u00e3o sobrepostos. Confirma?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    cd.close();
                    this.processar();
                });
            } else {
                this.processar();
            }
        });
        VerticalContainer card = new VerticalContainer(new Component[0]);
        card.setShadow(Shadow.S);
        card.add(new Component[]{UIUtils.createHeader((String)"Atualizar Pedidos")});
        card.add(new Component[]{new HorizontalContainer(new Component[]{this.upload, this.cbForcar}), this.rbTipo, new FooterContainer(new Component[]{processar})});
        return card;
    }

    private void processar() {
        try {
            this.importacoesService.importarArquivos(this.getEu(), this.mBuffer.getInputStream(), this.mBuffer.getMimeType(), (ImportacoesTipoEnum)this.rbTipo.getValue(), ((Boolean)this.cbForcar.getValue()).booleanValue());
            this.showNotification("Atualiza\u00e7\u00e3o iniciada com sucesso. Ao final voc\u00ea ser\u00e1 notificado");
        }
        catch (Exception ex) {
            this.showNotification(ex.getMessage());
        }
        this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        this.nomeArquivo = "";
        this.mBuffer.clear();
    }
}

