/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.mailing.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingFavorite;
import br.com.system.app.features.mailing.model.MailingView;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.repository.MailingFavoriteRepository;
import br.com.system.app.features.mailing.repository.MailingRepository;
import br.com.system.app.features.mailing.repository.MailingViewRepository;
import br.com.system.app.features.mailing.repository.filter.MailingFilter;
import br.com.system.app.features.receitafederal.service.ReceitawsService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailingService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MailingRepository mailingRepository;
    @Autowired
    private MailingViewRepository mailingViewRepository;
    @Autowired
    private MailingFavoriteRepository mailingFavoriteRepository;
    @Autowired
    private ReceitawsService receitawsService;

    public Mailing justGet(String cnpj) {
        return this.mailingRepository.findByDocument(cnpj);
    }

    public Mailing buscarCnpj(String cnpj) {
        return this.buscarCnpj(cnpj, false, false);
    }

    public Mailing buscarCnpj(String cnpj, boolean returnNull) {
        return this.buscarCnpj(cnpj, returnNull, false);
    }

    public Mailing buscarCnpj(String cnpj, boolean returnNull, boolean forcar) {
        Mailing mailing = this.mailingRepository.findByDocument(cnpj);
        if ((mailing == null || forcar || mailing.getDataHoraAtualizacao() == null) && cnpj.length() == 14 && ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
            try {
                this.getInReceitaws(mailing, cnpj);
            }
            catch (Exception e) {
                if (returnNull) {
                    return null;
                }
                throw new BusinessException("Problemas na receita");
            }
        }
        if (mailing == null) {
            if (returnNull) {
                return null;
            }
            throw new BusinessException("CNPJ: " + cnpj + " n\u00e3o encontrado no banco de dados e Receita Federal est\u00e1 fora do ar. Tente novamente mais tarde");
        }
        return mailing;
    }

    public Mailing getInReceitaws(Mailing mailing, String cnpj) {
        Mailing mailingReceita = this.receitawsService.sincronizar(cnpj, false);
        if (mailingReceita != null) {
            if (mailing != null) {
                this.deletar(mailing);
            }
            return this.salvar(mailingReceita);
        }
        return null;
    }

    public List<Mailing> buscarLista(Set<String> listaCnpj, Estrutura estrutura) {
        ArrayList<Mailing> retorno = new ArrayList<Mailing>();
        for (String cnpj : listaCnpj) {
            Mailing mailing = this.buscarCnpj(cnpj, true);
            if (mailing == null) continue;
            retorno.add(mailing);
        }
        return retorno;
    }

    public Mailing buscarID(Long id) {
        return (Mailing)this.mailingRepository.findById((Object)id).orElseThrow(() -> new BusinessException("Mailing n\u00e3o encontrado"));
    }

    public Mailing salvar(Mailing mailing) {
        if (mailing == null) {
            throw new BusinessException("Erro ao salvar mailing, sem dados");
        }
        Mailing mailingSalvo = this.mailingRepository.findByDocument(mailing.getCpfCnpj());
        if (mailingSalvo == null) {
            mailingSalvo = new Mailing();
        }
        if (mailing.getCep().contains("***")) {
            mailing.setCep("");
        }
        if (mailing.getLogradouro().contains("***")) {
            mailing.setLogradouro("");
        }
        if (mailing.getNumero().contains("***")) {
            mailing.setNumero("");
        }
        if (mailing.getComplemento().contains("***")) {
            mailing.setComplemento("");
        }
        if (mailing.getBairro().contains("***")) {
            mailing.setBairro("");
        }
        if (mailing.getCidade().contains("***")) {
            mailing.setCidade("");
        }
        if (mailing.getEstado().contains("***")) {
            mailing.setEstado("");
        }
        if (mailing.getOpcaoMei() == null) {
            mailing.setOpcaoMei("N");
        }
        BeanUtils.copyProperties((Object)mailing, (Object)mailingSalvo, (String[])new String[]{"id", "atividades", "contatos", "pessoas", "socios"});
        mailingSalvo.getAtividades().clear();
        mailingSalvo.getContatos().clear();
        mailingSalvo.getSocios().clear();
        mailingSalvo.getAtividades().addAll(mailing.getAtividades());
        mailingSalvo.getContatos().addAll(mailing.getContatos());
        mailingSalvo.getSocios().addAll(mailing.getSocios());
        return this.persistir(mailingSalvo);
    }

    @Transactional
    private Mailing persistir(Mailing mailing) {
        if (!ValidationUtil.isValidCnpjAndCpf((String)mailing.getCpfCnpj())) {
            throw new BusinessException("CPF/CNPJ inv\u00e1lidos");
        }
        if (mailing.getNome().isEmpty()) {
            throw new BusinessException("Nome \u00e9 obrigatorio");
        }
        mailing.getAtividades().forEach(item -> item.setMailing(mailing));
        mailing.getContatos().forEach(item -> item.setMailing(mailing));
        mailing.getSocios().forEach(item -> item.setMailing(mailing));
        return (Mailing)this.mailingRepository.save((Object)mailing);
    }

    public Long count(MailingFilter filter, EstruturaUsuario euContext) {
        return this.mailingRepository.count(filter, euContext);
    }

    @Async(value="asyncDefault")
    public void count(MailingFilter filter, EstruturaUsuario euContext, Consumer<Long> listener) {
        try {
            if (listener == null) {
                return;
            }
            listener.accept(this.count(filter, euContext));
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao pesquisar");
        }
    }

    public List<MailingLimited> filter(MailingFilter filter, EstruturaUsuario euContext, Pageable pageable) {
        try {
            return this.mailingRepository.filter(filter, euContext, pageable);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao pesquisar " + e.getMessage());
        }
    }

    @Async(value="asyncDefault")
    public void filter(MailingFilter filter, EstruturaUsuario euContext, Pageable pageable, Consumer<List<MailingLimited>> listener) {
        if (listener == null) {
            return;
        }
        try {
            listener.accept(this.mailingRepository.filter(filter, euContext, pageable));
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao pesquisar " + e.getMessage());
        }
    }

    public MailingLimited getByCnpj(String cnpj, EstruturaUsuario eu) {
        MailingFilter mf = new MailingFilter();
        mf.setDocsFilters(Arrays.asList(cnpj));
        List filter = this.filter(mf, eu, (Pageable)PageRequest.of((int)0, (int)1));
        if (!filter.isEmpty()) {
            return (MailingLimited)filter.get(0);
        }
        return null;
    }

    @Async(value="asyncDefault")
    @Transactional
    public void registerMailingView(List<MailingLimited> lista, EstruturaUsuario eu) {
        Thread.currentThread().setName("asyncDefault-registermailingview");
        this.mailingRepository.inserMailingView(lista, eu);
    }

    public void registerMailingView(Mailing mailing, EstruturaUsuario estruturaUsuarioContext) {
        MailingView mailingView = this.mailingViewRepository.findByMailingAndEstruturaUsuario(mailing, estruturaUsuarioContext);
        if (mailingView == null) {
            mailingView = new MailingView();
            mailingView.setMailing(mailing);
            mailingView.setEstruturaUsuario(estruturaUsuarioContext);
        }
        mailingView.setDataView(LocalDateTime.now());
        this.mailingViewRepository.save((Object)mailingView);
    }

    public boolean favorite(Long id, EstruturaUsuario estruturaUsuarioContext) {
        Mailing mailing = (Mailing)this.mailingRepository.findById((Object)id).orElseThrow(() -> new BusinessException("Mailing n\u00e3o encontrado"));
        MailingFavorite mailingFav = this.mailingFavoriteRepository.findByMailingAndEstruturaUsuario(mailing, estruturaUsuarioContext);
        if (mailingFav == null) {
            mailingFav = new MailingFavorite();
            mailingFav.setMailing(mailing);
            mailingFav.setEstruturaUsuario(estruturaUsuarioContext);
            this.mailingFavoriteRepository.save((Object)mailingFav);
            return true;
        }
        this.mailingFavoriteRepository.delete((Object)mailingFav);
        return false;
    }

    @Modifying
    public void deletar(Mailing mailing) {
        this.mailingRepository.delete((Object)mailing);
    }

    public Boolean isAtiva(String cnpj) {
        Mailing mailing = this.buscarCnpj(cnpj);
        if (mailing == null) {
            return true;
        }
        return mailing.getSituacao().equals("ATIVA");
    }
}

