/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.marketing.service;

import br.com.system.app.features.bots.service.BotService;
import br.com.system.app.features.marketing.model.MarketingItem;
import br.com.system.app.features.marketing.model.MarketingItemStatus;
import br.com.system.app.features.marketing.model.MarketingStatus;
import br.com.system.app.features.marketing.service.MarketingSendService;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.service.WhatsAppTimeService;
import br.com.system.commons.HashUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MarketingBot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private BotService botService;
    @Autowired
    private MarketingService marketingService;
    @Autowired
    private MarketingSendService marketingSendService;
    @Autowired
    private WhatsAppTimeService whatsAppTimeService;

    @Async(value="asyncDefault")
    public void start(String processName, List<WhatsAppConta> listaContas) {
        Thread.currentThread().setName(processName);
        boolean proceed = true;
        while (proceed) {
            if (LocalDateTime.now().getHour() < 8 || LocalDateTime.now().getHour() > 18 || LocalDateTime.now().getDayOfWeek().equals(DayOfWeek.SUNDAY)) {
                SleepUtil.inSeconds((Integer)3600);
                continue;
            }
            if (this.botService.getByProcess(processName) == null) {
                Thread.currentThread().setName("asyncDefault-killed" + HashUtil.getUUI());
                break;
            }
            for (WhatsAppConta wc : listaContas) {
                try {
                    MarketingItem item;
                    if (this.whatsAppTimeService.isAlmoco(wc) || !this.whatsAppTimeService.noHorario(wc) || (item = this.marketingService.getByStatus(wc.getEstrutura(), MarketingStatus.PROCESSANDO, MarketingItemStatus.AGUARDANDO)) == null || !this.marketingSendService.checkIntegration(wc)) continue;
                    this.marketingSendService.enviar(item, wc);
                    this.marketingService.checkFinish(item.getMarketing());
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(MarketingBot.class).error("MARKETING ERRO: " + e.getMessage());
                }
            }
            SleepUtil.inMiliseconds((Integer)RandomUtil.getRandom((Integer)60000, (Integer)150000));
        }
    }
}

