/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.materialapoio.repository;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.materialapoio.model.MaterialApoioDTO;
import br.com.system.app.features.materialapoio.repository.MaterialApoioRepositoryQuery;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class MaterialApoioRepositoryImpl
implements MaterialApoioRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<MaterialApoioDTO> findByEstruturaAndNome(EstruturaUsuario eu, String nome, Pageable pageable) {
        Query query = this.getQuery(eu, nome, pageable, false);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public long countByEstruturaAndNome(EstruturaUsuario eu, String nome) {
        Query query = this.getQuery(eu, nome, null, true);
        return StringUtil.toLong((String)query.getSingleResult().toString());
    }

    public Query getQuery(EstruturaUsuario eu, String nome, Pageable pageable, boolean count) {
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append(" select count(*) total");
        } else {
            sql.append("select m.id,u.login login_usuario,m.data_upload,m.perfis,m.hash_arquivo,m.nome_arquivo,m.descricao");
        }
        sql.append(" FROM material_apoio m, estrutura_usuario eu,usuario u ");
        sql.append(" WHERE m.estrutura_usuario_id=eu.id");
        sql.append(" AND eu.usuario_id=u.id");
        sql.append(" AND eu.estrutura_id=:estruturaId");
        if (!nome.isBlank()) {
            sql.append(" AND m.nome_arquivo like :nome");
        }
        if (!eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO)) {
            sql.append(" AND (m.perfis is null or m.perfis='' or find_in_set('").append(eu.getUsuario().getPerfil().name()).append("',m.perfis))");
        }
        if (!count) {
            sql.append(" ORDER BY m.id desc");
        }
        if (pageable != null) {
            sql.append(" limit :limit offset :offset");
        }
        Query query = !count ? this.manager.createNativeQuery(sql.toString(), MaterialApoioDTO.class) : this.manager.createNativeQuery(sql.toString());
        query.setParameter("estruturaId", (Object)eu.getEstrutura().getId());
        if (!nome.isBlank()) {
            query.setParameter("nome", (Object)("%" + nome + "%"));
        }
        if (!count && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }
}

