/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.migracaoestrutura.service;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaItem;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaRepository;
import br.com.system.app.features.analisefatura.service.AnaliseFaturaService;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cliente.service.ClienteTagService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.migracaoestrutura.service.MigracaoEstruturaThread;
import br.com.system.app.features.migracaoestrutura.service.MigracaoEstruturaUtil;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MigracaoEstruturaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(MigracaoEstruturaService.class);
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteTagService clienteTagService;
    @Autowired
    private PedidoTagsService pedidoTagsService;
    @Autowired
    private AnaliseFaturaService analiseFaturaService;
    @Autowired
    private AnaliseFaturaRepository analiseFaturaRepository;
    @Autowired
    private MigracaoEstruturaUtil util;
    @Autowired
    private MigracaoEstruturaThread thread;

    public void doMigracao(Estrutura origem, Estrutura destino, Integer page, String migracoes, String cpfCnpj, boolean forcar) {
        try {
            EstruturaUsuario master = this.eus.getMasterEstrutura(destino);
            List<String> arrM = Arrays.asList(migracoes.split(","));
            if (arrM.contains("TAGS")) {
                this.doTagCliente(origem, destino, master);
                this.doTagPedido(origem, destino, master);
            }
            if (arrM.contains("CLIENTES")) {
                page = page == null ? 0 : page;
                Integer total = this.clienteService.countByEstrutura(origem);
                boolean continuar = true;
                while (continuar) {
                    List<Object> clientes;
                    if (cpfCnpj != null && !cpfCnpj.isBlank()) {
                        clientes = new ArrayList<Cliente>();
                        clientes.add(this.clienteService.buscarPeloCnpj(cpfCnpj, origem));
                        continuar = false;
                    } else {
                        Integer nroReg = page * 100 > total ? 100 - (page * 100 - total) : 100;
                        clientes = this.clienteService.getByEstrutura(origem, (Pageable)PageRequest.of((int)page, (int)nroReg));
                    }
                    for (Cliente o : clientes) {
                        this.thread.doMigration(o, destino, master, forcar);
                    }
                    SleepUtil.inSeconds((Integer)2);
                    Integer n = page;
                    page = page + 1;
                }
            }
            if (arrM.contains("FATURAS")) {
                List faturas = this.analiseFaturaService.getByEstrutura(origem);
                this.doFaturas(faturas, destino, master);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private void doFaturas(List<AnaliseFatura> faturas, Estrutura destino, EstruturaUsuario master) {
        for (AnaliseFatura fo : faturas) {
            try {
                AnaliseFatura existe = this.analiseFaturaRepository.findFirstByEstruturaUsuarioEstruturaAndObservacaoContains(destino, "Migrado: " + fo.getId());
                if (existe != null) continue;
                AnaliseFatura fd = new AnaliseFatura();
                fd.setCodigoConta(fo.getCodigoConta());
                fd.setCpfCnpj(fo.getCpfCnpj());
                fd.setDataHoraImportacao(fo.getDataHoraImportacao());
                fd.setDataVencimento(fo.getDataVencimento());
                fd.setEstruturaUsuario(this.util.getEu(fo.getEstruturaUsuario(), destino, master));
                fd.setHashArquivoAnalisado(fo.getHashArquivoAnalisado());
                fd.setHashArquivoAnalisadoDetalhamento(fo.getHashArquivoAnalisadoDetalhamento());
                fd.setHashArquivoOriginal(fo.getHashArquivoOriginal());
                fd.setItens(this.getItensFatura(fo, fd));
                fd.setMesAno(fo.getMesAno());
                fd.setNomeArquivo(fo.getNomeArquivo());
                fd.setNomeCliente(fo.getNomeCliente());
                fd.setObservacao(fo.getObservacao() + "Migrado: " + fo.getId());
                fd.setOperadora(fo.getOperadora());
                fd.setStatusAnalise(fo.getStatusAnalise());
                fd.setValorTotal(fo.getValorTotal());
                this.analiseFaturaService.save(fd);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private Set<AnaliseFaturaItem> getItensFatura(AnaliseFatura fo, AnaliseFatura fd) {
        List itens = this.analiseFaturaService.getFaturaItens(fo);
        HashSet<AnaliseFaturaItem> retorno = new HashSet<AnaliseFaturaItem>();
        for (AnaliseFaturaItem o : itens) {
            AnaliseFaturaItem d = new AnaliseFaturaItem();
            d.setAnaliseFatura(fd);
            d.setAparelhoNome(o.getAparelhoNome());
            d.setAparelhoValor(o.getAparelhoValor());
            d.setDadosInter(o.getDadosInter());
            d.setDadosLocal(o.getDadosLocal());
            d.setNumero(o.getNumero());
            d.setOutrosValor(o.getOutrosValor());
            d.setPlanoNome(o.getPlanoNome());
            d.setPlanoValor(o.getPlanoValor());
            d.setTemConsumo(o.isTemConsumo());
            d.setValorDesconto(o.getValorDesconto());
            d.setValorTotal(o.getValorTotal());
            d.setVozInter(o.getVozInter());
            d.setVozLd(o.getVozLd());
            d.setVozLocal(o.getVozLocal());
            retorno.add(d);
        }
        return retorno;
    }

    private void doTagCliente(Estrutura origem, Estrutura destino, EstruturaUsuario master) {
        List tags = this.clienteTagService.getTags(origem);
        for (ClienteTag o : tags) {
            try {
                ClienteTag d = new ClienteTag();
                d.setEstrutura(destino);
                d.setTag(o.getTag());
                d.setUsuario(master.getUsuario());
                this.clienteTagService.save(d);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private void doTagPedido(Estrutura origem, Estrutura destino, EstruturaUsuario master) {
        List tags = this.pedidoTagsService.getAllTags(origem);
        for (PedidoTags o : tags) {
            try {
                PedidoTags d = new PedidoTags();
                d.setEstrutura(destino);
                d.setPedidoTipo(o.getPedidoTipo());
                d.setTag(o.getTag());
                d.setUsuario(master.getUsuario());
                this.pedidoTagsService.save(d);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }
}

