/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.components;

import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.notificacoes.components.NotificacoesPaginator;
import br.com.system.app.features.notificacoes.model.Notificacoes;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;

public class NotificacoesPaginator
extends Div {
    private static final long serialVersionUID = 1L;
    private final List<ChangePageListener> listeners = new ArrayList();
    private long totalElements;
    private int totalPages;
    private int currentPage;
    private int size;
    private final Div main;

    public NotificacoesPaginator() {
        this.getStyle().set("padding", "10px");
        this.main = new Div();
        this.main.setWidthFull();
        this.main.setHeightFull();
        this.main.getStyle().set("display", "flex");
        this.add(new Component[]{this.main});
        this.render();
    }

    private void notifyListeners(int currentPage) {
        this.listeners.forEach(listener -> listener.onChange(currentPage));
    }

    public void addChangePageListener(ChangePageListener listener) {
        this.listeners.add(listener);
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void updateState(int currentPage, int size, int totalPages, long totalElements) {
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        this.totalElements = totalElements;
        this.size = size;
        this.render();
    }

    public void updateState(Page<Notificacoes> page) {
        this.updateState(page.getNumber(), page.getSize(), page.getTotalPages(), page.getTotalElements());
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private void render() {
        this.main.removeAll();
        this.main.add(new Component[]{this.createPrevButton(), this.createCurrentStatusDisplay(), this.createNextButton()});
    }

    private Component createPrevButton() {
        Button buttonPrev = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_BACKWARD, (String)"Pr\u00f3xima p\u00e1gina");
        buttonPrev.setEnabled(this.getCurrentPage() - 1 >= 0);
        buttonPrev.addClickListener((ComponentEventListener & Serializable)event -> this.notifyListeners(this.getCurrentPage() - 1));
        return buttonPrev;
    }

    private Component createNextButton() {
        Button buttonNext = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_FORWARD, (String)"P\u00e1gina anterior");
        buttonNext.getStyle().set("margin-left", "5px");
        buttonNext.setEnabled(this.getCurrentPage() + 1 < this.getTotalPages());
        buttonNext.addClickListener((ComponentEventListener & Serializable)event -> this.notifyListeners(this.getCurrentPage() + 1));
        return buttonNext;
    }

    private Component createCurrentStatusDisplay() {
        Div panel = new Div();
        panel.getStyle().set("display", "flex");
        panel.getStyle().set("margin-left", "10px");
        panel.getStyle().set("align-self", "center");
        if (this.getTotalPages() > 0) {
            panel.setText(String.format("%d / %d", this.getCurrentPage() + 1, this.getTotalPages()));
        } else {
            panel.setText("N\u00e3o foram encontrados registros");
        }
        return panel;
    }
}

