/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.model;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.PedidoTagsCategoria;
import br.com.system.app.features.usuario.model.Usuario;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

@Entity
@Table(name="pedido_tags")
public class PedidoTags
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    private Estrutura estrutura;
    @OneToOne
    private Usuario usuario;
    @OneToOne
    private PedidoTagsCategoria pedidoTagsCategoria;
    @Enumerated(value=EnumType.STRING)
    private PedidoTipoEnum pedidoTipo;
    private String tag;

    public PedidoTags() {
    }

    public PedidoTags(Estrutura estrutura, Usuario usuario, String tag) {
        this.estrutura = estrutura;
        this.usuario = usuario;
        this.tag = tag;
    }

    public String getTagAndCategoria() {
        return this.getPedidoTagsCategoria().getNome() + " " + this.getTag();
    }

    public String getTagsAndTipo() {
        return this.getTag() + "(" + this.getPedidoTipo().name() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public PedidoTipoEnum getPedidoTipo() {
        return this.pedidoTipo;
    }

    public void setPedidoTipo(PedidoTipoEnum pedidoTipo) {
        this.pedidoTipo = pedidoTipo;
    }

    public PedidoTagsCategoria getPedidoTagsCategoria() {
        return this.pedidoTagsCategoria;
    }

    public void setPedidoTagsCategoria(PedidoTagsCategoria pedidoTagsCategoria) {
        this.pedidoTagsCategoria = pedidoTagsCategoria;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.estrutura);
        hash = 29 * hash + Objects.hashCode(this.tag);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PedidoTags other = (PedidoTags)obj;
        if (!Objects.equals(this.tag, other.tag)) {
            return false;
        }
        return Objects.equals(this.estrutura, other.estrutura);
    }

    public String toString() {
        return this.tag;
    }
}

