/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.dto.PedidoItemPropostaDTO;
import br.com.system.app.features.pedido.dto.PedidoItemResumoLinhaDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.repository.PedidoItemRepository;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.storage.model.UrlSign;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtividadeHtmlProposta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal valorCompMensal;
    private BigDecimal valorOutros;
    private Integer totalGiga;
    private String html;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private EstruturaTipoService estruturaTipoService;

    public String getResumoLinhas(Pedido pedido) {
        Object html = "<style>\ntable, td, th {  \n  border: 1px solid #ddd;\n  text-align: left;\n}\n\ntable {\n  border-collapse: collapse;\n  width: 100%;\n}\n\nth, td {\n  padding: 15px;\n}\ntr:nth-child(even) {background-color: #f2f2f2;}\n</style><table class=\"table\"><tr><th>Linha</th><th>Plano</th></tr>";
        List itens = this.pedidoItemRepository.findResumoLinhas(pedido.getId());
        for (PedidoItemResumoLinhaDTO item : itens) {
            html = (String)html + "<tr><td>" + item.getNumero() + "</td><td>" + item.getNomeProduto() + "</td></tr>";
        }
        html = (String)html + "</table>";
        return html;
    }

    public String gerarHtml(Pedido pedido) throws Exception {
        this.html = pedido.getModeloProposta().getConteudoHtml();
        String nomeCliente = pedido.getCliente().getNome().length() <= 60 ? pedido.getCliente().getNome() : pedido.getCliente().getNome().substring(0, 60);
        this.html = this.html.replace("#nomeCliente", nomeCliente);
        this.html = this.html.replace("#numeroProposta", pedido.getId().toString());
        this.html = this.html.replace("#nomeUsuario", pedido.getEstruturaUsuario().getUsuario().getNome());
        this.html = this.html.replace("#emailUsuario", pedido.getEstruturaUsuario().getUsuario().getEmail());
        this.html = this.html.replace("#celularUsuario", pedido.getEstruturaUsuario().getUsuario().getCelular() == null ? "" : pedido.getEstruturaUsuario().getUsuario().getCelular());
        this.html = this.html.replace("#observacaoProposta", pedido.getObservacaoProposta());
        this.html = this.getNegociacoes(this.html, pedido);
        this.updateImages();
        return this.html.replace("http:", "https:");
    }

    private String getNegociacoes(String html, Pedido pedido) {
        this.valorCompMensal = BigDecimal.ZERO;
        this.valorOutros = BigDecimal.ZERO;
        this.totalGiga = 0;
        Estrutura e = pedido.getEstruturaUsuario().getEstrutura();
        html = html.replace("#negociacaoCompMensal", this.getHtmlItem(html, this.pedidoItemRepository.findPropostaItens(pedido.getId(), Boolean.valueOf(true)), "Descritivo", e, false));
        html = html.replace("#negociacaoOutros", this.getHtmlItem(html, this.pedidoItemRepository.findPropostaItens(pedido.getId(), Boolean.valueOf(false)), "Aparelhos/Outros", e, true));
        html = html.replace("#valorCompMensal", UIUtils.formatCurrency((BigDecimal)this.valorCompMensal));
        html = html.replace("#valorFatura", UIUtils.formatCurrency((BigDecimal)pedido.getValorFaturaOrigem()));
        html = html.replace("#valorTotal", UIUtils.formatCurrency((BigDecimal)this.valorCompMensal.add(this.valorOutros)));
        html = html.replace("#quebraPagina", "<div style=\"break-after:page\"></div>");
        if (this.valorCompMensal != null && this.valorOutros != null && this.valorOutros.doubleValue() > 0.0) {
            html = html.replace("#compMensalOutros24x", UIUtils.formatCurrency((BigDecimal)this.valorCompMensal.add(this.valorOutros.divide(new BigDecimal(24), RoundingMode.FLOOR))));
        }
        String giga = String.valueOf(this.totalGiga / 1024);
        html = html.replace("#totalGigas", giga);
        if (this.valorOutros != null && this.valorOutros.doubleValue() > 0.0) {
            html = html.replace("#valorOutros10x", UIUtils.formatCurrency((BigDecimal)this.valorOutros.divide(new BigDecimal(10), RoundingMode.FLOOR)));
            html = html.replace("#valorOutros12x", UIUtils.formatCurrency((BigDecimal)this.valorOutros.divide(new BigDecimal(12), RoundingMode.FLOOR)));
            html = html.replace("#valorOutros24x", UIUtils.formatCurrency((BigDecimal)this.valorOutros.divide(new BigDecimal(24), RoundingMode.FLOOR)));
            html = html.replace("#valorOutros", UIUtils.formatCurrency((BigDecimal)this.valorOutros));
        }
        if (pedido.getValorFaturaOrigem() != null && pedido.getValorFaturaOrigem().doubleValue() > 0.0 && this.valorCompMensal.doubleValue() > 0.0) {
            BigDecimal vlmensal = this.valorCompMensal.add(this.valorOutros.divide(new BigDecimal(24), RoundingMode.FLOOR));
            html = html.replace("#diferenca", UIUtils.formatCurrency((BigDecimal)pedido.getValorFaturaOrigem().subtract(vlmensal)));
            html = html.replace("#economia24Meses", UIUtils.formatCurrency((BigDecimal)pedido.getValorFaturaOrigem().subtract(vlmensal).multiply(new BigDecimal(24)).setScale(2)));
            html = html.replace("#percentualEconomia", new BigDecimal(100).subtract(vlmensal.multiply(new BigDecimal(100)).divide(pedido.getValorFaturaOrigem(), RoundingMode.FLOOR)).toString());
        }
        return html;
    }

    private String getHtmlItem(String html, List<PedidoItemPropostaDTO> itens, String cabecalho, Estrutura e, boolean outros) {
        String htmlItem = "<style>\ntable, td, th {  \n  border: 1px solid #ddd;\n  text-align: left;\n  font-family:Arial, Helvetica, sans-serif; font-size: 13px;}\n\ntable {\n  border-collapse: collapse;\n  max-width: 900px;\n}\n\nth, td {\n  padding: 5px;\n}\ntr:nth-child(even) {background-color: #f2f2f2;}\n</style><table class=\"table\"><tr><ht colspan=3>" + cabecalho + "</th></tr>";
        htmlItem = outros ? htmlItem + "<tr><th>Produto</th><th>Quantidade</th><th>Valor mensal</th></tr>" : htmlItem + "<tr><th>Produto</th><th>Quantidade</th><th>Valor Unit\u00e1rio</th><th>Total</th></tr>";
        for (PedidoItemPropostaDTO item : itens) {
            BigDecimal valor = item.getValor();
            if (item.getQuantidade() <= 0) continue;
            if (item.getCompromissoMensal().booleanValue()) {
                this.valorCompMensal = this.valorCompMensal.add(valor);
            } else {
                this.valorOutros = this.valorOutros.add(valor);
            }
            if (item.getQuantosMegas() != null) {
                this.totalGiga = this.totalGiga + item.getQuantosMegas() * item.getQuantidade();
            }
            BigDecimal v = BigDecimal.valueOf(item.getValor().doubleValue() / (double)item.getQuantidade().intValue());
            htmlItem = htmlItem + "<tr>";
            htmlItem = htmlItem + "<td>" + item.getNomeProduto() + "</td>";
            htmlItem = htmlItem + "<td>" + item.getQuantidade() + "</td>";
            if (outros && html.contains("#valorOutros10x")) {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor.divide(new BigDecimal(10), RoundingMode.FLOOR)) + "</td>";
            } else if (outros && html.contains("#valorOutros12x")) {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor.divide(new BigDecimal(12), RoundingMode.FLOOR)) + "</td>";
            } else if (outros && html.contains("#valorOutros24x")) {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor.divide(new BigDecimal(24), RoundingMode.FLOOR)) + "</td>";
            } else if (outros) {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor) + "</td>";
            } else if (this.estruturaTipoService.isTicket(e)) {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor) + "</td>";
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor.multiply(BigDecimal.valueOf(Double.valueOf(item.getNumero())))) + "</td>";
            } else {
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)v) + "</td>";
                htmlItem = htmlItem + "<td>" + UIUtils.formatCurrency((BigDecimal)valor) + "</td>";
            }
            htmlItem = htmlItem + "</tr>";
        }
        htmlItem = htmlItem + "</table>";
        return htmlItem;
    }

    public void updateImages() {
        Document doc = Jsoup.parse((String)this.html, (String)"UTF-8");
        doc.select("img[src]").forEach(e -> {
            String img = e.attr("src");
            img = img.replace("https://storage.googleapis.com/bucket-neocrm/", "");
            UrlSign urlSign = null;
            urlSign = StorageUtil.getUrlSign((String)img, (String)"bucket-neosales");
            if (urlSign != null && urlSign.getUrl() != null) {
                this.html = this.html.replace(e.attr("src"), urlSign.getUrl());
            }
        });
    }
}

