/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ImportacaoAtividadeThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private MailingService mailingService;

    @Async(value="asyncDefault")
    public void processarArquivo(HashMap<String, Integer> colunas, InputStream conteudo, String nomeArquivo, EstruturaUsuario euContext, Set<HierarquiaDTO> hierarquia, PedidoTipoEnum pte, boolean abrirParaInativas) {
        Thread.currentThread().setName("asyncDefault-importacao-atividade");
        ArrayList<EstruturaUsuario> l = new ArrayList<EstruturaUsuario>();
        for (HierarquiaDTO hierarquiaDTO : hierarquia) {
            l.add(this.estruturaUsuarioService.getById(hierarquiaDTO.getEstruturaUsuarioId()));
        }
        this.processarArquivo(colunas, conteudo, nomeArquivo, euContext, l, pte, abrirParaInativas);
    }

    @Async(value="asyncDefault")
    public void processarArquivo(HashMap<String, Integer> colunas, InputStream conteudo, String nomeArquivo, EstruturaUsuario euContext, List<EstruturaUsuario> hierarquia, PedidoTipoEnum pte, boolean abrirParaInativas) {
        Thread.currentThread().setName("asyncDefault-importacao-atividade2");
        if (hierarquia.size() <= 0) {
            hierarquia.add(euContext);
        }
        StringBuilder log = new StringBuilder();
        XSSFWorkbook xls = null;
        try {
            xls = new XSSFWorkbook(conteudo);
            Sheet aba = xls.getSheetAt(0);
            int ind = 0;
            for (int r = 0; r <= aba.getLastRowNum(); ++r) {
                ind = ind >= hierarquia.size() ? 0 : ind;
                EstruturaUsuario eu = hierarquia.get(ind);
                Row row = aba.getRow(r);
                if (row == null || this.getCellValue(colunas, "CPF_CNPJ", row).equals("CPF_CNPJ")) continue;
                String cnpj = StringUtil.normalizeCpfCnpj((String)this.getCellValue(colunas, "CPF_CNPJ", row));
                if ((cnpj = StringUtil.numbersOnly((String)cnpj)).isEmpty()) continue;
                try {
                    Mailing m;
                    if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                        log.append(cnpj).append(" inv\u00e1lido ").append("<BR>");
                        continue;
                    }
                    if (ValidationUtil.isValidCNPJ((String)cnpj) && !abrirParaInativas && (m = this.mailingService.buscarCnpj(cnpj)) != null && !m.getSituacao().equals("ATIVA")) {
                        log.append(cnpj).append(" n\u00e3o est\u00e1 ATIVO").append("<BR>");
                        continue;
                    }
                    String nome = this.getCellValue(colunas, "NOME", row);
                    Object complemento = this.getCellValue(colunas, "INFORMA\u00c7\u00d5ES ATIVIDADE", row);
                    String tags = this.getCellValue(colunas, "TAGS", row);
                    String loginUsuario = this.getCellValue(colunas, "LOGIN_USUARIO", row);
                    HashSet<ClienteContato> contatos = new HashSet<ClienteContato>();
                    for (int i = 0; i < colunas.size(); ++i) {
                        String telefone;
                        String email = this.getCellValue(colunas, "E-MAIL " + i, row);
                        if (ValidationUtil.isValidEmail((String)email)) {
                            contatos.add(new ClienteContato(TipoContatoEnum.EMAIL, email, ClienteContatoVerficadoEnum.NAO_VERIFICADO));
                            complemento = (String)complemento + "\nEmail " + email;
                        }
                        if (!TelefoneUtil.isValid((String)(telefone = this.getCellValue(colunas, "TELEFONE " + i, row)))) continue;
                        contatos.add(new ClienteContato(TipoContatoEnum.TELEFONE, telefone, ClienteContatoVerficadoEnum.NAO_VERIFICADO));
                        complemento = (String)complemento + "\nTelefone " + telefone;
                    }
                    PedidoOrigem pedidoOrigem = this.pedidoOrigemService.getOrigemAtividade(eu.getEstrutura());
                    PedidoEtapa pedidoEtapa = this.pedidoEtapaService.getEtapaInicial(eu.getEstrutura(), pte);
                    Pedido pedido = new Pedido();
                    pedido.setPedidoOrigem(pedidoOrigem);
                    pedido.setPedidoTipo(pte);
                    pedido.setComplementos((String)complemento);
                    pedido.setCliente(this.getCliente(eu, cnpj, nome, contatos));
                    pedido.setDataCadastro(LocalDate.now());
                    pedido.setPedidoEtapa(pedidoEtapa);
                    pedido.setDataHoraAtualizacao(LocalDateTime.now());
                    if (!loginUsuario.isEmpty()) {
                        Usuario user = this.usuarioService.getByLogin(loginUsuario);
                        if (user != null) {
                            pedido.setEstruturaUsuario((EstruturaUsuario)this.estruturaUsuarioService.getByUsuarioAndEstrutura(user, euContext.getEstrutura()).get());
                        } else {
                            pedido.setEstruturaUsuario(eu);
                        }
                    } else {
                        pedido.setEstruturaUsuario(eu);
                    }
                    pedido.setTags(StringUtil.normalizeTags((String)tags));
                    pedido.setTotal(BigDecimal.ZERO);
                    pedido = this.pedidoService.salvar(pedido);
                    ++ind;
                    log.append("CPF_CNPJ: ").append(cnpj).append(" criou a atividade: ").append(pedido.getNumero()).append("<BR>");
                    pedido = null;
                    pedidoOrigem = null;
                    pedidoEtapa = null;
                    continue;
                }
                catch (Exception eItem) {
                    log.append("CPF_CNPJ: ").append(cnpj).append(" ERRO: ").append(eItem.getMessage()).append("<BR>");
                }
            }
        }
        catch (IOException e) {
            throw new BusinessException("Erro ao processar arquivo: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                xls = null;
            }
            catch (Exception exception) {}
        }
        if (log.toString().isEmpty()) {
            log.append("Arquivo sem conte\u00fado v\u00e1lido");
        }
        this.notificacoesService.notify(euContext, "Criando Atividades de " + pte.name() + " via arquivo " + nomeArquivo, log.toString());
    }

    private String getCellValue(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = this.getPosition(colunas, columName, row);
        if (posicao < 0) {
            return "";
        }
        Cell cell = row.getCell(posicao.intValue());
        return ExcellUtil.getValueString((Cell)cell).trim();
    }

    private Integer getPosition(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = -1;
        for (Map.Entry<String, Integer> entry : colunas.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(columName)) continue;
            posicao = entry.getValue();
            break;
        }
        if (posicao == null || posicao < 0) {
            return -1;
        }
        if (row.getCell(posicao.intValue()) == null) {
            return -1;
        }
        return posicao;
    }

    private Cliente getCliente(EstruturaUsuario eu, String cnpj, String nome, Set<ClienteContato> contatos) {
        return this.clienteService.getAndCreateCliente(eu, cnpj, nome, contatos);
    }
}

