/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemDados;
import br.com.system.app.features.pedido.repository.PedidoItemRepository;
import br.com.system.app.features.pedido.service.PedidoItemDadosService;
import br.com.system.app.features.pedido.service.PedidoLogService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelResumoDatasService;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoItemService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoLogService pedidoLogService;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private PedidoItemDadosService pedidoItemDadosService;
    @Autowired
    private ProducaoPainelResumoDatasService producaoPainelResumoDatasService;

    public PedidoItem salvar(PedidoItem item, EstruturaUsuario eu) {
        if (item.getId() == null) {
            String alt = "Item INSERIDO " + item.getProduto().getNome();
            this.pedidoLogService.salvar(item.getPedido(), eu, alt);
        } else {
            Object alt = this.getLog(item);
            if (((String)alt).isEmpty()) {
                alt = "Item ALTERADO\n" + (String)alt;
            }
            if (item.getEstrutura() == null) {
                item.setEstrutura(item.getPedido().getEstruturaUsuario().getEstrutura());
            }
            this.pedidoLogService.salvar(item.getPedido(), eu, (String)alt);
        }
        return (PedidoItem)this.pedidoItemRepository.save((Object)item);
    }

    public Set<PedidoItem> getByPedido(Pedido pedido) {
        return this.pedidoItemRepository.findByPedido(pedido);
    }

    @Transactional
    public void removeItem(PedidoItem item, EstruturaUsuario eu) {
        String alt = "Item EXCLUIDO, " + item.getPedidoItemSolicitacao().getNome() + ", " + item.getProduto().getNome() + " qtde " + item.getQuantidade() + " numero " + item.getNumero();
        this.pedidoLogService.salvar(item.getPedido(), eu, alt);
        this.pedidoItemDadosService.deleteByItem(item);
        this.pedidoItemRepository.delete((Object)item);
    }

    public PedidoItem getById(Long id) {
        return (PedidoItem)this.pedidoItemRepository.findById((Object)id).get();
    }

    public void deleteByPedido(Pedido pedido) {
        this.pedidoItemDadosService.deleteByPedido(pedido);
        this.pedidoItemRepository.deleteByPedido(pedido);
    }

    @Transactional
    public void updateData(Long pedidoId, LocalDate data) {
        this.pedidoItemRepository.updateData(pedidoId, data);
        this.producaoPainelResumoDatasService.atualizarDatas(pedidoId, LocalDateTime.now());
    }

    public void updateData(Set<Long> lista, LocalDate data) {
        Set atualizar = this.pedidoItemRepository.findForUpdateData(lista);
        this.pedidoItemRepository.updateData(lista, data);
        this.producaoPainelResumoDatasService.atualizarDatas(atualizar, data.atStartOfDay());
    }

    public void updateDataForce(Set<Long> lista, LocalDate data) {
        Set atualizar = this.pedidoItemRepository.findForUpdateDataForce(lista);
        this.pedidoItemRepository.updateData(lista, data);
        this.producaoPainelResumoDatasService.atualizarDatas(atualizar, data.atStartOfDay());
    }

    private String getLog(PedidoItem i) {
        PedidoItem io = this.getById(i.getId());
        StringBuilder s = new StringBuilder();
        if (this.compare((Object)io.getDataInstalacao(), (Object)i.getDataInstalacao())) {
            s.append("Data Instala\u00e7\u00e3o ").append(StringUtil.getString((Object)io.getDataInstalacao())).append(" para ").append(StringUtil.getString((Object)i.getDataInstalacao())).append("\n");
        }
        if (this.compare((Object)io.getDataPortabilidade(), (Object)i.getDataPortabilidade())) {
            s.append("Data Portabilidade ").append(StringUtil.getString((Object)io.getDataPortabilidade())).append(" para ").append(StringUtil.getString((Object)i.getDataPortabilidade())).append("\n");
        }
        if (this.compare((Object)io.getDataReferencia(), (Object)i.getDataReferencia())) {
            s.append("Data Referencia ").append(StringUtil.getString((Object)io.getDataReferencia())).append(" para ").append(StringUtil.getString((Object)i.getDataReferencia())).append("\n");
        }
        if (this.compare((Object)io.getDescontoPorItem().doubleValue(), (Object)i.getDescontoPorItem().doubleValue())) {
            s.append("Desconto ").append(StringUtil.getString((Object)io.getDescontoPorItem())).append(" para ").append(StringUtil.getString((Object)i.getDescontoPorItem())).append("\n");
        }
        if (this.compare((Object)io.getNumero(), (Object)i.getNumero())) {
            s.append("N\u00famero ").append(StringUtil.getString((Object)io.getNumero())).append(" para ").append(StringUtil.getString((Object)i.getNumero())).append("\n");
        }
        if (this.compare((Object)io.getNumeroProvisorio(), (Object)i.getNumeroProvisorio())) {
            s.append("N\u00famero Provis\u00f3rio ").append(StringUtil.getString((Object)io.getNumeroProvisorio())).append(" para ").append(StringUtil.getString((Object)i.getNumeroProvisorio())).append("\n");
        }
        if (this.compare((Object)io.getProduto().getId(), (Object)i.getProduto().getId())) {
            s.append("Produto ").append(StringUtil.getString((Object)io.getProduto().getNome())).append(" para ").append(StringUtil.getString((Object)i.getProduto().getNome())).append("\n");
        }
        if (this.compare((Object)io.getQuantidade(), (Object)i.getQuantidade())) {
            s.append("Quantidade ").append(StringUtil.getString((Object)io.getQuantidade())).append(" para ").append(StringUtil.getString((Object)i.getQuantidade())).append("\n");
        }
        if (this.compare((Object)io.getValorUnitario(), (Object)i.getValorUnitario())) {
            s.append("Valor Unit\u00e1rio ").append(StringUtil.getString((Object)io.getValorUnitario())).append(" para ").append(StringUtil.getString((Object)i.getValorUnitario())).append("\n");
        }
        if (this.compare((Object)io.getPeriodo(), (Object)i.getPeriodo())) {
            s.append("Periodo ").append(StringUtil.getString((Object)io.getPeriodo())).append(" para ").append(StringUtil.getString((Object)i.getPeriodo())).append("\n");
        }
        if (this.compare((Object)io.getRpon(), (Object)i.getRpon())) {
            s.append("RPON ").append(StringUtil.getString((Object)io.getRpon())).append(" para ").append(StringUtil.getString((Object)i.getRpon())).append("\n");
        }
        if (this.compare((Object)io.getInstancia(), (Object)i.getInstancia())) {
            s.append("Instancia ").append(StringUtil.getString((Object)io.getInstancia())).append(" para ").append(StringUtil.getString((Object)i.getInstancia())).append("\n");
        }
        if (this.compare((Object)io.getComplementos(), (Object)i.getComplementos())) {
            s.append("Informa\u00e7\u00f5es ").append(StringUtil.getString((Object)io.getComplementos())).append(" para ").append(StringUtil.getString((Object)i.getComplementos())).append("\n");
        }
        return s.toString();
    }

    public PedidoItemDados getItemDados(PedidoItem pi) {
        return this.pedidoItemDadosService.getByPedidoItem(pi);
    }

    public PedidoItemDados saveItemDados(PedidoItemDados pid) {
        return this.pedidoItemDadosService.save(pid);
    }

    @Transactional
    public void deleteItemDados(PedidoItem pi) {
        this.pedidoItemDadosService.deleteByItem(pi);
    }

    public boolean compare(Object oo, Object o) {
        String so;
        if (oo instanceof BigDecimal) {
            return ((BigDecimal)oo).compareTo((BigDecimal)o) != 0;
        }
        String soo = StringUtil.getString((Object)oo);
        return !soo.equals(so = StringUtil.getString((Object)o));
    }
}

