/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.repository.PedidoItemRepository;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="alterar-etapa-item", layout=MainLayout.class)
@PageTitle(value="Alterar Etapa item do pedido")
@RolesAllowed(value={"MASTER"})
public class PedidoEtapaItemView
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoItemRepository pir;
    private final PedidoItemEtapaService pes;
    private final PedidoService ps;

    @Autowired
    public PedidoEtapaItemView(PedidoItemRepository pir, PedidoItemEtapaService pes, PedidoService ps) {
        super(new Component[0]);
        this.pir = pir;
        this.pes = pes;
        this.ps = ps;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.createContent();
        }
    }

    private void createContent() {
        this.setWidthFull();
        TextArea ta = new TextArea("Lista de Pedidos");
        ComboBox cb = new ComboBox("Etapa Item", (Collection)this.pes.getByEstrutura(this.getEstrutura()));
        cb.setItemLabelGenerator(PedidoItemEtapa::getNomeAndOrigem);
        Button btn = UIUtils.createSmallButton((String)"Alterar");
        btn.setDisableOnClick(true);
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cb.getValue() == null) {
                UIUtils.showNotification((String)"Selecione uma etapa ITEM");
                return;
            }
            if (ta.isEmpty()) {
                UIUtils.showNotification((String)"Informe uma lista");
                return;
            }
            Object log = "";
            for (String s : ta.getValue().split("\n")) {
                Pedido pedido = this.ps.getByNumeroAndEstrutura(s.trim(), this.getEstrutura());
                if (pedido != null) {
                    this.pir.updateEtapa(pedido.getId(), ((PedidoItemEtapa)cb.getValue()).getId());
                    log = (String)log + s + " Alterado com sucesso\n";
                    continue;
                }
                log = (String)log + s + " N\u00e3o localizado\n";
            }
            UIUtils.showNotification((String)log);
            btn.setEnabled(true);
        });
        this.add(new Component[]{ta, cb, btn});
    }
}

