/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.claro.CalculoVariacaoRenovacao;
import br.com.system.app.features.endereco.EnderecoView;
import br.com.system.app.features.endereco.model.EnderecoTipoEnum;
import br.com.system.app.features.endereco.service.EnderecoService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemDados;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.service.PedidoItemDadosService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.features.shared.model.PeriodoEnum;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.CurrencyUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AtividadeItemView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProdutoOrigem po = ProdutoOrigem.NEOCRM;
    @Autowired
    private EnderecoService enderecoService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private CepService cepService;
    @Autowired
    private PedidoItemDadosService dadosService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    private EnderecoView enderecoView;
    private PedidoItem pi;
    private ComboBox<ProdutoCategoria> cbCategoriaProduto;
    private ComboBox<Produto> cbProduto;
    private TextArea infItem;
    private NumberField quantidade;
    private NumberField valor;
    private NumberField valorBaseAtual;
    private NumberField valorAgregado;
    private NumberField desconto;
    private TextField variacaoRenovacaoClaro;
    private TextField numero;
    private TextField numeroProvisorio;
    private ComboBox<PedidoItemSolicitacao> cbSolicitacao;
    private Pedido pedido;
    private DatePicker dataInstalacao;
    private DatePicker dataPortabilidade;
    private ComboBox<PeriodoEnum> cbPeriodo;
    private TextField rpon;
    private TextField instancia;
    private TextField operadoraCedente;
    private TextField nomeCedente;
    private TextField cpfCnpjCedente;
    private TextField emailCedente;
    private TextField telefoneCedente;
    private PedidoItemDados itemDados;
    private EstruturaComplemento eComp;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(Pedido pedido, PedidoItem item, List<ProdutoCategoria> listaCategoria, List<PedidoItemSolicitacao> solicitacoes, List<Produto> produtos) {
        this.setWidth("100%");
        this.setMaxWidth("700px");
        this.eComp = this.estruturaComplementoService.getComplementos(this.getEstrutura());
        this.pedido = pedido;
        this.removeAll();
        this.pi = item == null ? new PedidoItem() : item;
        TextField soma = new TextField("Comp Mensal");
        soma.setWidthFull();
        soma.setReadOnly(true);
        this.itemDados = this.dadosService.getByPedidoItem(this.pi);
        if (this.itemDados == null) {
            this.itemDados = new PedidoItemDados();
        }
        Button btnConf = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK);
        Button btnItemClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        if (this.isTelefonia()) {
            this.operadoraCedente = new TextField("Operadora Cedente");
            this.operadoraCedente.setWidth("100%");
            if (this.itemDados.getOperadoraCedente() != null) {
                this.operadoraCedente.setValue(this.itemDados.getOperadoraCedente());
            }
            this.nomeCedente = new TextField("Nome Cedente");
            this.nomeCedente.setWidth("100%");
            if (this.itemDados.getNomeCedente() != null) {
                this.nomeCedente.setValue(this.itemDados.getNomeCedente());
            }
            this.cpfCnpjCedente = new TextField("CPF-CNPJ Cedente");
            this.cpfCnpjCedente.setWidth("100%");
            if (this.itemDados.getCpfCnpjCedente() != null) {
                this.cpfCnpjCedente.setValue(this.itemDados.getCpfCnpjCedente());
            }
            this.telefoneCedente = new TextField("Telefone Cedente");
            this.telefoneCedente.setWidth("100%");
            if (this.itemDados.getTelefoneCedente() != null) {
                this.telefoneCedente.setValue(this.itemDados.getTelefoneCedente());
            }
            this.emailCedente = new TextField("E-mail Cedente");
            this.emailCedente.setWidth("100%");
            if (this.itemDados.getEmailCedente() != null) {
                this.emailCedente.setValue(this.itemDados.getEmailCedente());
            }
        }
        this.cbSolicitacao = new ComboBox("Solicita\u00e7\u00e3o", solicitacoes);
        this.cbSolicitacao.setItemLabelGenerator(PedidoItemSolicitacao::getNome);
        this.cbSolicitacao.setWidth("98%");
        this.cbCategoriaProduto = new ComboBox("Filtrar Categoria");
        this.cbProduto = new ComboBox("Produto");
        this.cbCategoriaProduto.setVisible(!this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.VIVO));
        this.cbCategoriaProduto.setItems(listaCategoria);
        this.cbCategoriaProduto.setWidth("98%");
        this.cbCategoriaProduto.setItemLabelGenerator(ProdutoCategoria::getNome);
        this.cbCategoriaProduto.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.cbCategoriaProduto.getValue() == null) {
                this.cbProduto.setItems(new ArrayList());
                this.cbProduto.setItems((Collection)this.produtoService.getProdutosByOrigem(this.getEstrutura(), this.po));
            } else {
                this.cbProduto.setItems((Collection)this.produtoService.getProdutosByOrigemAndCategoria(this.getEstrutura(), this.po, (ProdutoCategoria)this.cbCategoriaProduto.getValue()));
            }
        });
        this.cbProduto.setItemLabelGenerator(Produto::getNomeAndValor);
        this.cbProduto.setWidth("98%");
        this.cbProduto.setItems(produtos);
        this.infItem = new TextArea("Informa\u00e7\u00f5es Item");
        this.infItem.setHeight("200px");
        this.infItem.setWidth("98%");
        if (this.pi.getComplementos() != null) {
            this.infItem.setValue(this.pi.getComplementos());
        }
        this.quantidade = new NumberField(this.isTicket() ? "Colaboradores" : "Quantidade");
        this.quantidade.setWidthFull();
        if (this.isPolo()) {
            this.quantidade.setValue((Number)1.0);
        }
        if (this.pi.getQuantidade() != null) {
            this.quantidade.setValue((Number)this.pi.getQuantidade().doubleValue());
        }
        this.valor = new NumberField(this.isTicket() ? "Valor Dia" : "Valor Unit\u00e1rio");
        this.valor.setWidthFull();
        this.valorAgregado = new NumberField("Valor Agregado");
        this.valorAgregado.setWidthFull();
        this.valorBaseAtual = new NumberField("Valor Base Atual");
        this.valorBaseAtual.setWidthFull();
        this.variacaoRenovacaoClaro = new TextField("Varia\u00e7\u00e3o %");
        this.variacaoRenovacaoClaro.setReadOnly(true);
        if (this.isClaro()) {
            this.valorBaseAtual.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.calculaVariacao((Double)this.valor.getValue(), (Double)this.valorBaseAtual.getValue(), (Double)this.valorAgregado.getValue()));
            this.valor.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.calculaVariacao((Double)this.valor.getValue(), (Double)this.valorBaseAtual.getValue(), (Double)this.valorAgregado.getValue()));
            this.valorAgregado.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.calculaVariacao((Double)this.valor.getValue(), (Double)this.valorBaseAtual.getValue(), (Double)this.valorAgregado.getValue()));
        }
        this.showVariacaoClaro(this.pi.getPedidoItemSolicitacao());
        this.cbSolicitacao.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.showVariacaoClaro((PedidoItemSolicitacao)this.cbSolicitacao.getValue()));
        if (this.pi.getPedidoItemSolicitacao() != null) {
            this.cbSolicitacao.setValue((Object)this.pi.getPedidoItemSolicitacao());
        }
        if (this.pi.getValorBaseAtual() != null) {
            this.valorBaseAtual.setValue((Number)this.pi.getValorBaseAtual().doubleValue());
        }
        if (this.pi.getValorAgregado() != null) {
            this.valorAgregado.setValue((Number)this.pi.getValorAgregado().doubleValue());
        }
        this.desconto = new NumberField(this.isTicket() ? "Desagio%" : "Desconto");
        this.desconto.setVisible(!this.isTim());
        this.desconto.setWidthFull();
        if (this.pi.getDescontoPorItem() != null) {
            this.desconto.setValue((Number)this.pi.getDescontoPorItem().doubleValue());
        }
        this.numero = new TextField(this.isTicket() ? "Dias" : "Numero");
        this.numero.setWidthFull();
        this.numero.setMaxLength(20);
        if (this.pi.getNumero() != null) {
            this.numero.setValue(this.pi.getNumero());
        }
        this.numeroProvisorio = new TextField(this.isTicket() ? "Dias" : "Nro Provis\u00f3rio");
        this.numeroProvisorio.setWidthFull();
        this.numeroProvisorio.setMaxLength(20);
        if (this.pi.getNumeroProvisorio() != null) {
            this.numeroProvisorio.setValue(this.pi.getNumeroProvisorio());
        }
        Button btnMultNumbers = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ELLIPSIS_DOTS_V, (String)"Lan\u00e7ar v\u00e1rios n\u00fameros");
        btnMultNumbers.setVisible(this.pi.getId() == null);
        btnMultNumbers.addClickListener((ComponentEventListener & Serializable)e -> this.addMultiple());
        this.dataInstalacao = new DatePicker();
        this.dataInstalacao.setWidthFull();
        this.dataInstalacao.setLabel("Data Instala\u00e7\u00e3o");
        this.dataInstalacao.setLocale(UIUtils.getLocale());
        if (this.pi.getDataInstalacao() != null) {
            this.dataInstalacao.setValue(this.pi.getDataInstalacao());
        }
        this.cbPeriodo = new ComboBox("Per\u00edodo", (Object[])PeriodoEnum.values());
        this.cbPeriodo.setWidthFull();
        this.cbPeriodo.setItemLabelGenerator(Enum::name);
        if (this.pi.getPeriodo() != null) {
            this.cbPeriodo.setValue((Object)this.pi.getPeriodo());
        }
        this.dataPortabilidade = new DatePicker();
        this.dataPortabilidade.setWidthFull();
        this.dataPortabilidade.setLabel("Data Portabilidade");
        this.dataPortabilidade.setLocale(UIUtils.getLocale());
        if (this.pi.getDataPortabilidade() != null) {
            this.dataPortabilidade.setValue(this.pi.getDataPortabilidade());
        }
        this.rpon = new TextField("RPON");
        this.rpon.setWidthFull();
        if (this.pi.getRpon() != null) {
            this.rpon.setValue(this.pi.getRpon());
        }
        this.instancia = new TextField("Instancia");
        this.instancia.setWidthFull();
        if (this.pi.getInstancia() != null) {
            this.instancia.setValue(this.pi.getInstancia());
        }
        this.cbProduto.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() == null) {
                soma.clear();
                this.valor.clear();
                this.desconto.clear();
                return;
            }
            soma.setValue(((Produto)e.getValue()).getCompromissoMensal() != null && ((Produto)e.getValue()).getCompromissoMensal() != false ? "SIM" : "N\u00c3O");
            if (this.pi.getValorUnitario() == null) {
                this.valor.setValue(((Produto)e.getValue()).getValor() == null ? null : Double.valueOf(((Produto)e.getValue()).getValor().doubleValue()));
            } else {
                this.valor.setValue((Number)this.pi.getValorUnitario().doubleValue());
            }
            if (this.desconto.getValue() == null || (Double)this.desconto.getValue() <= 0.0) {
                this.desconto.setValue(((Produto)e.getValue()).getDescontoPrateleira() == null ? null : Double.valueOf(((Produto)e.getValue()).getDescontoPrateleira().doubleValue()));
            }
        });
        if (this.pi.getProduto() != null) {
            this.cbProduto.setValue((Object)this.pi.getProduto());
        }
        VerticalContainer box1 = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        box1.setWidth("57%");
        box1.setHeightFull();
        box1.setAlignItems(FlexComponent.Alignment.START);
        box1.add(new com.vaadin.flow.component.Component[]{this.cbSolicitacao, this.cbCategoriaProduto, this.cbProduto, this.infItem});
        if (this.isTelefonia() || this.isProvedor()) {
            this.enderecoView = new EnderecoView(this.cepService, this.pi.getEndereco(), EnderecoTipoEnum.INSTALACAO, "Endere\u00e7o de Instala\u00e7\u00e3o");
            box1.add(new com.vaadin.flow.component.Component[]{this.enderecoView});
        }
        FlexBoxLayout box2 = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new com.vaadin.flow.component.Component[0]);
        box2.setWidth("37%");
        box2.setHeightFull();
        box2.setAlignItems(FlexComponent.Alignment.CENTER);
        UIUtils.setShadow((Shadow)Shadow.XS, (com.vaadin.flow.component.Component[])new com.vaadin.flow.component.Component[]{box1, box2});
        if (this.isTelefonia()) {
            HorizontalContainer hn = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.numero, btnMultNumbers});
            hn.setWidthFull();
            hn.setNoWrap();
            hn.setAlignItems(FlexComponent.Alignment.END);
            if (this.isPolo()) {
                box2.add(new com.vaadin.flow.component.Component[]{soma, this.valor, this.desconto});
            } else if (this.isClaro()) {
                HorizontalContainer descontoContainer = new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.desconto, this.variacaoRenovacaoClaro}).setNoWrap();
                descontoContainer.setWidth("100%");
                this.desconto.setWidth("49%");
                this.variacaoRenovacaoClaro.setWidth("49%");
                box2.add(new com.vaadin.flow.component.Component[]{soma, this.quantidade, this.valor, this.valorAgregado, this.valorBaseAtual, descontoContainer});
            } else {
                box2.add(new com.vaadin.flow.component.Component[]{soma, this.quantidade, this.valor, this.desconto});
            }
            box2.add(new com.vaadin.flow.component.Component[]{hn, this.dataPortabilidade, this.numeroProvisorio, this.operadoraCedente, this.nomeCedente, this.cpfCnpjCedente, this.telefoneCedente, this.emailCedente, this.dataInstalacao, this.cbPeriodo});
            if (this.isVivo()) {
                box2.add(new com.vaadin.flow.component.Component[]{this.rpon, this.instancia});
            }
            btnConf.addClickListener((ComponentEventListener & Serializable)e -> {
                if (this.isTelefonia()) {
                    this.cpfCnpjCedente.setValue(StringUtil.numbersOnly((String)this.cpfCnpjCedente.getValue()));
                    this.telefoneCedente.setValue(StringUtil.numbersOnly((String)this.telefoneCedente.getValue()));
                }
                if (this.cbSolicitacao.getValue() == null || this.cbProduto.getValue() == null || ((Produto)this.cbProduto.getValue()).getSomaQuantidade().booleanValue() && (this.quantidade.getValue() == null || (Double)this.quantidade.getValue() <= 0.0)) {
                    UIUtils.showNotification((String)"Precisa informar pelo menos, solicita\u00e7\u00e3o, produto e quantidade");
                    return;
                }
                if (this.quantidade.getValue() != null && ((Double)this.quantidade.getValue()).toString().length() > 6) {
                    UIUtils.showNotification((String)"Quantidade n\u00e3o pode ser maior que 999.999");
                    return;
                }
                if (this.quantidade.getValue() != null && (Double)this.quantidade.getValue() < 0.0) {
                    UIUtils.showNotification((String)"Quantidade n\u00e3o pode ser menor a zero");
                    return;
                }
                if ((this.isTelefonia() || this.isProvedor()) && this.enderecoView.getValue().getCep() != null && !this.enderecoView.getValue().getCep().isEmpty() && !this.enderecoView.getErros().isEmpty()) {
                    UIUtils.showNotification((String)this.enderecoView.getErros());
                    return;
                }
                if (this.isTelefonia() && this.cpfCnpjCedente.getValue() != null && !this.cpfCnpjCedente.getValue().isEmpty() && !ValidationUtil.isValidCnpjAndCpf((String)this.cpfCnpjCedente.getValue())) {
                    UIUtils.showNotification((String)"CPF-CNPJ Cedente inv\u00e1lido");
                    return;
                }
                if (this.isTelefonia() && this.telefoneCedente.getValue() != null && !this.telefoneCedente.getValue().isEmpty() && !TelefoneUtil.isValid((String)this.telefoneCedente.getValue())) {
                    UIUtils.showNotification((String)"Telefone Cedente inv\u00e1lido");
                    return;
                }
                if (this.isTelefonia() && this.emailCedente.getValue() != null && !this.emailCedente.getValue().isEmpty() && !ValidationUtil.isValidEmail((String)this.emailCedente.getValue())) {
                    UIUtils.showNotification((String)"E-mail Cedente inv\u00e1lido");
                    return;
                }
                this.salvar();
                UIUtils.showNotification((String)"Item Salvo com sucesso");
                this.close();
            });
            btnItemClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
            HorizontalContainer boxContainer = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
            boxContainer.add(new com.vaadin.flow.component.Component[]{box1, box2});
            boxContainer.setNoWrap();
            this.add(new com.vaadin.flow.component.Component[]{boxContainer, new FooterContainer(new com.vaadin.flow.component.Component[]{btnItemClose, btnConf})});
            this.open();
        }
    }

    private void addMultiple() {
        if (this.cbSolicitacao.getValue() == null || this.cbProduto.getValue() == null) {
            UIUtils.showNotification((String)"Precisa informar pelo menos, solicita\u00e7\u00e3o e produto ");
            return;
        }
        if (this.quantidade.getValue() != null && ((Double)this.quantidade.getValue()).toString().length() > 6) {
            UIUtils.showNotification((String)"Quantidade n\u00e3o pode ser maior que 999.999");
            return;
        }
        Dialog d = new Dialog();
        TextArea ta = new TextArea("N\u00fameros");
        ta.setWidthFull();
        ta.setHeight("150px");
        Button bc = UIUtils.createSmallButton((String)"Fechar");
        bc.addClickListener((ComponentEventListener & Serializable)bf -> d.close());
        Button b = UIUtils.createSmallButton((String)"Confirmar");
        b.addClickListener((ComponentEventListener & Serializable)bx -> {
            if (ta.getValue() == null) {
                UIUtils.showNotification((String)"Informe n\u00fameros para criar os itens");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Criar multiplas linhas", "Confirma a cria\u00e7\u00e3o de v\u00e1rios itens a partir desses n\u00fameros?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.createMultiples(ta.getValue());
                cd.close();
                d.close();
                this.close();
            });
        });
        d.add(new com.vaadin.flow.component.Component[]{ta, new FooterContainer(new com.vaadin.flow.component.Component[]{bc, b})});
        d.open();
    }

    private void createMultiples(String numbers) {
        for (String s : numbers.split("\n")) {
            if (!TelefoneUtil.isValid((String)(s = StringUtil.numbersOnly((String)s)))) continue;
            this.salvar(s);
        }
    }

    private void salvar() {
        this.salvar("");
    }

    private void salvar(String number) {
        if (number != null && !number.isEmpty()) {
            this.pi = new PedidoItem();
            this.itemDados = new PedidoItemDados();
        }
        this.pi.setEstrutura(this.getEstrutura());
        this.pi.setPedido(this.pedido);
        this.pi.setComplementos(this.infItem.getValue());
        this.pi.setConsiderarProducao(Boolean.TRUE);
        this.pi.setDataReferencia(LocalDate.now());
        this.pi.setDdd(Integer.valueOf(0));
        if (this.desconto.getValue() != null) {
            this.pi.setDescontoPorItem(new BigDecimal((Double)this.desconto.getValue()));
        } else {
            this.pi.setDescontoPorItem(BigDecimal.ZERO);
        }
        this.pi.setNumero(number == null || number.isEmpty() ? this.numero.getValue() : number);
        this.pi.setNumeroProvisorio(this.numeroProvisorio.getValue() == null ? null : this.numeroProvisorio.getValue());
        this.pi.setPedidoItemEtapa(this.pedidoItemEtapaService.getEtapaInicial(this.getEstrutura(), this.pedido.getPedidoOrigem()));
        this.pi.setPedidoItemSolicitacao((PedidoItemSolicitacao)this.cbSolicitacao.getValue());
        this.pi.setProduto((Produto)this.cbProduto.getValue());
        this.pi.setQuantidade(Integer.valueOf(this.pi.getNumero() != null && !this.pi.getNumero().isEmpty() ? 1 : (this.quantidade.getValue() == null ? 0 : ((Double)this.quantidade.getValue()).intValue())));
        this.pi.setValorUnitario(this.valor.getValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)this.valor.getValue()));
        this.pi.setDataInstalacao((LocalDate)this.dataInstalacao.getValue());
        this.pi.setDataPortabilidade((LocalDate)this.dataPortabilidade.getValue());
        this.pi.setValorBaseAtual(this.valorBaseAtual.getValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)this.valorBaseAtual.getValue()));
        this.pi.setValorAgregado(this.valorAgregado.getValue() == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)this.valorAgregado.getValue()));
        if (this.isTelefonia() && this.enderecoView.getValue().getCep() != null && !this.enderecoView.getValue().getCep().isEmpty()) {
            this.pi.setEndereco(this.enderecoService.gravar(this.enderecoView.getValue()));
        } else {
            this.pi.setEndereco(null);
        }
        this.pi.setInstancia(this.instancia.getValue());
        this.pi.setRpon(this.rpon.getValue());
        this.pi.setPeriodo((PeriodoEnum)this.cbPeriodo.getValue());
        this.pi = this.pedidoItemService.salvar(this.pi, this.getEu());
        if (this.isTelefonia()) {
            this.itemDados.setCpfCnpjCedente(this.cpfCnpjCedente.getValue());
            this.itemDados.setEmailCedente(this.emailCedente.getValue());
            this.itemDados.setNomeCedente(this.nomeCedente.getValue());
            this.itemDados.setOperadoraCedente(this.operadoraCedente.getValue());
            this.itemDados.setPedidoItem(this.pi);
            this.itemDados.setTelefoneCedente(this.telefoneCedente.getValue());
            this.dadosService.save(this.itemDados);
        }
    }

    private void calculaVariacao(Double valor, Double valorbase, Double valorAgregado) {
        Double variacao = CalculoVariacaoRenovacao.calcular((Double)valor, (Double)valorbase, (Double)valorAgregado, (EstruturaComplemento)this.eComp);
        if (variacao == null) {
            this.variacaoRenovacaoClaro.setValue("");
        } else {
            this.variacaoRenovacaoClaro.setValue(CurrencyUtil.toCurrency((BigDecimal)BigDecimal.valueOf(variacao)));
        }
    }

    private void showVariacaoClaro(PedidoItemSolicitacao value) {
        if (value == null || !value.getNome().toUpperCase().contains("RENOVA") && !value.getNome().toUpperCase().contains("MIGRA")) {
            this.variacaoRenovacaoClaro.setVisible(false);
            this.valorBaseAtual.setVisible(false);
            this.valorAgregado.setVisible(false);
            this.variacaoRenovacaoClaro.setValue("");
            this.valorBaseAtual.setValue((Number)0.0);
            this.valorAgregado.setValue((Number)0.0);
        } else {
            this.variacaoRenovacaoClaro.setVisible(true);
            this.valorBaseAtual.setVisible(true);
            this.valorAgregado.setVisible(true);
        }
    }
}

