/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoNotificacao;
import br.com.system.app.features.pedido.model.PedidoNotificacaoEnum;
import br.com.system.app.features.pedido.model.PedidoNotificacaoQuem;
import br.com.system.app.features.pedido.service.PedidoNotificacaoService;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public class AtividadeNotificationView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final PedidoNotificacaoService pedidoNotificacaoService;
    private final Pedido pedido;
    private final EstruturaUsuario eu;
    private List<PedidoNotificacao> notificacoes;

    public AtividadeNotificationView(PedidoNotificacaoService pedidoNotificacaoService, Pedido pedido, EstruturaUsuario eu) {
        this.pedidoNotificacaoService = pedidoNotificacaoService;
        this.pedido = pedido;
        this.eu = eu;
    }

    public void openNotification() {
        this.notificacoes = this.pedidoNotificacaoService.getByPedido(this.pedido);
        VerticalContainer cv = new VerticalContainer(new Component[0]);
        Button bAdd = UIUtils.createSmallButton((String)"Adicionar Notifica\u00e7\u00e3o", (VaadinIcon)VaadinIcon.PLUS);
        bAdd.addClickListener((ComponentEventListener & Serializable)e -> cv.add(new Component[]{this.getItemNotification(new PedidoNotificacao(), 0)}));
        Button bGA = UIUtils.createSmallButton((String)"Abrir Agenda", (VaadinIcon)VaadinIcon.CALENDAR);
        bGA.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().executeJs("window.open('https://calendar.google.com/calendar/u/0/r','NeoGAWindow','width=1000,height=768')", new Serializable[0]));
        for (int i = 0; i < this.notificacoes.size(); ++i) {
            cv.add(new Component[]{this.getItemNotification((PedidoNotificacao)this.notificacoes.get(i), i)});
        }
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnSaveNot = UIUtils.createSmallButton((String)"Salvar", (VaadinIcon)VaadinIcon.INBOX);
        btnSaveNot.addClickListener((ComponentEventListener & Serializable)e -> {
            boolean erros = false;
            for (PedidoNotificacao pn : this.notificacoes) {
                if (pn.getData() != null && pn.getHora() != null && pn.getEstruturaUsuario() != null && pn.getPedido() != null && pn.getTipo() != null) continue;
                erros = true;
                break;
            }
            if (!erros) {
                this.pedidoNotificacaoService.saveAll(this.notificacoes);
                this.close();
            } else {
                UIUtils.showNotification((String)"H\u00e1 erros na notifica\u00e7\u00e3o, informe todos os campos");
            }
        });
        this.add(new Component[]{UIUtils.createHeader((String)"Notifica\u00e7\u00f5es da atividade(Agenda)"), new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{bAdd, bGA}), cv, new FooterContainer(new Component[]{btnClose, btnSaveNot})})});
        this.open();
    }

    private HorizontalContainer getItemNotification(PedidoNotificacao pn, int i) {
        if (pn.getPedido() == null) {
            pn.setPedido(this.pedido);
            pn.setEstruturaUsuario(this.eu);
            pn.setNotificada(Boolean.valueOf(false));
            this.notificacoes.add(pn);
        }
        ComboBox cbTipo = new ComboBox("Tipo de Aviso");
        cbTipo.setItems((Object[])new PedidoNotificacaoEnum[]{PedidoNotificacaoEnum.EMAIL, PedidoNotificacaoEnum.NOTIFICACAO});
        if (pn.getTipo() != null) {
            cbTipo.setValue((Object)pn.getTipo());
        } else {
            cbTipo.setValue((Object)PedidoNotificacaoEnum.EMAIL);
            pn.setTipo(PedidoNotificacaoEnum.EMAIL);
        }
        cbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            pn.setTipo((PedidoNotificacaoEnum)e.getValue());
            this.changePn(pn);
        });
        TextField obs = new TextField("Observa\u00e7\u00e3o");
        if (pn.getObservacao() != null) {
            obs.setValue(pn.getObservacao());
        }
        obs.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            pn.setObservacao(obs.getValue());
            this.changePn(pn);
        });
        DatePicker data = new DatePicker();
        data.setLocale(UIUtils.getLocale());
        data.setWidth("130px");
        data.setLabel("Data" + i);
        if (pn.getData() != null) {
            data.setValue(pn.getData());
        } else {
            data.setValue(LocalDate.now());
            pn.setData(LocalDate.now());
        }
        data.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            pn.setData((LocalDate)data.getValue());
            this.changePn(pn);
        });
        TimePicker timePicker = new TimePicker();
        timePicker.setLocale(UIUtils.getLocale());
        timePicker.setWidth("100px");
        timePicker.setLabel("Hora");
        timePicker.setMin(LocalTime.parse("07:00"));
        timePicker.setStep(Duration.ofMinutes(30L));
        timePicker.setMax(LocalTime.parse("20:00"));
        if (pn.getHora() != null) {
            timePicker.setValue(pn.getHora());
        } else {
            timePicker.setValue(LocalTime.now());
            pn.setHora(LocalTime.now());
        }
        timePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            pn.setHora((LocalTime)timePicker.getValue());
            this.changePn(pn);
        });
        HorizontalContainer h = new HorizontalContainer(new Component[0]);
        Button bTrash = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir notifica\u00e7\u00e3o");
        bTrash.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Excluir", "Confirma exclus\u00e3o?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.notificacoes.remove(pn);
                if (pn.getId() != null) {
                    this.pedidoNotificacaoService.delete(pn);
                }
                ((Button)e.getSource()).getElement().getParent().getParent().removeChild(new Element[]{h.getElement()});
                cd.close();
            });
        });
        Button btnGa = UIUtils.createSmallButton((String)"Google Agenda");
        btnGa.addClickListener((ComponentEventListener & Serializable)e -> {
            String datas = this.getGAdate((LocalDate)data.getValue()) + "T" + this.getGATime((LocalTime)timePicker.getValue()) + "/" + this.getGAdate((LocalDate)data.getValue()) + "T" + this.getGATime(((LocalTime)timePicker.getValue()).plusHours(1L));
            String detais = this.pedidoNotificacaoService.getMsgGA(pn) + "<BR>" + obs.getValue();
            Cliente c = pn.getPedido().getCliente();
            String location = c.getLogradouro() + ", " + c.getNumero() + " " + c.getCidade() + " " + c.getEstado();
            String add = pn.getEstruturaUsuario().getUsuario().getEmail();
            String title = "Atividade " + pn.getPedido().getNumero();
            String link = "https://calendar.google.com/calendar/u/0/r/eventedit?text=" + title + "&dates=" + datas + "&location=" + location + "&add=" + add + "&details=" + detais;
            UI.getCurrent().getPage().executeJs("window.open('" + link + "','NeoGAWindow','width=1000,height=768')", new Serializable[0]);
        });
        h.add(new Component[]{bTrash, cbTipo, data, timePicker});
        if (pn.getId() != null) {
            TextField tf = new TextField("Usu\u00e1rio criou");
            tf.setValue(pn.getEstruturaUsuario().getUsuario().getLogin());
            tf.setReadOnly(true);
            h.add(new Component[]{tf});
        }
        RadioButtonGroup quem = new RadioButtonGroup("Notificar Quem");
        quem.setItems((Object[])PedidoNotificacaoQuem.values());
        quem.setItemLabelGenerator(Enum::name);
        quem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((PedidoNotificacaoQuem)quem.getValue()).equals((Object)PedidoNotificacaoQuem.ME_NOTIFICAR) && pn.getEstruturaUsuario().getId().equals(pn.getPedido().getEstruturaUsuario().getId())) {
                UIUtils.showNotification((String)"Voc\u00ea \u00e9 o propriet\u00e1rio do pedido");
                pn.setQuem(PedidoNotificacaoQuem.PROPRIETARIO_PEDIDO);
                quem.setValue((Object)PedidoNotificacaoQuem.PROPRIETARIO_PEDIDO);
            } else {
                pn.setQuem((PedidoNotificacaoQuem)quem.getValue());
            }
        });
        if (pn.getQuem() != null) {
            quem.setValue((Object)pn.getQuem());
        } else {
            quem.setValue((Object)PedidoNotificacaoQuem.PROPRIETARIO_PEDIDO);
        }
        h.add(new Component[]{quem, obs, btnGa});
        return h;
    }

    private String getGAdate(LocalDate data) {
        return data.format(FormatDate.US_DATE.toDTF()).replace("-", "");
    }

    private String getGATime(LocalTime hora) {
        return hora.format(FormatDate.US_TIME.toDTF()).replace(":", "");
    }

    private void changePn(PedidoNotificacao pn) {
        for (int i = 0; i < this.notificacoes.size(); ++i) {
            if (!((PedidoNotificacao)this.notificacoes.get(i)).equals(pn)) continue;
            this.notificacoes.remove(i);
            break;
        }
        this.notificacoes.add(pn);
    }
}

