/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view.atividade;

import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.pedido.dto.PedidoSlaENUM;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.dto.TagOptionEnum;
import br.com.system.app.features.pedido.model.PedidoCategoria;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoEtapaGrupo;
import br.com.system.app.features.pedido.model.PedidoEtapaGrupoItem;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.model.PedidoSubCategoria;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoCategoriaService;
import br.com.system.app.features.pedido.service.PedidoEtapaGrupoService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoSubCategoriaService;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.producaopainel.dto.ProducaoFilterEtapaEnum;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.shared.model.CnpjCpfEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PainelAtividadeFilter
extends VerticalContainer
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoOrigemService pos;
    private final PedidoEtapaService pedidoEtapaService;
    private final PedidoTagsService pedidoTagsService;
    private final EstruturaSenhasService ess;
    private final EstruturaUsuario eu;
    private final Set<Long> hierarquia;
    private final EquipeService equipeService;
    private final UsuarioTagService usuarioTagService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final UsuarioService usuarioService;
    private final PedidoEtapaGrupoService pegs;
    private final PedidoCategoriaService pedidoCategoriaService;
    private final PedidoSubCategoriaService pedidoSubCategoriaService;
    private final EstruturaComplementoService estruturaComplementoService;
    private ComboBox<PedidoOrigem> cbOrigem;
    private ComboBox<PedidoCategoria> cbCategoria;
    private ComboBox<PedidoSubCategoria> cbSubCategoria;
    private TextField filterCliente;
    private ListField filterNumero;
    private ListField filterNumeroVinculado;
    private ListField filterNumeroSimulacao;
    private ListField filterNumeroCotacao;
    private ListField filterCnpj;
    private MultiComboBox<PedidoEtapa> cbPedidoEtapa;
    private MultiComboBox<PedidoTags> cbTags;
    private MultiComboBox<UsuarioTag> cbUsuarioTags;
    private MultiComboBox<EstruturaSenhas> cbSenhas;
    private DatePicker dataInicialCadastro;
    private DatePicker dataFinalCadastro;
    private DatePicker dataInicialAtualizacao;
    private DatePicker dataFinalAtualizacao;
    private Checkbox cbNaoVinculado;
    private Button btnPesquisar;
    private Button btnInserir;
    private ComboBox<HierarquiaDTO> cbHierarquia;
    private Checkbox cbConsideraData;
    private RadioButtonGroup<PedidoTipoEnum> rbTipo;
    private MultiComboBox<Equipe> cbEquipe;
    private DatePicker dataNotificacao;
    private Checkbox cbNotificacao;
    private Button fireGreenFilter;
    private Button fireRedFilter;
    private ComboBox<ProducaoFilterEtapaEnum> cbEtapaFilter;
    private ComboBox<TagOptionEnum> cbTagOption;
    private PedidoSlaENUM sla;
    private EstruturaComplemento compl;
    private ComboBox<PedidoEtapaGrupo> cbGrupoEtapa;
    private ComboBox<CnpjCpfEnum> cbCpfCnpj;

    public RadioButtonGroup<PedidoTipoEnum> getRbTipo() {
        return this.rbTipo;
    }

    public ComboBox<HierarquiaDTO> getCbHierarquia() {
        return this.cbHierarquia;
    }

    public PainelAtividadeFilter(Set<Long> hierarquia, PedidoOrigemService pos, PedidoEtapaService pedidoEtapaService, PedidoTagsService pedidoTagsService, EstruturaUsuario eu, EstruturaSenhasService ess, EquipeService equipeService, UsuarioTagService usuariotagService, UsuarioHierarquiaService hierarquiaService, UsuarioService usuarioService, PedidoEtapaGrupoService pegs, PedidoCategoriaService pedidoCategoriaService, PedidoSubCategoriaService pedidoSubCategoriaService, EstruturaComplementoService estruturaComplementoService) {
        super(new Component[0]);
        this.pos = pos;
        this.estruturaComplementoService = estruturaComplementoService;
        this.pedidoCategoriaService = pedidoCategoriaService;
        this.pedidoSubCategoriaService = pedidoSubCategoriaService;
        this.pegs = pegs;
        this.usuarioService = usuarioService;
        this.hierarquiaService = hierarquiaService;
        this.equipeService = equipeService;
        this.pedidoEtapaService = pedidoEtapaService;
        this.pedidoTagsService = pedidoTagsService;
        this.eu = eu;
        this.hierarquia = hierarquia;
        this.ess = ess;
        this.usuarioTagService = usuariotagService;
        this.create();
    }

    private void povoaEtapa(PedidoTipoEnum pte, PedidoOrigem origem) {
        this.cbPedidoEtapa.setItems((Collection)this.pedidoEtapaService.getAtivos(this.eu.getEstrutura(), pte, origem));
    }

    private void povoaTags(PedidoTipoEnum pte) {
        this.cbTags.setItems((Collection)this.pedidoTagsService.getTags(this.eu.getEstrutura(), pte));
    }

    public Button getFireGreen() {
        return this.fireGreenFilter;
    }

    public Button getFireRed() {
        return this.fireRedFilter;
    }

    private void create() {
        this.compl = this.estruturaComplementoService.getComplementos(this.getEstrutura());
        Icon greenIcon = new Icon(VaadinIcon.FIRE);
        greenIcon.setColor(Color.GREEN.getValue());
        Icon redIcon = new Icon(VaadinIcon.FIRE);
        redIcon.setColor(Color.RED.getValue());
        this.setSpacing(true);
        this.fireGreenFilter = UIUtils.createButton((Icon)greenIcon, (String)"Filtrar atividades NO PRAZO", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.fireGreenFilter.setId("btnFiltrarNoPrazo");
        this.fireRedFilter = UIUtils.createButton((Icon)redIcon, (String)"Filtrar atividades FORA DO PRAZO", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.fireRedFilter.setId("btnFiltrarForaPrazo");
        this.fireRedFilter.setDisableOnClick(true);
        this.fireGreenFilter.setVisible(true);
        this.fireGreenFilter.setDisableOnClick(true);
        this.fireRedFilter.setVisible(true);
        this.cbCpfCnpj = new ComboBox("CNPJ-CPF");
        this.cbCpfCnpj.setItems((Object[])CnpjCpfEnum.values());
        this.cbCpfCnpj.setItemLabelGenerator(Enum::name);
        this.cbCpfCnpj.setClearButtonVisible(true);
        this.cbCpfCnpj.setValue(null);
        this.rbTipo = new RadioButtonGroup();
        this.rbTipo.setId("rbTipo");
        if (this.isWhatsapp()) {
            this.rbTipo.setItems((Object[])new PedidoTipoEnum[]{PedidoTipoEnum.WHATSAPP});
        } else {
            this.rbTipo.setItems((Object[])PedidoTipoEnum.values());
        }
        this.rbTipo.setValue((Object)(this.getUsuario().getTipoPedidoDefault() == null ? PedidoTipoEnum.COMERCIAL : this.getUsuario().getTipoPedidoDefault()));
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{this.rbTipo});
        this.rbTipo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.povoaEtapa((PedidoTipoEnum)e.getValue(), (PedidoOrigem)this.cbOrigem.getValue());
            this.povoaTags((PedidoTipoEnum)e.getValue());
            this.usuarioService.setTipoPedidoDefault(this.getUsuario(), (PedidoTipoEnum)e.getValue());
            this.getUsuario().setTipoPedidoDefault((PedidoTipoEnum)e.getValue());
        });
        this.cbPedidoEtapa = new MultiComboBox("Etapa");
        this.cbPedidoEtapa.setId("cbPedidoEtapa");
        this.cbPedidoEtapa.setMinWidth("200px");
        this.cbPedidoEtapa.setItemLabelGenerator(PedidoEtapa::getNomeAndOrigem);
        this.cbPedidoEtapa.setPlaceholder("Escolha uma Origem");
        this.cbGrupoEtapa = new ComboBox("Grupo Etapa", (Collection)this.pegs.getByEstrutura(this.getEstrutura()));
        this.cbGrupoEtapa.setItemLabelGenerator(PedidoEtapaGrupo::getNome);
        this.cbGrupoEtapa.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() == null) {
                this.cbPedidoEtapa.clear();
                return;
            }
            if (((PedidoEtapaGrupo)e.getValue()).getItens().size() <= 0) {
                UIUtils.showNotification((String)"Erro no cadastro desse grupo");
                return;
            }
            HashSet<PedidoEtapa> etapas = new HashSet<PedidoEtapa>();
            for (PedidoEtapaGrupoItem pi : ((PedidoEtapaGrupo)e.getValue()).getItens()) {
                etapas.add(pi.getPedidoEtapa());
            }
            this.cbPedidoEtapa.setValue(etapas);
        });
        this.cbEtapaFilter = new ComboBox("Entrou/Saiu", (Object[])ProducaoFilterEtapaEnum.values());
        this.cbEtapaFilter.setId("cbEtapaFilter");
        this.cbEtapaFilter.setItemLabelGenerator(Enum::name);
        this.cbEtapaFilter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.cbEtapaFilter.getValue() == null) {
                this.dataInicialAtualizacao.setLabel("Inicial Atualizacao");
                this.dataFinalAtualizacao.setLabel("Final Atualizacao");
            } else if (((ProducaoFilterEtapaEnum)this.cbEtapaFilter.getValue()).equals((Object)ProducaoFilterEtapaEnum.ENTROU)) {
                this.dataInicialAtualizacao.setLabel("Entrou Inicio");
                this.dataFinalAtualizacao.setLabel("Entrou Final");
            } else if (((ProducaoFilterEtapaEnum)this.cbEtapaFilter.getValue()).equals((Object)ProducaoFilterEtapaEnum.SAIU)) {
                this.dataInicialAtualizacao.setLabel("Saiu Inicio");
                this.dataFinalAtualizacao.setLabel("Saiu Final");
            }
        });
        this.cbOrigem = new ComboBox("Origem");
        this.cbOrigem.setId("cbOrigem");
        this.cbOrigem.setClearButtonVisible(true);
        this.cbOrigem.setItems((Collection)this.pos.getByEstruturaTipo(this.eu.getEstrutura().getEstruturaTipo()));
        this.cbOrigem.setItemLabelGenerator(PedidoOrigem::getNome);
        this.cbOrigem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoaEtapa((PedidoTipoEnum)this.rbTipo.getValue(), (PedidoOrigem)e.getValue()));
        this.cbOrigem.setValue((Object)this.pos.getOrigemAtividade(this.getEstrutura()));
        this.cbCategoria = new ComboBox(this.compl.getNomeCampoCategoria());
        this.cbCategoria.setItemLabelGenerator(PedidoCategoria::getNome);
        this.cbCategoria.setItems((Collection)this.pedidoCategoriaService.getByEstruturaAndAtivo(this.getEstrutura(), Boolean.TRUE));
        this.cbSubCategoria = new ComboBox(this.compl.getNomeCampoSubCategoria());
        this.cbSubCategoria.setItemLabelGenerator(PedidoSubCategoria::getNome);
        this.cbSubCategoria.setItems((Collection)this.pedidoSubCategoriaService.getByEstruturaAndAtivo(this.getEstrutura(), Boolean.TRUE));
        this.filterCliente = new TextField("Nome Cliente(Inicio)");
        this.filterCliente.setId("filterCliente");
        this.filterNumero = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Atividade");
        this.filterNumero.setId("filterNumero");
        this.filterNumeroVinculado = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Pedido Vinculado");
        this.filterNumeroVinculado.setId("filterNumeroVinculado");
        this.filterNumeroCotacao = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Cota\u00e7\u00e3o Vinculada");
        this.filterNumeroCotacao.setId("filterNumeroCotacao");
        this.filterNumeroSimulacao = new ListField(ListFieldTypeEnum.GENERIC_STRING, "Lista Simula\u00e7\u00e3o Vinculada");
        this.filterNumeroSimulacao.setId("filterNumeroSimulacao");
        this.filterCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "Lista Cnpj");
        this.filterCnpj.setId("filterCnpj");
        this.cbSenhas = new MultiComboBox("Login Operadora", (Collection)this.ess.getAtivosByEstrutura(this.getEstrutura()));
        this.cbSenhas.setId("cbSenhas");
        this.cbSenhas.setItemLabelGenerator(EstruturaSenhas::getNomeLoginSistema);
        this.cbSenhas.setVisible(this.isTelefonia());
        this.cbTags = new MultiComboBox("Tags Atividade");
        this.cbTags.setId("cbTags");
        this.cbTags.setItemLabelGenerator(PedidoTags::getTagAndCategoria);
        this.cbTagOption = new ComboBox("Op\u00e7\u00e3o");
        this.cbTagOption.setId("cbTagOption");
        this.cbTagOption.setWidth("80px");
        this.cbTagOption.setItemLabelGenerator(Enum::name);
        this.cbTagOption.setItems((Object[])TagOptionEnum.values());
        this.cbTagOption.setValue((Object)TagOptionEnum.OU);
        this.cbUsuarioTags = new MultiComboBox("Tags Usuario", (Collection)this.usuarioTagService.getTags(this.eu.getEstrutura()));
        this.cbUsuarioTags.setId("cbUsuarioTags");
        this.cbUsuarioTags.setItemLabelGenerator(UsuarioTag::getTag);
        this.povoaTags((PedidoTipoEnum)this.rbTipo.getValue());
        this.dataInicialCadastro = new DatePicker();
        this.dataInicialCadastro.setId("dataInicioCadastro");
        this.dataInicialCadastro.setLabel("Inicial Cadastro");
        this.dataInicialCadastro.setLocale(UIUtils.getLocale());
        this.dataInicialCadastro.setEnabled(false);
        this.dataFinalCadastro = new DatePicker();
        this.dataFinalCadastro.setId("dataFinalCadastro");
        this.dataFinalCadastro.setLabel("Final Cadastro");
        this.dataFinalCadastro.setLocale(UIUtils.getLocale());
        this.dataFinalCadastro.setEnabled(false);
        this.dataInicialAtualizacao = new DatePicker();
        this.dataInicialAtualizacao.setId("dataInicialAtualizacao");
        this.dataInicialAtualizacao.setLabel("Inicial Atualizacao");
        this.dataInicialAtualizacao.setValue(LocalDate.now().minusDays(7L));
        this.dataInicialAtualizacao.setLocale(UIUtils.getLocale());
        this.dataFinalAtualizacao = new DatePicker();
        this.dataFinalAtualizacao.setId("dataFinalAtualizacao");
        this.dataFinalAtualizacao.setLabel("Final Atualizacao");
        this.dataFinalAtualizacao.setValue(LocalDate.now());
        this.dataFinalAtualizacao.setLocale(UIUtils.getLocale());
        this.cbNaoVinculado = new Checkbox("N\u00e3o vinculados");
        this.cbNaoVinculado.setId("cbNaoVinculado");
        this.cbNaoVinculado.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                this.cbOrigem.setEnabled(false);
                this.cbOrigem.setValue((Object)this.pos.getOrigemAtividade(this.eu.getEstrutura()));
            } else {
                this.cbOrigem.setEnabled(true);
                this.cbOrigem.setValue(null);
            }
        });
        this.cbConsideraData = new Checkbox("Considerar Data");
        this.cbConsideraData.setId("cbConsiderarData");
        this.cbConsideraData.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                this.dataInicialCadastro.setEnabled(true);
                this.dataFinalCadastro.setEnabled(true);
                this.dataInicialAtualizacao.setEnabled(true);
                this.dataFinalAtualizacao.setEnabled(true);
            } else {
                this.dataInicialCadastro.setEnabled(false);
                this.dataFinalCadastro.setEnabled(false);
                this.dataInicialAtualizacao.setEnabled(false);
                this.dataFinalAtualizacao.setEnabled(false);
            }
        });
        this.cbConsideraData.setValue((Object)true);
        this.dataNotificacao = new DatePicker();
        this.dataNotificacao.setId("dataNotificacao");
        this.dataNotificacao.setEnabled(false);
        this.dataNotificacao.setLabel("Notifica\u00e7\u00e3o");
        this.dataNotificacao.setValue(LocalDate.now());
        this.dataNotificacao.setLocale(UIUtils.getLocale());
        this.dataNotificacao.setWidth("130px");
        this.cbNotificacao = new Checkbox();
        this.cbNotificacao.setId("cbNotificacao");
        this.cbNotificacao.getElement().setProperty("title", "Seleciona apenas atividades marcadas com a data selecionada");
        this.cbNotificacao.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                this.dataNotificacao.setEnabled(true);
                this.dataNotificacao.setValue(LocalDate.now());
            } else {
                this.dataNotificacao.setValue(null);
                this.dataNotificacao.setEnabled(false);
            }
        });
        this.cbHierarquia = new ComboBox("Hieraquia(Propriet\u00e1rio e/ou Adm)", (Collection)this.hierarquiaService.getHierarquiaDto(this.eu, "", Boolean.valueOf(false)));
        this.cbHierarquia.setId("cbHierarquia");
        this.cbHierarquia.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        this.cbHierarquia.setMinWidth("300px");
        this.cbEquipe = new MultiComboBox("Equipe");
        this.cbEquipe.setId("cbEquipe");
        if (this.hasPermission("EQUIPE_VISUALIZACAO_RESTRITA") && !this.isMaster()) {
            if (this.getEu().getEquipe() != null) {
                this.cbEquipe.setItems((Object[])new Equipe[]{this.getEu().getEquipe()});
            }
        } else {
            this.cbEquipe.setItems((Collection)this.equipeService.getEquipes(this.getEstrutura()));
        }
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH);
        this.btnPesquisar.setId("btnPesquisar");
        this.btnPesquisar.setDisableOnClick(true);
        this.btnInserir = UIUtils.createSmallButton((String)"Novo", (VaadinIcon)VaadinIcon.PLUS);
        this.btnInserir.setId("btnInserir");
        this.btnInserir.setDisableOnClick(true);
        Button btnClear = UIUtils.createSmallButton((String)"Limpar", (VaadinIcon)VaadinIcon.RECYCLE);
        btnClear.addClickListener((ComponentEventListener & Serializable)e -> this.clear());
        HorizontalContainer cvTag = new HorizontalContainer(new Component[0]);
        cvTag.setNoWrap();
        cvTag.add(new Component[]{this.cbTags, this.cbTagOption});
        UIUtils.setBorder((BorderStyle)BorderStyle.SOLID, (String)"1px", (Component[])new Component[]{cvTag});
        if (this.isVivo()) {
            this.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.cbCpfCnpj, this.filterCliente, this.filterNumero, this.filterCnpj, this.cbOrigem, this.cbCategoria, this.cbSubCategoria, this.cbGrupoEtapa, this.cbPedidoEtapa, this.cbEtapaFilter, cvTag, this.cbUsuarioTags, this.cbEquipe, this.cbHierarquia, this.cbSenhas, this.filterNumeroVinculado, this.filterNumeroCotacao, this.filterNumeroSimulacao, this.dataInicialCadastro, this.dataFinalCadastro, this.dataInicialAtualizacao, this.dataFinalAtualizacao, this.cbConsideraData, this.cbNaoVinculado, this.dataNotificacao, this.cbNotificacao, this.btnPesquisar, this.btnInserir, this.fireGreenFilter, this.fireRedFilter, btnClear}).setSpacingOn()});
        } else if (this.isTelefonia()) {
            this.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.cbCpfCnpj, this.filterCliente, this.filterNumero, this.filterCnpj, this.cbOrigem, this.cbCategoria, this.cbSubCategoria, this.cbGrupoEtapa, this.cbPedidoEtapa, this.cbEtapaFilter, cvTag, this.cbUsuarioTags, this.cbEquipe, this.cbHierarquia, this.cbSenhas, this.filterNumeroVinculado, this.dataInicialCadastro, this.dataFinalCadastro, this.dataInicialAtualizacao, this.dataFinalAtualizacao, this.cbConsideraData, this.cbNaoVinculado, this.dataNotificacao, this.cbNotificacao, this.btnPesquisar, this.btnInserir, this.fireGreenFilter, this.fireRedFilter, btnClear}).setSpacingOn()});
        } else {
            this.add(new Component[]{new HorizontalContainer(new Component[]{this.rbTipo, this.cbCpfCnpj, this.filterCliente, this.filterNumero, this.filterCnpj, this.cbOrigem, this.cbCategoria, this.cbSubCategoria, this.cbPedidoEtapa, this.cbEtapaFilter, cvTag, this.cbUsuarioTags, this.cbEquipe, this.cbHierarquia, this.dataInicialCadastro, this.dataFinalCadastro, this.dataInicialAtualizacao, this.dataFinalAtualizacao, this.cbConsideraData, this.dataNotificacao, this.cbNotificacao, this.btnPesquisar, this.btnInserir, this.fireGreenFilter, this.fireRedFilter, btnClear}).setSpacingOn()});
        }
    }

    private Set<Long> getHierarquia() {
        if (this.cbHierarquia.getValue() != null) {
            return new HashSet<Long>(Arrays.asList(((HierarquiaDTO)this.cbHierarquia.getValue()).getEstruturaUsuarioId()));
        }
        return this.hierarquia;
    }

    public ProducaoPedidoFilter getFilter() throws Exception {
        if (!(this.cbEtapaFilter.getValue() == null || ((Boolean)this.cbConsideraData.getValue()).booleanValue() && this.dataInicialAtualizacao != null && this.dataFinalAtualizacao != null)) {
            throw new Exception("Para filtrar Entrou/Saiu precisa informar uma data");
        }
        HashSet<Long> sl = new HashSet<Long>();
        for (Object pe : this.cbPedidoEtapa.getValue()) {
            sl.add(pe.getId());
        }
        HashSet<Long> senhas = new HashSet<Long>();
        for (Object es : this.cbSenhas.getValue()) {
            senhas.add(es.getId());
        }
        HashSet<Long> el = new HashSet<Long>();
        for (Equipe e : this.cbEquipe.getValue()) {
            el.add(e.getId());
        }
        ProducaoPedidoFilter ppf = new ProducaoPedidoFilter(this.eu.getEstrutura(), el, this.getHierarquia(), this.filterCliente.getValue(), this.filterNumero.getValue(), this.filterNumeroVinculado.getValue(), this.filterCnpj.getValue(), sl, senhas, (PedidoOrigem)this.cbOrigem.getValue(), (LocalDate)this.dataInicialCadastro.getValue(), (LocalDate)this.dataFinalCadastro.getValue(), (LocalDate)this.dataInicialAtualizacao.getValue(), (LocalDate)this.dataFinalAtualizacao.getValue(), this.cbTags.getValue(), (Boolean)this.cbNaoVinculado.getValue(), (Boolean)this.cbConsideraData.getValue(), (PedidoTipoEnum)this.rbTipo.getValue(), this.cbUsuarioTags.getValue(), (Boolean)this.cbNotificacao.getValue() != false && this.dataNotificacao.getValue() != null ? (LocalDate)this.dataNotificacao.getValue() : null);
        ppf.setProducaoFilterEtapaEnum((ProducaoFilterEtapaEnum)this.cbEtapaFilter.getValue());
        ppf.setPedidoSlaENUM(this.sla);
        ppf.setTagOptionEnum((TagOptionEnum)this.cbTagOption.getValue());
        ppf.setPedidoCategoria((PedidoCategoria)this.cbCategoria.getValue());
        ppf.setPedidoSubCategoria((PedidoSubCategoria)this.cbSubCategoria.getValue());
        ppf.setFilterCotacao(this.filterNumeroCotacao.getValue());
        ppf.setFilterSimulacao(this.filterNumeroSimulacao.getValue());
        ppf.setCpfCnpjEnum((CnpjCpfEnum)this.cbCpfCnpj.getValue());
        return ppf;
    }

    public void setSla(PedidoSlaENUM sla) {
        this.sla = sla;
    }

    public Button getBtnPesquisar() {
        return this.btnPesquisar;
    }

    public Button getBtnInserir() {
        return this.btnInserir;
    }

    private void clear() {
        this.filterCliente.clear();
        this.filterNumero.clear();
        this.filterCnpj.clear();
        this.cbOrigem.setValue((Object)this.pos.getOrigemAtividade(this.getEstrutura()));
        this.cbCategoria.clear();
        this.cbSubCategoria.clear();
        this.cbGrupoEtapa.clear();
        this.cbPedidoEtapa.clear();
        this.cbEtapaFilter.clear();
        this.cbUsuarioTags.clear();
        this.cbEquipe.clear();
        this.cbHierarquia.clear();
        this.cbSenhas.clear();
        this.filterNumeroVinculado.clear();
        this.filterNumeroCotacao.clear();
        this.filterNumeroSimulacao.clear();
        this.dataInicialCadastro.clear();
        this.dataFinalCadastro.clear();
        this.dataInicialAtualizacao.setValue(LocalDate.now().minusDays(7L));
        this.dataFinalAtualizacao.setValue(LocalDate.now());
        this.cbConsideraData.setValue((Object)true);
        this.cbNaoVinculado.clear();
        this.dataNotificacao.clear();
        this.cbNotificacao.clear();
        this.cbTags.clear();
        this.cbTagOption.setValue((Object)TagOptionEnum.OU);
    }
}

