/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoProdutos;
import br.com.system.app.features.producaopainel.service.ProducaoProdutosService;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.service.ProdutoService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

public class ProducaoProdutoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProdutoService ps;
    private final ProducaoLinhas linha;
    private final EstruturaUsuario eu;
    private final ProducaoProdutosService pps;
    private MultiComboBox<Produto> cbProduto;
    private ComboBox<ProdutoCategoria> cbCategoria;
    private ComboBox<ProdutoOrigem> cbOrigem;

    public ProducaoProdutoView(EstruturaUsuario eu, ProducaoLinhas linha, ProducaoProdutosService pps, ProdutoService ps) {
        this.ps = ps;
        this.eu = eu;
        this.linha = linha;
        this.pps = pps;
        this.createContent();
    }

    private void createContent() {
        if (this.linha == null) {
            UIUtils.showNotification((String)"Linha esta nula");
            return;
        }
        this.setWidth("600px");
        this.setHeight("650px");
        GridCrud crud = new GridCrud(ProducaoProdutos.class);
        this.cbProduto = new MultiComboBox("Produto");
        this.cbProduto.setWidth("80%");
        this.cbProduto.setItemLabelGenerator(Produto::getNomeAndCategoriaAndOrigem);
        this.cbOrigem = new ComboBox("Origem", (Object[])ProdutoOrigem.values());
        this.cbOrigem.setItemLabelGenerator(Enum::name);
        this.cbOrigem.setWidth("80%");
        this.cbOrigem.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null) {
                this.povoaProdutos();
            }
        });
        this.cbCategoria = new ComboBox("Categoria", (Collection)this.ps.getByEstrutura(this.eu.getEstrutura()));
        this.cbCategoria.setItemLabelGenerator(ProdutoCategoria::getNome);
        this.cbCategoria.setWidth("80%");
        this.cbCategoria.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.getValue() != null) {
                this.povoaProdutos();
            }
        });
        Button add = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar Produto");
        add.addClickListener((ComponentEventListener & Serializable)e -> {
            HashSet produtos = this.cbProduto.getValue().size() > 0 ? this.cbProduto.getValue() : new HashSet(this.getDados(this.getEstrutura()));
            if (produtos.size() <= 0) {
                UIUtils.showNotification((String)"Nao ha produtos selecionados");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Inserir produtos", "Confirma inser\u00e7\u00e3o de " + produtos.size() + " ?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                for (Produto p : produtos) {
                    if (this.pps.getByProducaoLinhaAndProduto(this.linha, p) != null) continue;
                    ProducaoProdutos pp = new ProducaoProdutos();
                    pp.setProducaoLinhas(this.linha);
                    pp.setProduto(p);
                    this.pps.save(pp);
                }
                this.cbProduto.clear();
                crud.refreshGrid();
                cd.close();
            });
        });
        this.povoaProdutos();
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        crud.getCrudLayout().addFilterComponent((Component)filter);
        Button trashAll = UIUtils.createSmallButton((String)"Excluir Todos", (String)"Excluir todos os produtos");
        trashAll.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o total", "Confirma exclus\u00e3o de todos os produtos dessa linha?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.pps.deleteByProducaoLinhas(this.linha);
                crud.refreshGrid();
                cd.close();
            });
        });
        crud.getCrudLayout().addToolbarComponent((Component)trashAll);
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProduto().getId().toString())).setFlexGrow(0).setWidth("60px").setHeader("Id");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProduto().getNome())).setFlexGrow(0).setWidth("600px").setHeader("Produtos inseridos");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProduto().getCategoria().getNome())).setFlexGrow(0).setWidth("600px").setHeader("Categoria");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getProduto().getOrigem().name())).setFlexGrow(0).setWidth("600px").setHeader("Origem");
        crud.getAddButton().setVisible(false);
        crud.getUpdateButton().setVisible(false);
        crud.getDeleteButton().setVisible(this.hasPermission("PAINEL_PRODUCAO_DELETE"));
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        Button fechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"Fechar");
        fechar.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        this.add(new Component[]{UIUtils.createHeader((String)("Configura\u00e7\u00f5es produtos linha: " + this.linha.getNome())), this.cbOrigem, this.cbCategoria, new HorizontalContainer(new Component[]{this.cbProduto, add}), new VerticalContainer(new Component[]{crud, fechar})});
    }

    private void povoaProdutos() {
        this.cbProduto.setItems((Collection)this.getDados(this.eu.getEstrutura()));
    }

    private List<Produto> getDados(Estrutura e) {
        if (this.cbOrigem.getValue() != null && this.cbCategoria.getValue() != null) {
            return this.ps.getProdutosByOrigemAndCategoria(e, (ProdutoOrigem)this.cbOrigem.getValue(), (ProdutoCategoria)this.cbCategoria.getValue());
        }
        if (this.cbOrigem.getValue() != null && this.cbCategoria.getValue() == null) {
            return this.ps.getProdutosByOrigem(e, (ProdutoOrigem)this.cbOrigem.getValue());
        }
        if (this.cbOrigem.getValue() == null && this.cbCategoria.getValue() != null) {
            return this.ps.getProdutosByCategoria(e, (ProdutoCategoria)this.cbCategoria.getValue());
        }
        return this.ps.getProdutos(e);
    }
}

