/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto.model;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.commons.CurrencyUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@Entity
@Table(name="produto")
public class Produto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    private String nome;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ProdutoOrigem origem;
    @NotNull
    private String descricao;
    @NotNull
    private BigDecimal valor;
    @NotNull
    private BigDecimal descontoPrateleira;
    @NotNull
    @OneToOne
    private EstruturaTipo estruturaTipo;
    @OneToOne
    private Estrutura estrutura;
    @NotNull
    @OneToOne
    @JsonIgnoreProperties(value={"estruturaTipo"})
    @JoinColumn(name="produto_categoria_id")
    private ProdutoCategoria categoria;
    private BigDecimal valorAdicional;
    private Boolean somaQuantidade;
    private BigDecimal quantosMegas;
    private Boolean compromissoMensal;
    private Boolean ativo;
    private Boolean apareceProposta;

    public Produto() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public String getNomeAndValor() {
        return this.nome + " R$ " + CurrencyUtil.toCurrency((BigDecimal)this.getValor());
    }

    public String getNomeAndCategoriaAndOrigem() {
        return this.getNome() + " " + this.getCategoria().getNome() + " " + this.getOrigem().name();
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public ProdutoOrigem getOrigem() {
        return this.origem;
    }

    public void setOrigem(ProdutoOrigem origem) {
        this.origem = origem;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public BigDecimal getDescontoPrateleira() {
        return this.descontoPrateleira;
    }

    public void setDescontoPrateleira(BigDecimal descontoPrateleira) {
        this.descontoPrateleira = descontoPrateleira;
    }

    public EstruturaTipo getEstruturaTipo() {
        return this.estruturaTipo;
    }

    public void setEstruturaTipo(EstruturaTipo estruturaTipo) {
        this.estruturaTipo = estruturaTipo;
    }

    public ProdutoCategoria getCategoria() {
        return this.categoria;
    }

    public void setCategoria(ProdutoCategoria categoria) {
        this.categoria = categoria;
    }

    public BigDecimal getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(BigDecimal valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    public Boolean getSomaQuantidade() {
        return this.somaQuantidade;
    }

    public void setSomaQuantidade(Boolean somaQuantidade) {
        this.somaQuantidade = somaQuantidade;
    }

    public BigDecimal getQuantosMegas() {
        return this.quantosMegas;
    }

    public void setQuantosMegas(BigDecimal quantosMegas) {
        this.quantosMegas = quantosMegas;
    }

    public Boolean getCompromissoMensal() {
        return this.compromissoMensal;
    }

    public void setCompromissoMensal(Boolean compromissoMensal) {
        this.compromissoMensal = compromissoMensal;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public Boolean getApareceProposta() {
        return this.apareceProposta;
    }

    public void setApareceProposta(Boolean apareceProposta) {
        this.apareceProposta = apareceProposta;
    }

    public Produto(Long id, String nome, ProdutoOrigem origem, String descricao, BigDecimal valor, BigDecimal descontoPrateleira, EstruturaTipo estruturaTipo, ProdutoCategoria categoria) {
        this.id = id;
        this.nome = nome;
        this.origem = origem;
        this.descricao = descricao;
        this.valor = valor;
        this.descontoPrateleira = descontoPrateleira;
        this.estruturaTipo = estruturaTipo;
        this.categoria = categoria;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id);
        hash = 67 * hash + Objects.hashCode(this.nome);
        hash = 67 * hash + Objects.hashCode(this.origem);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Produto other = (Produto)obj;
        if (!Objects.equals(this.nome, other.nome)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return this.origem == other.origem;
    }

    public String toString() {
        return "Produto{nome=" + this.nome + ", origem=" + String.valueOf(this.origem) + ", descricao=" + this.descricao + ", valor=" + String.valueOf(this.valor) + ", descontoPrateleira=" + String.valueOf(this.descontoPrateleira) + ", categoria=" + String.valueOf(this.categoria) + ", valorAdicional=" + String.valueOf(this.valorAdicional) + ", somaQuantidade=" + this.somaQuantidade + ", quantosMegas=" + String.valueOf(this.quantosMegas) + ", compromissoMensal=" + this.compromissoMensal + ", ativo=" + this.ativo + "}";
    }
}

