/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.components.Card;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.model.MailingSocio;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.math.BigDecimal;
import java.time.LocalDate;

public class ReceitaFormView
extends FlexBoxLayout {
    private static final long serialVersionUID = 1L;

    public FlexBoxLayout getContent(Mailing mailing) {
        this.setSpacingS();
        this.setFlexDirection(FlexLayout.FlexDirection.ROW);
        this.removeAll();
        this.add(new Component[]{this.getCardBasico(mailing), this.getCardEndereco(mailing), this.getCardSocios(mailing), this.getCardCnae(mailing)});
        return this;
    }

    private Card getCardBasico(Mailing mailing) {
        Card card = this.getCard("Dados B\u00e1sicos");
        TextField cnpj = this.creteTextInput("Cnpj", mailing.getCpfCnpj());
        TextField nome = this.creteTextInput("Raz\u00e3o Social", mailing.getNome());
        TextField fantasia = this.creteTextInput("Fantasia", mailing.getNomeFantasia());
        TextField capital = this.creteTextInput("Capital Social", UIUtils.formatCurrency((BigDecimal)mailing.getCapitalSocial()));
        TextField dataAbertura = this.creteTextInput("Data Abertura", this.getDate(mailing.getDataAbertura()));
        TextField situacao = this.creteTextInput("Situa\u00e7\u00e3o", mailing.getSituacao());
        TextField dataSituacao = this.creteTextInput("Data Situa\u00e7\u00e3o", this.getDate(mailing.getDataSituacao()));
        TextField natureza = this.creteTextInput("Natureza Juridica", mailing.getNaturezaJuridica());
        TextField matrizFilial = this.creteTextInput("Matriz ou Filial", mailing.getMatrizFilial());
        TextField porte = this.creteTextInput("Porte", mailing.getPorte());
        TextField simples = this.creteTextInput("Simples", mailing.getOpcaoSimples());
        TextField dataSimples = this.creteTextInput("Data Simples", this.getDate(mailing.getDataOpcaoSimples()));
        TextField mei = this.creteTextInput("Mei", mailing.getOpcaoMei().equals("S") ? "SIM" : "N\u00c3O");
        card.setContent(new Component[]{cnpj, nome, fantasia, capital, dataAbertura, situacao, dataSituacao, natureza, matrizFilial, porte, simples, dataSimples, mei});
        return card;
    }

    private Card getCardSocios(Mailing mailing) {
        Card card = this.getCard("S\u00f3cios");
        for (MailingSocio ms : mailing.getSocios()) {
            TextField nome = this.creteTextInput("Nome", ms.getNome());
            TextField data = this.creteTextInput("Entrada", this.getDate(ms.getDataEntrada()));
            card.setContent(new Component[]{nome, data});
        }
        return card;
    }

    private Card getCardCnae(Mailing mailing) {
        Card card = this.getCard("Segmentos");
        for (MailingAtividade ma : mailing.getAtividades()) {
            TextField nome = this.creteTextInput("Codigo", ma.getCnae().getCodigo());
            TextField data = this.creteTextInput("Entrada", ma.getCnae().getDescricao());
            if (ma.getPrincipal().booleanValue()) {
                Span principal = new Span("*Principal");
                UIUtils.setTextColor((TextColor)TextColor.HEADER, (Component[])new Component[]{nome, data, principal});
            }
            card.setContent(new Component[]{nome, data});
        }
        return card;
    }

    private Card getCardEndereco(Mailing mailing) {
        Card card = this.getCard("Endere\u00e7o");
        TextField cep = this.creteTextInput("Cep", mailing.getCep());
        TextField rua = this.creteTextInput("Logradouro", mailing.getLogradouro());
        TextField nro = this.creteTextInput("Numero", mailing.getNumero());
        TextField compl = this.creteTextInput("Compl", mailing.getComplemento());
        TextField bairro = this.creteTextInput("Bairro", mailing.getBairro());
        TextField cidade = this.creteTextInput("Cidade", mailing.getCidade());
        TextField estado = this.creteTextInput("Estado", mailing.getEstado());
        card.setContent(new Component[]{cep, rua, nro, compl, bairro, cidade, estado});
        return card;
    }

    private TextField creteTextInput(String label, String value) {
        TextField tf = new TextField(label);
        tf.setValue(value);
        tf.setReadOnly(true);
        return tf;
    }

    private String getDate(LocalDate date) {
        if (date == null) {
            return "";
        }
        return date.format(FormatDate.DATE_BR.toDTF());
    }

    private Card getCard(String header) {
        Card card = new Card();
        card.setHeader(header);
        card.setWidthFull();
        return card;
    }
}

