/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.shared.handle;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.handle.HandlerCepNumero;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.commons.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HandlerExcel {
    public Set<String> getValueFirstColumn(InputStream file) {
        return this.getDadosFromCell(file, Integer.valueOf(0));
    }

    public Set<String> getDadosFromCell(InputStream file, Integer cellPosition) {
        HashSet<String> retorno = new HashSet<String>();
        XSSFWorkbook xls = null;
        try {
            xls = new XSSFWorkbook(file);
            Sheet aba = xls.getSheetAt(cellPosition.intValue());
            for (int i = 0; i <= aba.getLastRowNum(); ++i) {
                Cell cell;
                Row row = aba.getRow(i);
                if (row == null || (cell = row.getCell(0)) == null) continue;
                String value = StringUtil.numbersOnly((String)ExcellUtil.getValueString((Cell)cell));
                if (!value.isEmpty()) {
                    retorno.add(value);
                }
                row = null;
            }
            aba = null;
        }
        catch (IOException ex) {
            throw new BusinessException(ex.getMessage());
        }
        finally {
            try {
                xls.close();
                file.close();
                xls = null;
                file = null;
            }
            catch (Exception exception) {}
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSetInCell(InputStream file, int abaNum, int celNum, boolean eraseFile) {
        HashSet<String> results = new HashSet<String>();
        XSSFWorkbook workbook = null;
        try {
            workbook = new XSSFWorkbook(file);
            Sheet aba = workbook.getSheetAt(abaNum);
            int lastRowNum = aba.getLastRowNum();
            for (int i = 0; i <= lastRowNum; ++i) {
                Cell cell;
                Row row = aba.getRow(i);
                if (row == null || (cell = row.getCell(celNum)) == null) continue;
                String value = ExcellUtil.getValueString((Cell)cell);
                if (!results.contains(value)) {
                    results.add(value);
                }
                row = null;
            }
            aba = null;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                workbook.close();
                file.close();
                workbook = null;
                file = null;
            }
            catch (Exception exception) {}
        }
        return results;
    }

    public Set<HandlerCepNumero> getFilterCep(InputStream file) {
        HashSet<HandlerCepNumero> retorno = new HashSet<HandlerCepNumero>();
        XSSFWorkbook xls = null;
        try {
            xls = new XSSFWorkbook(file);
            Sheet aba = xls.getSheetAt(0);
            for (int i = 0; i <= aba.getLastRowNum(); ++i) {
                String cep;
                Cell cell;
                Cell cell2 = cell = aba.getRow(i) == null ? null : aba.getRow(i).getCell(0);
                if (cell == null || (cep = StringUtil.numbersOnly((String)ExcellUtil.getValueString((Cell)cell))).isEmpty()) continue;
                String nro = "SN";
                cell = aba.getRow(i).getCell(1);
                if (cell != null) {
                    nro = StringUtil.normalize((String)ExcellUtil.getValueString((Cell)cell));
                }
                if (nro.isEmpty()) {
                    nro = "SN";
                }
                retorno.add(new HandlerCepNumero(cep, nro));
            }
            aba = null;
        }
        catch (Exception ex) {
            throw new BusinessException(ex.getMessage());
        }
        finally {
            try {
                xls.close();
                file.close();
                xls = null;
                file = null;
            }
            catch (Exception exception) {}
        }
        return retorno;
    }
}

