/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.shared.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.naoperturbe.service.NaoPerturbeService;
import br.com.system.app.features.trescx.model.TrescxChamada;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TelefoneService {
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private TrescxChamadaService trescxChamadaService;
    @Autowired
    private NaoPerturbeService naoPerturbeService;

    public boolean isNaoPerturbe(String numero) {
        return this.naoPerturbeService.isNaoPerturbe(numero);
    }

    @Async(value="asyncDefault")
    public void temWhats(Set<ClienteContato> contatos, Consumer<Set<ClienteContato>> listener) {
        for (ClienteContato contato : contatos) {
            if (contato.getTipo() != null && contato.getTipo().equals((Object)TipoContatoEnum.EMAIL)) continue;
            try {
                long diff;
                if (contato.getDataWhats() != null && (diff = ChronoUnit.DAYS.between(contato.getDataWhats(), LocalDate.now())) < 30L && contato.getTemWhats() != null) continue;
                contato.setTemWhats(Boolean.valueOf(this.temWhats(contato.getValor())));
                contato.setDataWhats(LocalDate.now());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        listener.accept(contatos);
    }

    public boolean temWhats(String numero) {
        return this.whatsAppHaveService.have(numero);
    }

    public String get3cxLink(String tel) {
        return "<a href=\"#\" data-toggle=\"tooltip\" title='Ligar' onClick=\"Neo3cxWindow=window.open('https://neocrm.my3cx.com.br/webclient/#/people?phone=" + tel + "','3cxWindow','width=500,height=500'); return false;\"><img src=\"images/phone20.png\"></a>";
    }

    public WhatsAppHave getHave(String numero) {
        return this.whatsAppHaveService.getHave(numero);
    }

    public void gravarChamada3cx(EstruturaUsuario eu, String numero, String cpfCnpj, Long atividade) {
        TrescxChamada tc = new TrescxChamada();
        tc.setCpfCnpj(cpfCnpj);
        tc.setDataHora(LocalDateTime.now());
        tc.setDestino(numero);
        tc.setEstruturaUsuario(eu);
        tc.setPedidoId(atividade);
        tc.setRamal(eu.getUsuario().getRamal());
        this.trescxChamadaService.save(tc);
    }
}

