/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.tim.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PedidoTimService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PedidoEtapaService pedidoEtapaService;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private PedidoItemService pedidoItemService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private NotificacoesService notificacoesService;

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        return ExcellUtil.getValueString((Cell)cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="asyncDefault")
    public void importarArquivos(EstruturaUsuario eu, InputStream is, String mimeType) {
        EstruturaUsuario master = this.estruturaUsuarioService.getMasterEstrutura(eu.getEstrutura());
        StringBuilder logOk = new StringBuilder();
        StringBuilder logErro = new StringBuilder();
        try {
            XSSFWorkbook xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheetAt(0);
            HashMap<String, String> naoLocalizados = new HashMap<String, String>();
            HashSet<String> erroCnpj = new HashSet<String>();
            for (int i = 0; i <= aba.getLastRowNum(); ++i) {
                try {
                    Row r = aba.getRow(i);
                    String numero = this.getCellValue(r.getCell(0));
                    String status = this.getCellValue(r.getCell(14));
                    String dataStr = this.getCellValue(r.getCell(12));
                    String cpfCnpj = this.getCellValue(r.getCell(2));
                    if (numero.isEmpty() || numero.equals("Pedido") || status.isEmpty()) continue;
                    cpfCnpj = StringUtil.normalizeCpfCnpj((String)cpfCnpj);
                    LocalDate data = DateTimeUtil.toDate((String)dataStr, (FormatDate)FormatDate.DATE_BR);
                    List pedidos = this.pedidoService.getByNumeroVinculado(eu.getEstrutura(), numero);
                    if ((pedidos == null || pedidos.size() <= 0) && this.inStatus(status)) {
                        if (naoLocalizados.containsKey(numero)) continue;
                        naoLocalizados.put(numero, status);
                        continue;
                    }
                    for (Pedido p : pedidos) {
                        if (!p.getPedidoEtapa().isSincronizavel()) continue;
                        if (!p.getCliente().getCpfCnpj().equals(cpfCnpj)) {
                            erroCnpj.add(numero);
                            continue;
                        }
                        if (p.getPedidoEtapa().getNome().equals(StringUtil.normalize((String)status).toUpperCase()) && data == null || data != null && p.getPedidoEtapa().getNome().equals(StringUtil.normalize((String)status).toUpperCase()) && p.getDataHoraOperadora() != null && p.getDataHoraOperadora().equals(data.atStartOfDay())) continue;
                        PedidoEtapa e2 = this.pedidoEtapaService.getAndCreate(eu.getEstrutura(), status, this.pedidoOrigemService.getOrigemAtividade(eu.getEstrutura()), PedidoTipoEnum.COMERCIAL);
                        String msg = "Atualizado de " + p.getPedidoEtapa().getNome() + " para " + e2.getNome();
                        p.setPedidoEtapa(e2);
                        p.setDataHoraUltimaMov(LocalDateTime.now());
                        p.setDataHoraOperadora(data == null ? LocalDateTime.now() : data.atStartOfDay());
                        this.pedidoService.salvar(p, msg, master, false);
                        if (e2.getAtualizaDataReferencia().booleanValue()) {
                            this.pedidoItemService.updateData(p.getId(), data == null ? LocalDate.now() : data);
                        }
                        logOk.append("Pedido ").append(numero).append(" vinculado a ").append(p.getNumero()).append(" movimentado para ").append(status).append("\n");
                    }
                    continue;
                }
                catch (Exception e3) {
                    logErro.append(e3.getMessage()).append("\n");
                }
            }
            xls.close();
            is.close();
            if (!naoLocalizados.isEmpty()) {
                logErro.append("N\u00e3o localizados\n");
                for (Map.Entry pair : naoLocalizados.entrySet()) {
                    logErro.append((String)pair.getKey()).append(" ").append((String)pair.getValue()).append("\n");
                }
            }
            if (!erroCnpj.isEmpty()) {
                logErro.append("\n\nDivergencia CNPJ\n");
                erroCnpj.forEach(e -> logErro.append((String)e).append("\n"));
            }
        }
        catch (Exception e4) {
            logErro.append(e4.getMessage()).append("\n");
        }
        this.notificacoesService.notify(eu, "Atualizacao Pedidos TIM", logErro.toString() + "\n\nAtualizados\n" + logOk.toString());
    }

    private boolean inStatus(String status) {
        return (status = StringUtil.normalize((String)status).toUpperCase()).contains("ANTIFRAUDE") || status.contains("CONCLUIDO") || status.contains("FATURAMENTO") || status.contains("DOCUMENTACAO");
    }
}

