/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx;

import br.com.system.app.MainLayout;
import br.com.system.app.components.AudioPlayerView;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.trescx.TrescxBoxView;
import br.com.system.app.features.trescx.dto.TrescxLogDTO;
import br.com.system.app.features.trescx.dto.TrescxLogResumoDTO;
import br.com.system.app.features.trescx.service.TrescxLogService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="trescx-dashboard", layout=MainLayout.class)
@PageTitle(value="Dashboard 3CX")
@RolesAllowed(value={"TRESCX_DASH_VIEW"})
public class TrescxDashView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final TrescxLogService tls;
    private final UsuarioHierarquiaService hierarquiaService;
    private final AudioPlayerView audioPlayerView;
    private GridCrud<TrescxLogDTO> crud;
    private final HorizontalContainer resumoContainer = new HorizontalContainer(new Component[0]);
    private final HorizontalContainer filterContainer = new HorizontalContainer(new Component[0]);
    private DatePicker di;
    private DatePicker df;
    private TimePicker tp;
    private ComboBox<HierarquiaDTO> cbHierarquia;
    private TextField txtDestino;
    private Button bFind;
    private Button bExport;
    private Span lblTotal;
    private DownloadDialog dd;

    @Autowired
    public TrescxDashView(TrescxLogService tls, UsuarioHierarquiaService hierarquiaService, AudioPlayerView audioPlayerView) {
        this.tls = tls;
        this.audioPlayerView = audioPlayerView;
        this.hierarquiaService = hierarquiaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent((Component)this.create());
            this.povoaResumo();
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private VerticalContainer create() {
        this.dd = new DownloadDialog();
        this.removeAll();
        this.filterContainer.removeAll();
        this.resumoContainer.removeAll();
        VerticalContainer l = new VerticalContainer(new Component[0]);
        l.add(new Component[]{this.filterContainer});
        l.add(new Component[]{this.resumoContainer});
        l.add(new Component[]{this.getGrid()});
        return l;
    }

    private void povoaResumo() {
        this.resumoContainer.removeAll();
        List lista = this.tls.resumo(this.getEu(), (LocalDate)this.di.getValue(), (LocalDate)this.df.getValue());
        for (TrescxLogResumoDTO d : lista) {
            this.resumoContainer.add(new Component[]{new TrescxBoxView(d)});
        }
    }

    private Component getGrid() {
        this.cbHierarquia = new ComboBox("Hieraquia", (Collection)this.hierarquiaService.getHierarquiaDto(this.getEu(), "", Boolean.valueOf(false)));
        this.cbHierarquia.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        this.cbHierarquia.setMinWidth("300px");
        this.txtDestino = new TextField("Destino");
        this.di = new DatePicker();
        this.di.setLabel("Inicio");
        this.di.setValue(LocalDate.now());
        this.di.setLocale(UIUtils.getLocale());
        this.df = new DatePicker();
        this.df.setLabel("Final");
        this.df.setValue(LocalDate.now());
        this.df.setLocale(UIUtils.getLocale());
        this.tp = new TimePicker();
        this.tp.setLabel("Minutos Falando");
        this.tp.setValue(LocalTime.of(0, 0, 0));
        this.tp.setLocale(UIUtils.getLocale());
        this.bFind = UIUtils.createSmallButton((String)"Pesquisar");
        this.bFind.setDisableOnClick(true);
        this.bFind.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.di.getValue() == null || this.df.getValue() == null) {
                this.bFind.setEnabled(true);
                this.showNotification("Data inicio e fim obrigatorio");
                return;
            }
            this.crud.refreshGrid();
            this.povoaResumo();
            this.bFind.setEnabled(true);
        });
        this.bExport = UIUtils.createSmallButton((String)"Exportar");
        this.bExport.setDisableOnClick(true);
        this.bExport.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.di.getValue() == null || this.df.getValue() == null) {
                this.showNotification("Data inicio e fim obrigatorio");
                return;
            }
            this.dd.open(this.tls.export(this.getEu(), (LocalDate)this.di.getValue(), (LocalDate)this.df.getValue(), (LocalTime)this.tp.getValue()), "Exportacao-3cx.xlsx", true);
            this.bExport.setEnabled(true);
        });
        this.lblTotal = new Span();
        this.filterContainer.add(new Component[]{this.lblTotal, this.di, this.df, this.tp, this.cbHierarquia, this.txtDestino, this.bFind, this.bExport});
        this.crud = new GridCrud(TrescxLogDTO.class);
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getDestino() == null ? "" : p.getDestino())))).setHeader("Destino").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getRamal() == null ? "" : p.getRamal())))).setHeader("Ramal").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getStatus() == null ? "" : p.getStatus())))).setHeader("Status").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getInicio() == null ? "" : p.getInicio().format(FormatDate.DATETIME_BR.toDTF()))))).setHeader("Inicio").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getFim() == null ? "" : p.getFim().format(FormatDate.DATETIME_BR.toDTF()))))).setHeader("Fim").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getTalking() == null ? "" : p.getTalking().toString())))).setHeader("Falando").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getRing() == null ? "" : p.getRing().toString())))).setHeader("Chamando").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getTotal() == null ? "" : p.getTotal().toString())))).setHeader("Total").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            TrescxLogDTO tl = eg;
            Button b = UIUtils.createSmallButton((String)"Ouvir");
            b.setVisible(tl.getHashGravacao() != null);
            b.addClickListener((ComponentEventListener & Serializable)e -> this.audioPlayerView.create(tl.getHashGravacao()));
            return b;
        })).setFlexGrow(0).setWidth("150px").setHeader("Grava\u00e7\u00e3o");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getCpfCnpj() == null ? "" : p.getCpfCnpj())))).setHeader("CPF-CNPJ").setFlexGrow(0).setWidth("150px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.getPedidoId() == null ? "" : p.getPedidoId().toString())))).setHeader("Atividade").setFlexGrow(0).setWidth("150px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{""});
        this.crud.getFindAllButton().setVisible(false);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }
}

