/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioAnexo;
import br.com.system.app.features.usuario.repository.UsuarioAnexoRepository;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsuarioAnexoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private UsuarioAnexoRepository anexoRepository;

    public UsuarioAnexo save(UsuarioAnexo UsuarioAnexo2) {
        if (UsuarioAnexo2.getEstruturaUsuario() == null) {
            throw new BusinessException("Estrutura Usuario obrigatorio");
        }
        if (UsuarioAnexo2.getHashArquivo().isBlank()) {
            throw new BusinessException("Hash obrigatorio");
        }
        if (UsuarioAnexo2.getUsuario() == null) {
            throw new BusinessException("Usuario obrigatorio");
        }
        return (UsuarioAnexo)this.anexoRepository.save((Object)UsuarioAnexo2);
    }

    public void save(Usuario usuario, EstruturaUsuario euContext, TempFileMultiBuffer buffer) {
        for (String file : buffer.getFiles()) {
            String extensao = FileUtil.getExtension((String)buffer.getFileData(file).getFileName());
            String hash = HashUtil.getUUI();
            try {
                StorageUtil.uploadObjectInputStream((String)(hash + extensao), (InputStream)buffer.getInputStream(file));
            }
            catch (Exception e) {
                throw new BusinessException("Erro ao gravar arquivo: " + e.getMessage());
            }
            UsuarioAnexo ca = new UsuarioAnexo();
            ca.setHashArquivo(hash);
            ca.setEstruturaUsuario(euContext);
            ca.setDataHora(LocalDateTime.now());
            ca.setNomeArquivo(buffer.getFileData(file).getFileName());
            ca.setUsuario(usuario);
            this.save(ca);
        }
    }

    public void delete(UsuarioAnexo pa) throws Exception {
        StorageUtil.deleteObject((String)pa.getHashArquivo());
        this.anexoRepository.delete((Object)pa);
    }

    public List<UsuarioAnexo> getAnexo(Long usuarioId) {
        return this.anexoRepository.findByUsuarioId(usuarioId);
    }

    public List<UsuarioAnexo> getAnexo(Usuario usuario) {
        return this.anexoRepository.findByUsuario(usuario);
    }
}

