/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class UsuarioExportacao
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String export(List<UsuarioDTO> usuarios) {
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            try {
                is = StorageUtil.getObjectModelo((String)"ExportacaoUsuarios-v3.xlsx");
                xls = new XSSFWorkbook(is);
                Sheet aba = xls.getSheet("Exportacao");
                CellStyle styleCellDouble = xls.createCellStyle();
                styleCellDouble.setDataFormat((short)2);
                int linha = 1;
                for (UsuarioDTO u : usuarios) {
                    Row row = aba.createRow(linha);
                    row.createCell(0).setCellValue(u.getNome());
                    row.createCell(1).setCellValue(u.getLogin());
                    row.createCell(2).setCellValue(u.getEmail());
                    row.createCell(3).setCellValue(u.getCelular());
                    row.createCell(4).setCellValue(u.getRamal());
                    row.createCell(5).setCellValue(this.getVal(u.getTags()));
                    row.createCell(6).setCellValue(u.getPerfil() == null ? "NAO DEFINIDO" : u.getPerfil().name());
                    row.createCell(7).setCellValue(u.getAtivo() != false ? "Ativo" : "Inativo");
                    row.createCell(8).setCellValue(u.getNomeEquipe());
                    row.createCell(9).setCellValue(this.getVal(u.getDataAdmissao() == null ? "" : u.getDataAdmissao().format(FormatDate.DATE_BR.toDTF())));
                    row.createCell(10).setCellValue(this.getVal(u.getRules()));
                    ++linha;
                }
                String nomeArquivo = HashUtil.getUUI() + ".xlsx";
                InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
                String string = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
                return string;
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
            finally {
                try {
                    xls.close();
                    is.close();
                    xls = null;
                    is = null;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private String getVal(String value) {
        if (value == null) {
            return "";
        }
        if (value.startsWith(",")) {
            value = value.substring(1);
        }
        return value;
    }
}

