/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.importacao.ImportacaoColunas;
import br.com.system.app.components.importacao.ImportacaoExcel;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.dto.UsuarioCopyTypeEnum;
import br.com.system.app.features.usuario.dto.UsuarioDTO;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import br.com.system.app.features.usuario.service.UsuarioAnexoService;
import br.com.system.app.features.usuario.service.UsuarioCopyService;
import br.com.system.app.features.usuario.service.UsuarioExportacao;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.service.UsuarioTagService;
import br.com.system.app.features.usuario.views.UsuarioAnexoView;
import br.com.system.app.features.usuario.views.UsuarioFormView;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cadastro-usuario", layout=MainLayout.class)
@PageTitle(value="Cadastro de Usuarios")
@RolesAllowed(value={"CADASTRO_USUARIO_VIEW"})
public class UsuarioCadastroView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final UsuarioService usuarioService;
    private final UsuarioRepository usuarioRepository;
    private final NotificacoesService ns;
    private final EstruturaUsuarioService eus;
    private final UsuarioAnexoService usuarioAnexoService;
    private final UsuarioTagService usuarioTagService;
    private final UsuarioHierarquiaService usuarioHierarquiaService;
    private final UsuarioCopyService copyService;
    private final EquipeService equipeService;
    private final WhatsAppContaService whatsappContaService;
    private GridCrud<UsuarioDTO> crud;
    private TextField filterLogin;
    private TextField filterNome;
    private TextField filterRamal;
    private EmailField filterEmail;
    private MultiComboBox<UsuarioPerfilEnum> cbPerfil;
    private ComboBox<Equipe> cbEquipe;
    private Checkbox cb;
    private ComboBox<UsuarioTag> cbTag;

    public UsuarioCadastroView(UsuarioService usuarioService, UsuarioRepository usuarioRepository, NotificacoesService ns, EstruturaUsuarioService eus, UsuarioAnexoService usuarioAnexoService, UsuarioTagService usuarioTagService, UsuarioHierarquiaService usuarioHierarquiaService, UsuarioCopyService copyService, EquipeService equipeService, WhatsAppContaService whatsappContaService) {
        this.usuarioService = usuarioService;
        this.whatsappContaService = whatsappContaService;
        this.equipeService = equipeService;
        this.copyService = copyService;
        this.usuarioHierarquiaService = usuarioHierarquiaService;
        this.usuarioTagService = usuarioTagService;
        this.usuarioRepository = usuarioRepository;
        this.ns = ns;
        this.eus = eus;
        this.usuarioAnexoService = usuarioAnexoService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.crud = new GridCrud(UsuarioDTO.class);
        this.crud.setHeightFull();
        this.crud.getGrid().addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COLUMN_BORDERS, GridVariant.MATERIAL_COLUMN_DIVIDERS, GridVariant.LUMO_COMPACT});
        this.crud.getFindAllButton().setVisible(false);
        this.filterLogin = UIUtils.createTextField((String)"Login");
        this.filterNome = UIUtils.createTextField((String)"Nome");
        this.filterRamal = UIUtils.createTextField((String)"Ramal");
        this.filterEmail = UIUtils.createEmailField((String)"E-mail");
        this.cbPerfil = new MultiComboBox("Perfil", (Object[])UsuarioPerfilEnum.values());
        this.cbPerfil.setItemLabelGenerator(Enum::name);
        this.cbEquipe = new ComboBox("Equipe", (Collection)this.equipeService.getEquipes(this.getEstrutura()));
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.cbTag = new ComboBox("Tag");
        this.cbTag.setItemLabelGenerator(UsuarioTag::getTag);
        this.cbTag.setItems((Collection)this.usuarioTagService.getTags(this.getEstrutura()));
        this.cb = new Checkbox("Somente ativos");
        Button btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH, (String)"Iniciar pesquisa");
        btnPesquisar.setDisableOnClick(true);
        btnPesquisar.addClickListener((ComponentEventListener & Serializable)e -> {
            this.crud.refreshGrid();
            btnPesquisar.setEnabled(true);
        });
        this.crud.getCrudLayout().addToolbarComponent((Component)this.getOptions());
        if (this.isMaster()) {
            this.crud.getGrid().setSelectionMode(Grid.SelectionMode.MULTI);
        }
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getNome()))).setFlexGrow(0).setWidth("250px").setHeader("Nome");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)e -> e.getAtivo() != false ? "Ativo" : "Inativo")).setHeader("Ativo").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)e -> e.isSessaoUnica() ? "Sess\u00e3o \u00danica" : "Multiplas Sess\u00f5es")).setHeader("Sess\u00e3o").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getLogin()))).setFlexGrow(0).setWidth("250px").setHeader("Login");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getRamal()))).setFlexGrow(0).setWidth("150px").setHeader("Ramal 3CX");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getEmail()))).setFlexGrow(0).setWidth("300px").setHeader("Email");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getEmailAlternativo()))).setFlexGrow(0).setWidth("300px").setHeader("Email Alternativo");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getPerfil().name()))).setFlexGrow(0).setWidth("160px").setHeader("Perfil");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getNomeEquipe()))).setFlexGrow(0).setWidth("250px").setHeader("Equipe");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getTags()))).setFlexGrow(0).setWidth("250px").setHeader("Tags");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> UIUtils.createBreakWrapSpan((String)e.getTokenIntegration()))).setFlexGrow(0).setWidth("250px").setHeader("Token Integra\u00e7\u00e3o");
        this.crud.getGrid().addColumns(new String[]{"celular", "celularAlternativo", "saldo"});
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.getCrudFormFactory().setVisibleProperties(new String[]{"nomeArquivo"});
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return new VerticalContainer(new Component[]{new HorizontalContainer(new Component[]{this.filterLogin, this.filterNome, this.filterEmail, this.filterRamal, this.cbPerfil, this.cbEquipe, this.cbTag, this.cb, btnPesquisar}), this.crud}).setFull();
    }

    private Set<String> getFilterPerfil() {
        HashSet<String> perfil = new HashSet<String>();
        for (UsuarioPerfilEnum upe : this.cbPerfil.getValue()) {
            perfil.add(upe.name());
        }
        return perfil;
    }

    private HorizontalContainer getOptions() {
        Button btnRefresh = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Recarregar grid");
        btnRefresh.addClickListener((ComponentEventListener & Serializable)e -> this.crud.refreshGrid());
        Button btnImportar = UIUtils.createSmallButton((String)"Importar", (VaadinIcon)VaadinIcon.UPLOAD, (String)"Importar novos usu\u00e1rios");
        btnImportar.setEnabled(this.hasPermission("CADASTRO_USUARIO_SAVE"));
        btnImportar.addClickListener((ComponentEventListener & Serializable)e -> {
            Dialog dialog = new Dialog();
            ImportacaoExcel ie = new ImportacaoExcel(this.getColunas());
            ie.getBtnFechar().addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
            ie.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)conf -> {
                if (!ie.isValido()) {
                    this.showNotification("Ha colunas obrigatorias n\u00e3o vinculadas");
                    return;
                }
                dialog.close();
                StringBuilder msg = this.importar(ie);
                this.ns.notify(this.getEu(), "Cria\u00e7\u00e3o de usu\u00e1rios", msg.toString());
                this.showNotification("Finalizado. Resultado est\u00e1 em notifica\u00e7\u00f5es.");
                msg = null;
            });
            dialog.add(new Component[]{ie});
            dialog.open();
        });
        Button btnAdd = UIUtils.createSmallButton((String)"Adicionar", (VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar novo usu\u00e1rio");
        btnAdd.setEnabled(this.hasPermission("CADASTRO_USUARIO_SAVE"));
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> this.openForm(new UsuarioDTO()));
        Button btnEdit = UIUtils.createSmallButton((String)"Editar", (VaadinIcon)VaadinIcon.PENCIL, (String)"Editar usu\u00e1rio");
        btnEdit.setEnabled(this.hasPermission("CADASTRO_USUARIO_SAVE"));
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() != 1) {
                this.showNotification("Selecione 1(um) usu\u00e1rio para editar.");
                return;
            }
            this.openForm((UsuarioDTO)this.crud.getGrid().getSelectedItems().iterator().next());
        });
        Button btnExport = UIUtils.createSmallButton((String)"Exportar", (VaadinIcon)VaadinIcon.TABLE, (String)"Exportar usu\u00e1rios");
        btnExport.addClickListener((ComponentEventListener & Serializable)e -> {
            List lista = this.usuarioRepository.findUsuarios(this.getEu(), this.filterLogin.getValue(), this.filterNome.getValue(), this.filterEmail.getValue(), this.getFilterPerfil(), (Boolean)this.cb.getValue(), (Equipe)this.cbEquipe.getValue(), this.filterRamal.getValue(), this.cbTag.getValue() == null ? null : ((UsuarioTag)this.cbTag.getValue()).getTag(), null);
            String obj = new UsuarioExportacao().export(lista);
            Dialog dialog = new Dialog();
            Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
            btnClose.addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
            Anchor anchor = new Anchor(StorageUtil.getUrlSign((String)obj, (String)"bucket-neosales").getUrl(), new Component[0]);
            anchor.getElement().setAttribute("download", true);
            anchor.setTarget("_blank");
            anchor.setText("Download Exporta\u00e7\u00e3o");
            anchor.setTitle("Baixar arquivo processado");
            anchor.setVisible(!obj.isEmpty());
            dialog.add(new Component[]{new VerticalContainer(new Component[]{anchor, btnClose})});
            dialog.open();
        });
        Button btnCopia = UIUtils.createSmallButton((String)"Copiar", (VaadinIcon)VaadinIcon.PLUS, (String)"Copia permiss\u00f5es e hierarquia do usu\u00e1rio");
        btnCopia.setEnabled(this.hasPermission("CADASTRO_USUARIO_SAVE"));
        btnCopia.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0 && !this.isMaster()) {
                this.showNotification("Selecione um usu\u00e1rio");
                return;
            }
            this.copiar();
        });
        Button bClip = UIUtils.createSmallButton((String)"Anexos", (VaadinIcon)VaadinIcon.PAPERCLIP, (String)"Anexos do Usu\u00e1rio, documentos, holerites etc");
        bClip.setEnabled(this.hasPermission("CLIENTE_ANEXO_VIEW"));
        bClip.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione pelo menos um Usu\u00e1rio");
                return;
            }
            Usuario usuario = (Usuario)this.usuarioService.getById(((UsuarioDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId()).get();
            new UsuarioAnexoView(usuario, this.getEu(), this.usuarioAnexoService);
        });
        Button bSendCredentials = UIUtils.createSmallButton((String)"Reenviar Credenciais");
        bSendCredentials.setVisible(this.isMaster());
        bSendCredentials.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione pelo menos um Usu\u00e1rio");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Reenvio credenciais", "Novas credenciais ser\u00e3o geradas para este usu\u00e1rio. Confirma reenvio?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)canc -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                Usuario usuario = (Usuario)this.usuarioService.getById(((UsuarioDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId()).get();
                this.usuarioService.sendCredentials(this.getEu(), usuario, null, "Reenviando suas credenciais de acesso");
            });
        });
        HorizontalContainer container = new HorizontalContainer(new Component[]{btnRefresh, btnAdd, btnEdit, btnCopia, btnImportar, btnExport, bClip, bSendCredentials});
        return container;
    }

    private List<ImportacaoColunas> getColunas() {
        ArrayList<ImportacaoColunas> colunas = new ArrayList<ImportacaoColunas>();
        colunas.add(new ImportacaoColunas("LOGIN", Boolean.valueOf(true)));
        colunas.add(new ImportacaoColunas("NOME", Boolean.valueOf(true)));
        colunas.add(new ImportacaoColunas("EMAIL", Boolean.valueOf(true)));
        colunas.add(new ImportacaoColunas("EMAIL_ALTERNATIVO", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("CELULAR", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("CELULAR_ALTERNATIVO", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("TAGS", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("PERFIL", Boolean.valueOf(true)));
        colunas.add(new ImportacaoColunas("PERMISSOES", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("CPF", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("RG", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("SALARIO", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("AJUDA_CUSTO", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("VALE_REFEICAO", Boolean.valueOf(false)));
        colunas.add(new ImportacaoColunas("LOGIN MODELO", Boolean.valueOf(true)));
        return colunas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder importar(ImportacaoExcel ie) {
        StringBuilder log = new StringBuilder();
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = ie.getContent();
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheetAt(0);
            for (int r = 0; r <= aba.getLastRowNum(); ++r) {
                Row row = aba.getRow(r);
                if (row == null) continue;
                try {
                    UsuarioPerfilEnum perfil;
                    String login = this.getCellValue(ie, "LOGIN", row).toLowerCase();
                    String nome = this.getCellValue(ie, "NOME", row);
                    String email = this.getCellValue(ie, "EMAIL", row).toLowerCase();
                    String emailAlternativo = this.getCellValue(ie, "EMAIL_ALTERNATIVO", row).toLowerCase();
                    String celular = StringUtil.numbersOnly((String)this.getCellValue(ie, "CELULAR", row));
                    String celularAlternativo = StringUtil.numbersOnly((String)this.getCellValue(ie, "CELULAR_ALTERNATIVO", row));
                    String tags = this.getCellValue(ie, "TAGS", row);
                    String perfilStr = this.getCellValue(ie, "PERFIL", row);
                    String rules = this.getCellValue(ie, "PERMISSOES", row);
                    String loginModelo = this.getCellValue(ie, "LOGIN MODELO", row);
                    String cpf = StringUtil.numbersOnly((String)this.getCellValue(ie, "CPF", row));
                    String rg = this.getCellValue(ie, "RG", row);
                    BigDecimal salario = this.getBigDecimal(ie, "SALARIO", row);
                    BigDecimal ajudaCusto = this.getBigDecimal(ie, "AJUDA_CUSTO", row);
                    BigDecimal valeRefeicao = this.getBigDecimal(ie, "VALE_REFEICAO", row);
                    if (login.toLowerCase().equals("login") || nome.toLowerCase().equals("nome") || email.toLowerCase().equals("email") || login.isBlank() || nome.isBlank() || email.isBlank()) continue;
                    try {
                        perfil = UsuarioPerfilEnum.valueOf((String)perfilStr);
                    }
                    catch (Exception e) {
                        throw new Exception("Perfil n\u00e3o encontrado");
                    }
                    UsuarioDTO dto = new UsuarioDTO();
                    dto.setAtivo(Boolean.TRUE);
                    dto.setCelular(celular);
                    dto.setCelularAlternativo(celularAlternativo);
                    dto.setDataCadastro(LocalDate.now());
                    dto.setEmail(email);
                    dto.setEmailAlternativo(emailAlternativo);
                    dto.setLogin(login);
                    dto.setMaster(Boolean.valueOf(false));
                    dto.setNome(nome);
                    dto.setPerfil(perfil);
                    dto.setTags(StringUtil.normalizeTags((String)tags));
                    dto.setSaldo(BigDecimal.ZERO);
                    dto.setRules(rules);
                    dto.setAjudaCusto(ajudaCusto);
                    dto.setCpf(cpf);
                    dto.setRg(rg);
                    dto.setValeRefeicao(valeRefeicao);
                    dto.setSalario(salario);
                    Usuario uModelo = this.usuarioService.getByLogin(StringUtil.normalize((String)loginModelo));
                    if (uModelo == null) {
                        throw new Exception("Login modelo nao encontrado");
                    }
                    Optional euModelo = this.eus.getByUsuarioAndEstrutura(uModelo, this.getEstrutura());
                    this.usuarioService.saveAndCreate(dto, this.getEstrutura(), euModelo.isPresent() ? (EstruturaUsuario)euModelo.get() : null);
                    log.append("Linha: ").append(r + 1).append("login: ").append(login).append("Criado com sucesso");
                    continue;
                }
                catch (Exception ex) {
                    log.append("Linha: ").append(r + 1).append(ex.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.showNotification("Erro ao processar arquivo: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is = null;
            }
            catch (Exception exception) {}
        }
        return log;
    }

    private BigDecimal getBigDecimal(ImportacaoExcel ie, String columName, Row row) {
        String v = this.getCellValue(ie, columName, row);
        if (v.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(v);
    }

    private String getCellValue(ImportacaoExcel ie, String columName, Row row) {
        if (ie.getPositionByName(columName) == null) {
            return "";
        }
        if (row.getCell(ie.getPositionByName(columName).intValue()) == null) {
            return "";
        }
        Cell cell = row.getCell(ie.getPositionByName(columName).intValue());
        DataFormatter dataFormatter = new DataFormatter();
        return dataFormatter.formatCellValue(cell);
    }

    private void openForm(UsuarioDTO user) {
        UsuarioFormView form = new UsuarioFormView(user, this.getEu(), this.usuarioService, this.eus, this.usuarioTagService, this.usuarioHierarquiaService, this.whatsappContaService);
        form.open();
        form.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!e.isOpened()) {
                this.crud.refreshGrid();
            }
        });
    }

    private void copiar() {
        Dialog dialog = new Dialog();
        ComboBox userModel = new ComboBox("Modelo", (Collection)this.usuarioHierarquiaService.getHierarquiaDto(this.getEu(), Boolean.TRUE));
        userModel.setItemLabelGenerator(HierarquiaDTO::getLoginAndPerfil);
        MultiComboBox cbTipo = new MultiComboBox("O que copiar?", (Object[])UsuarioCopyTypeEnum.values());
        cbTipo.setItemLabelGenerator(Enum::name);
        Button confirmar = UIUtils.createSmallButton((String)"Confirmar", (VaadinIcon)VaadinIcon.CHECK, (String)"");
        confirmar.addClickListener((ComponentEventListener & Serializable)confirmado -> {
            if (userModel.getValue() == null) {
                this.showNotification("Selecione um modelo para copiar");
                return;
            }
            if (cbTipo.getValue() == null || cbTipo.getValue().size() <= 0) {
                this.showNotification("Selecione algo para copiar");
                return;
            }
            EstruturaUsuario euModelo = this.eus.getById(((HierarquiaDTO)userModel.getValue()).getEstruturaUsuarioId());
            if (!this.isMaster()) {
                Usuario usuario = (Usuario)this.usuarioService.getById(((UsuarioDTO)this.crud.getGrid().getSelectedItems().iterator().next()).getId()).get();
                EstruturaUsuario eu = (EstruturaUsuario)this.usuarioService.getByUsuarioAndEstrutura(usuario, this.getEstrutura()).get();
                this.copyService.copiar(this.getEu(), eu, euModelo, cbTipo.getValue());
            } else {
                Set lista = !this.crud.getGrid().getSelectedItems().isEmpty() ? this.crud.getGrid().getSelectedItems() : new HashSet(this.usuarioRepository.findUsuarios(this.getEu(), this.filterLogin.getValue(), this.filterNome.getValue(), this.filterEmail.getValue(), this.getFilterPerfil(), (Boolean)this.cb.getValue(), (Equipe)this.cbEquipe.getValue(), this.filterRamal.getValue(), this.cbTag.getValue() == null ? null : ((UsuarioTag)this.cbTag.getValue()).getTag(), null));
                ConfirmationDialog cd = new ConfirmationDialog("Copiar", "Aten\u00e7\u00e3o, voc\u00ea est\u00e1 prestes a copiar dados do usu\u00e1rio modelo para " + lista.size() + " usu\u00e1rios. Tem certeza disso?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)can -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.copyList(euModelo, lista, cbTipo.getValue());
                    cd.close();
                });
            }
            dialog.close();
        });
        Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        close.addClickListener((ComponentEventListener & Serializable)clx -> dialog.close());
        dialog.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createSmallSpan((String)"Copiar informa\u00e7\u00f5es do usu\u00e1rio:"), userModel, cbTipo, new FooterContainer(new Component[]{close, confirmar})})});
        dialog.open();
    }

    private void copyList(EstruturaUsuario euModelo, Set<UsuarioDTO> lista, Set<UsuarioCopyTypeEnum> tipo) {
        for (UsuarioDTO d : lista) {
            Usuario usuario = (Usuario)this.usuarioService.getById(d.getId()).get();
            EstruturaUsuario eu = (EstruturaUsuario)this.usuarioService.getByUsuarioAndEstrutura(usuario, this.getEstrutura()).get();
            this.copyService.copiar(this.getEu(), eu, euModelo, tipo);
        }
    }
}

