/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.util;

import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.receivers.FileBuffer;
import com.vaadin.flow.component.upload.receivers.FileData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TempFileMultiBuffer
implements Receiver {
    private static final long serialVersionUID = 1L;
    private final Map<String, FileBuffer> buffers = new LinkedHashMap();

    public OutputStream receiveUpload(String filename, String mimeType) {
        FileBuffer buf = new FileBuffer();
        this.buffers.put(filename, buf);
        return buf.receiveUpload(filename, mimeType);
    }

    public Set<String> getFiles() {
        return this.buffers.keySet();
    }

    public String getFileName() {
        if (this.getFiles() == null || this.getFiles().isEmpty()) {
            return null;
        }
        return (String)this.getFiles().iterator().next();
    }

    public InputStream getInputStream() {
        if (this.getFiles() == null || this.getFiles().isEmpty()) {
            return null;
        }
        return this.getInputStream((String)this.getFiles().iterator().next());
    }

    public InputStream getInputStream(String fileName) {
        File file = this.getFileData(fileName).getFile();
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getMimeType() {
        if (this.getFiles() == null || this.getFiles().isEmpty()) {
            return null;
        }
        return this.getMimeType((String)this.getFiles().iterator().next());
    }

    public String getMimeType(String fileName) {
        return ((FileBuffer)this.buffers.get(fileName)).getFileData().getMimeType();
    }

    public FileData getFileData(String fileName) {
        return ((FileBuffer)this.buffers.get(fileName)).getFileData();
    }

    public void clear() {
        for (FileBuffer fb : this.buffers.values()) {
            File f = fb.getFileData().getFile();
            if (f == null || !f.exists()) continue;
            f.delete();
        }
        this.buffers.clear();
    }
}

