/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.vivo.service;

import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.vivo.model.VivoProspectBiDTO;
import br.com.system.app.features.vivo.model.VivoProspectBiEstrutura;
import br.com.system.app.features.vivo.model.VivoProspectBiExport;
import br.com.system.app.features.vivo.model.VivoProspectBiFile;
import br.com.system.app.features.vivo.model.VivoProspectBiItens;
import br.com.system.app.features.vivo.repository.VivoProspectBiEstruturaRepository;
import br.com.system.app.features.vivo.repository.VivoProspectBiExportRepository;
import br.com.system.app.features.vivo.repository.VivoProspectBiFileRepository;
import br.com.system.app.features.vivo.repository.VivoProspectBiItensRepository;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VivoProspectBiService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private VivoProspectBiExportRepository exportRepository;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private VivoProspectBiEstruturaRepository biRepository;
    @Autowired
    private VivoProspectBiFileRepository fileRepository;
    @Autowired
    private VivoProspectBiItensRepository biItensRepository;
    @Autowired
    private UsuarioHierarquiaService ehs;

    public List<VivoProspectBiFile> getFileByHierarquia(EstruturaUsuario eu, Pageable pageable) {
        Set h = this.ehs.getHierarquia(eu);
        return this.fileRepository.findByEstruturaUsuarioIdIn(h, pageable);
    }

    public long countFileByHierarquia(EstruturaUsuario eu) {
        Set h = this.ehs.getHierarquia(eu);
        return this.fileRepository.countByEstruturaUsuarioIdIn(h);
    }

    public void deleteFile(VivoProspectBiFile file) {
        this.fileRepository.delete((Object)file);
    }

    @Transactional
    public void deleteItens(VivoProspectBiFile file) {
        this.biItensRepository.deleteByVivoProspectBiFile(file);
    }

    public List<VivoProspectBiItens> getItens(VivoProspectBiFile file, Integer flag) {
        return this.biItensRepository.findByVivoProspectBiFileAndFlagDisp(file, flag);
    }

    public VivoProspectBiEstrutura getByCpfCnpj(Estrutura e, String cpfCnpj) {
        return this.biRepository.findByEstruturaAndCpfCnpj(e, cpfCnpj);
    }

    public Integer getLimit(EstruturaUsuario eu) {
        Integer limiteTotal = this.configurationsService.get(ConfigurationEnum.LIMITE_PROSPECT_BI).getIntValue();
        int processados = 0;
        List procs = this.exportRepository.findByDataHoraBetweenAndEstruturaUsuarioEstrutura(LocalDate.now().atStartOfDay(), DateTimeUtil.getEndOfDay(), eu.getEstrutura());
        for (VivoProspectBiExport proc : procs) {
            processados += proc.getQuantidade().intValue();
        }
        return limiteTotal - processados;
    }

    public String gerarArquivo(EstruturaUsuario eu, List<VivoProspectBiDTO> lista) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("DOCUMENTO;").append("CEP;").append("NUMERO;").append("TELEFONE").append("\n");
            for (VivoProspectBiDTO m : lista) {
                String n = StringUtil.numbersOnly((String)m.getNumero());
                if (n.isEmpty()) {
                    n = "SN";
                }
                sb.append(m.getCnpj()).append(";").append(m.getCep()).append(";").append(n).append(";").append(TelefoneUtil.getRandomPhone((boolean)true)).append("\n");
            }
            VivoProspectBiExport vb = new VivoProspectBiExport();
            vb.setDataHora(LocalDateTime.now());
            vb.setEstruturaUsuario(eu);
            vb.setQuantidade(Integer.valueOf(lista.size()));
            this.exportRepository.save((Object)vb);
            return StorageUtil.uploadObjectInputStream((String)(HashUtil.getUUI() + ".csv"), (InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gerar arquivo+ " + e.getMessage());
        }
    }
}

