/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppControle;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppControleRepository;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsAppControleService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppControleRepository whatsAppControleRepository;

    public List<WhatsAppControle> getNotificada(EstruturaUsuario euAtendente, boolean nova) {
        return this.whatsAppControleRepository.findByWhatsappMensagemWhatsappAtendimentoAtendenteAndNovaAndNotificada(euAtendente, nova, false);
    }

    public List<WhatsAppControle> getNova(Long waId) {
        return this.whatsAppControleRepository.findByWhatsappMensagemWhatsappAtendimentoIdAndNova(waId, true);
    }

    public List<WhatsAppControle> getAll(WhatsAppAtendimento wa) {
        if (wa == null) {
            return new ArrayList<WhatsAppControle>();
        }
        return this.whatsAppControleRepository.findByWhatsappMensagemWhatsappAtendimento(wa);
    }

    @Transactional
    public void deleteByAtendimento(WhatsAppAtendimento wa) {
        this.whatsAppControleRepository.deleteByWhatsappMensagemWhatsappAtendimento(wa);
    }

    @Transactional
    public void delete(WhatsAppControle c) {
        try {
            this.whatsAppControleRepository.delete((Object)c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void gravarAlteracao(WhatsAppMensagem wm, WhatsAppStatusEnum status) {
        if (WhatsAppStatusEnum.getStatusPosition((WhatsAppStatusEnum)wm.getStatus()) >= WhatsAppStatusEnum.getStatusPosition((WhatsAppStatusEnum)status)) {
            return;
        }
        this.gravar(wm, status, Boolean.FALSE);
    }

    public void gravarNova(WhatsAppMensagem wm, WhatsAppStatusEnum status) {
        this.gravar(wm, status, Boolean.TRUE);
    }

    public WhatsAppControle save(WhatsAppControle wc) {
        return (WhatsAppControle)this.whatsAppControleRepository.save((Object)wc);
    }

    private void gravar(WhatsAppMensagem wm, WhatsAppStatusEnum status, Boolean nova) {
        try {
            WhatsAppControle c = new WhatsAppControle();
            c.setDataHora(LocalDateTime.now());
            c.setNova(nova);
            c.setStatus(status);
            c.setWhatsappMensagem(wm);
            c.setNotificada(Boolean.valueOf(false));
            this.whatsAppControleRepository.save((Object)c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

