/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppFuncaoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppImportacaoThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppHaveService haveService;
    @Autowired
    private WhatsAppContaService whatsAppContaService;
    @Autowired
    private ClienteService clienteService;

    public void importar(HashMap<String, Integer> colunas, InputStream conteudo, String nomeArquivo, EstruturaUsuario eu) {
        Thread.currentThread().setName("asyncDefault-whatsapp-importacao");
        StringBuilder log = new StringBuilder();
        XSSFWorkbook xls = null;
        try {
            xls = new XSSFWorkbook(conteudo);
            Sheet aba = xls.getSheetAt(0);
            for (int r = 1; r <= aba.getLastRowNum(); ++r) {
                Row row = aba.getRow(r);
                if (row == null) continue;
                String cnpj = StringUtil.normalizeCpfCnpj((String)this.getCellValue(colunas, "CPF-CNPJ", row));
                cnpj = StringUtil.numbersOnly((String)cnpj);
                try {
                    if (!cnpj.isEmpty() && !ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                        log.append(cnpj).append(" inv\u00e1lido ").append("<BR>");
                        continue;
                    }
                    String numero = this.getCellValue(colunas, "NUMERO", row);
                    WhatsAppHave have = this.haveService.getHave(numero);
                    if (have == null || !have.getHave().booleanValue()) {
                        log.append(numero).append(" inv\u00e1lido ").append("<BR>");
                        continue;
                    }
                    String nome = this.getCellValue(colunas, "NOME", row);
                    String funcao = this.getCellValue(colunas, "FUNCAO", row);
                    String email = this.getCellValue(colunas, "EMAIL", row);
                    WhatsApp w = this.whatsAppService.getByNumeroAndEstrutura(have.getNumeroWhats(), eu.getEstrutura());
                    if (w == null) {
                        w = new WhatsApp();
                        w.setCnpjEscolhido(cnpj);
                        w.setCpfCnpj(cnpj);
                        w.setCriador(eu);
                        w.setDataHoraCriacao(LocalDateTime.now());
                        w.setEmail(email == null || email.isEmpty() ? null : email);
                        w.setEtapa(WhatsAppEtapaEnum.FECHADO);
                        try {
                            w.setFuncao(WhatsAppFuncaoEnum.valueOf((String)funcao));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        w.setNome(nome);
                        w.setNumero(have.getNumeroWhats());
                        w.setUltimoAtendente(eu);
                        if (eu.getUsuario().getWhatsappConta() != null) {
                            w.setWhatsappConta(eu.getUsuario().getWhatsappConta());
                        } else {
                            List contas = this.whatsAppContaService.getContaByEstruturaAtendimento(eu.getEstrutura());
                            if (contas.isEmpty()) {
                                log.append("N\u00e3o encontrei conta atendimento v\u00e1lida<BR>");
                            } else {
                                w.setWhatsappConta((WhatsAppConta)contas.get(0));
                            }
                        }
                        this.whatsAppService.save(w);
                        log.append(numero).append(" Cadastrado com sucesso<BR>");
                    } else {
                        log.append(numero).append(" Cadastrado j\u00e1 existe<BR>");
                    }
                    Cliente cliente = this.clienteService.getAndCreateCliente(eu, cnpj, new ClienteContato[]{new ClienteContato(TipoContatoEnum.EMAIL, email), new ClienteContato(TipoContatoEnum.TELEFONE, have.getNumero())});
                    cliente.setCadastroWhatsapp(Boolean.TRUE);
                    this.clienteService.salvar(cliente, eu);
                }
                catch (Exception eItem) {
                    log.append("NUMERO: ").append(cnpj).append(" ERRO: ").append(eItem.getMessage()).append("<BR>");
                }
                row = null;
            }
        }
        catch (IOException e) {
            throw new BusinessException("Erro ao processar arquivo: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                colunas.clear();
                conteudo.close();
                xls = null;
                colunas = null;
                conteudo = null;
            }
            catch (Exception exception) {}
        }
        if (log.toString().isEmpty()) {
            log.append("Arquivo sem conte\u00fado v\u00e1lido");
        }
        this.notificacoesService.notify(eu, "Importando clientes do arquivo " + nomeArquivo, log.toString());
        log = null;
    }

    private String getCellValue(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = this.getPosition(colunas, columName, row);
        if (posicao < 0) {
            return "";
        }
        Cell cell = row.getCell(posicao.intValue());
        return ExcellUtil.getValueString((Cell)cell).trim();
    }

    private Integer getPosition(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = -1;
        for (Map.Entry<String, Integer> entry : colunas.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(columName)) continue;
            posicao = entry.getValue();
            break;
        }
        if (posicao == null || posicao < 0) {
            return -1;
        }
        if (row.getCell(posicao.intValue()) == null) {
            return -1;
        }
        return posicao;
    }
}

