/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppSessao;
import br.com.system.app.features.whatsapp.repository.WhatsAppRepository;
import br.com.system.app.features.whatsapp.repository.WhatsAppSessaoRepository;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsAppService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppRepository whatsAppRepository;
    @Autowired
    private CreditosService creditosService;
    @Autowired
    private WhatsAppSessaoRepository whatsAppSessaoRepository;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;

    public WhatsApp getAndCreate(String numero, EstruturaUsuario master, WhatsAppConta conta, WhatsAppEtapaEnum etapa, String nome) {
        WhatsApp ws = this.getAtendimentoByNumero(conta, numero);
        if (ws == null) {
            return this.criar(numero, master, conta, etapa, nome);
        }
        ws.setNome(nome);
        ws.setEtapa(etapa);
        return this.save(ws);
    }

    public WhatsApp criar(String numero, EstruturaUsuario master, WhatsAppConta conta) {
        return this.criar(numero, master, conta, null);
    }

    public WhatsApp criar(String numero, EstruturaUsuario atendente, WhatsAppConta conta, WhatsAppEtapaEnum etapa) {
        return this.criar(numero, atendente, conta, etapa, "");
    }

    public WhatsApp criar(String numero, EstruturaUsuario atendente, WhatsAppConta conta, WhatsAppEtapaEnum etapa, String nome) {
        if (conta == null || !conta.isAtivo()) {
            throw new BusinessException("Conta inexistente ou inativa");
        }
        if (etapa == null) {
            etapa = WhatsAppEtapaEnum.INICIAL;
        }
        WhatsApp w = new WhatsApp();
        w.setNome(nome);
        w.setCriador(atendente);
        w.setEtapa(etapa);
        w.setDataHoraCriacao(LocalDateTime.now());
        w.setWhatsappConta(conta);
        w.setNumero(numero);
        w.setUltimoAtendente(atendente);
        return this.save(w);
    }

    public WhatsApp getById(Long id) {
        return this.whatsAppRepository.findById((Object)id).orElse(null);
    }

    public Set<String> getCnpjs(Estrutura estrutura) {
        return this.whatsAppRepository.findCnpjs(estrutura.getId());
    }

    public List<WhatsApp> getByDataCadastro(Estrutura estrutura, LocalDateTime dIni, LocalDateTime dFim) {
        return this.whatsAppRepository.findByWhatsappContaEstruturaAndDataHoraCriacaoBetween(estrutura, dIni, dFim);
    }

    public WhatsApp getAtendimentoByNumero(WhatsAppConta wc, String numero) {
        return this.getByNumeroAndConta(numero, wc);
    }

    public WhatsApp getByNumeroAndConta(String numero, WhatsAppConta conta) {
        return this.whatsAppRepository.findByNumeroAndWhatsappConta(numero, conta);
    }

    public WhatsApp getByNumeroAndEstrutura(String numero, Estrutura e) {
        return this.whatsAppRepository.findFirstByNumeroAndWhatsappContaEstruturaAndWhatsappContaAtendimento(numero, e, true);
    }

    public List<WhatsApp> getByCpfCnpj(String cpfCnpj, Estrutura estrutura) {
        if (cpfCnpj == null) {
            return null;
        }
        List lista = this.whatsAppRepository.findByCpfCnpjAndEstrutura(cpfCnpj, estrutura.getId());
        if (lista.size() <= 0) {
            return null;
        }
        return lista;
    }

    public List<WhatsApp> getByNomeContato(Estrutura estrutura, String nome) {
        return this.whatsAppRepository.findByWhatsappContaEstruturaAndNomeContains(estrutura, nome);
    }

    public List<WhatsApp> getByAtendente(EstruturaUsuario atendente) {
        return this.whatsAppRepository.findByUltimoAtendenteAndEtapaOrderByIdDesc(atendente, WhatsAppEtapaEnum.ATENDENTE);
    }

    public List<WhatsApp> getByAtendenteFechado(EstruturaUsuario atendente) {
        return this.whatsAppRepository.findByUltimoAtendenteAndEtapaOrderByIdDesc(atendente, WhatsAppEtapaEnum.FECHADO);
    }

    public List<WhatsApp> getByWhatsAppConta(WhatsAppConta conta) {
        return this.whatsAppRepository.findByWhatsappConta(conta);
    }

    public WhatsApp save(WhatsApp w) {
        if (w.getEmail() != null && !ValidationUtil.isValidEmail((String)w.getEmail())) {
            throw new BusinessException("E-mail inv\u00e1lido");
        }
        if (w.getCpfCnpj() != null && !w.getCpfCnpj().isEmpty()) {
            HashSet<String> lista = new HashSet<String>();
            for (String cnpj : w.getCpfCnpj().split(",")) {
                if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) continue;
                lista.add(cnpj);
            }
            w.setCpfCnpj(StringUtils.join(lista, (String)","));
        }
        return (WhatsApp)this.whatsAppRepository.save((Object)w);
    }

    public WhatsAppSessao setOnline(EstruturaUsuario eu) {
        WhatsAppAtendente atendente = this.whatsAppAtendenteService.getAtendente(eu);
        if (atendente == null) {
            return null;
        }
        WhatsAppSessao o = new WhatsAppSessao();
        o.setDataHoraEntrou(LocalDateTime.now());
        o.setEstruturaUsuario(eu);
        this.whatsAppAtendenteService.setOnline(atendente);
        return (WhatsAppSessao)this.whatsAppSessaoRepository.save((Object)o);
    }

    public void setOffline(WhatsAppSessao o) {
        if (o == null) {
            return;
        }
        o.setDataHoraSaiu(LocalDateTime.now());
        this.whatsAppAtendenteService.setOffline(o.getEstruturaUsuario());
        this.whatsAppSessaoRepository.save((Object)o);
    }

    @Transactional
    public void delete(WhatsApp whatsapp) {
        this.whatsAppRepository.delete((Object)whatsapp);
    }

    public List<WhatsApp> getAll() {
        return this.whatsAppRepository.findAll();
    }

    public void cobrarConsultaWhats(String numero, EstruturaUsuario eu, BigDecimal valor) {
        this.creditosService.transacionar(eu, "Consulta Whats " + numero, valor.negate());
    }
}

