/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service.bot;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.WhatsAppSetoresService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppBotAliancasul1452
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService sendService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppSetoresService whatsAppSetoresService;
    @Autowired
    private EstruturaUsuarioService eus;

    public void botComercial(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w.setUltimoAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(523L)).getEstruturaUsuario());
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        wa.setAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(523L)).getEstruturaUsuario());
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    public void botDefault(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            w.setUltimoAtendente(master);
            wa.setAtendente(master);
            if (w.getNome() == null) {
                String content = "Ol\u00e1, a Alian\u00e7a sul agradece seu contato.\nSou a Ali, Assistente Virtual da Alian\u00e7a e vou dar sequ\u00eancia no seu atendimento.\nQual seu nome Completo para realizarmos um cadastro?";
                this.sendService.sendMessageText(wa, master, content);
                w.setEtapa(WhatsAppEtapaEnum.NOME);
                wa.setEtapa(WhatsAppEtapaEnum.NOME);
            } else {
                String msg = "Ol\u00e1 " + w.getNome() + " tudo bem? Sou a Ali, Assistente Virtual da Alian\u00e7a e vou dar sequ\u00eancia no seu atendimento.\n";
                this.sendService.sendMessageText(wa, master, msg);
                w.setEtapa(WhatsAppEtapaEnum.GERAL);
                wa.setEtapa(WhatsAppEtapaEnum.GERAL);
                this.opcoes(wa, master, "Como posso te ajudar hoje?");
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.NOME)) {
            String nome = resposta;
            if (nome.split(" ").length < 2) {
                this.sendService.sendMessageText(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida, informe seu nome completo, com NOME e SOBRENOME");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setEtapa(WhatsAppEtapaEnum.GERAL);
            w.setNome(nome);
            wa.setEtapa(WhatsAppEtapaEnum.GERAL);
            this.opcoes(wa, master, "Obrigado! Como posso te ajudar hoje?");
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.GERAL)) {
            if (resposta.contains("Quero Me candidatar!")) {
                w.setEtapa(WhatsAppEtapaEnum.VAGA);
                wa.setEtapa(WhatsAppEtapaEnum.VAGA);
                this.sendService.sendMessageText(wa, master, "Ah, legal! E como voc\u00ea soube da nossa vaga?");
            } else if (resposta.contains("Estou em Integra\u00e7\u00e3o")) {
                w.setEtapa(WhatsAppEtapaEnum.ESTOU_EM_PROCESSO);
                wa.setEtapa(WhatsAppEtapaEnum.ESTOU_EM_PROCESSO);
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("DIURNO");
                buttons.add("NOTURNO");
                this.sendService.sendButton(wa, master, "Ah, legal! E para qual turno voc\u00ea se candidatou?", "", buttons);
            } else if (resposta.contains("Departamento Pessoal")) {
                w.setEtapa(WhatsAppEtapaEnum.DEPTO_PESSOAL);
                wa.setEtapa(WhatsAppEtapaEnum.DEPTO_PESSOAL);
                this.sendService.sendMessageText(wa, master, "Ah, legal! E qual sua d\u00favida?");
            } else if (resposta.contains("Outros assuntos")) {
                w.setEtapa(WhatsAppEtapaEnum.OUTROS_ASSUNTOS);
                wa.setEtapa(WhatsAppEtapaEnum.OUTROS_ASSUNTOS);
                this.sendService.sendMessageText(wa, master, "Ah, legal! E qual sua d\u00favida?");
            } else {
                this.opcoes(wa, master, "N\u00e3o entendi, escolha uma op\u00e7\u00e3o.");
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.VAGA)) {
            this.sendService.sendMessageText(wa, master, "Entendi! Voc\u00ea tem algum outro telefone para contato? Se tiver por favor informe agora.");
            w.setEtapa(WhatsAppEtapaEnum.SEGUNDO_TELEFONE);
            wa.setEtapa(WhatsAppEtapaEnum.SEGUNDO_TELEFONE);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.SEGUNDO_TELEFONE)) {
            this.sendService.sendMessageText(wa, master, "Obrigado pela informa\u00e7\u00e3o! Vou direcionar voc\u00ea para o respons\u00e1vel");
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            List atendentesOnline = this.whatsAppAtendenteService.getAtendentesOnline(wa.getWhatsapp().getWhatsappConta().getEstrutura(), Boolean.TRUE);
            if (!atendentesOnline.isEmpty()) {
                wa.setAtendente(((WhatsAppAtendente)atendentesOnline.get(0)).getEstruturaUsuario());
                w.setUltimoAtendente(((WhatsAppAtendente)atendentesOnline.get(0)).getEstruturaUsuario());
            } else {
                List at = this.whatsAppAtendenteService.getAtendentes(wa.getWhatsapp().getWhatsappConta().getEstrutura(), Boolean.TRUE);
                if (!at.isEmpty()) {
                    wa.setAtendente(((WhatsAppAtendente)at.get(0)).getEstruturaUsuario());
                    w.setUltimoAtendente(((WhatsAppAtendente)at.get(0)).getEstruturaUsuario());
                } else {
                    wa.setAtendente(master);
                    w.setUltimoAtendente(master);
                }
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.ESTOU_EM_PROCESSO)) {
            if (resposta.equals("DIURNO")) {
                w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
                w.setUltimoAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(632L)).getEstruturaUsuario());
                wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
                wa.setAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(632L)).getEstruturaUsuario());
                this.sendService.sendMessageText(wa, master, "Obrigado pela informa\u00e7\u00e3o! Vou direcionar voc\u00ea para o respons\u00e1vel");
            } else if (resposta.equals("NOTURNO")) {
                w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
                w.setUltimoAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(632L)).getEstruturaUsuario());
                wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
                wa.setAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(632L)).getEstruturaUsuario());
                this.sendService.sendMessageText(wa, master, "Obrigado pela informa\u00e7\u00e3o! Vou direcionar voc\u00ea para o respons\u00e1vel");
            } else {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("DIURNO");
                buttons.add("NOTURNO");
                this.sendService.sendButton(wa, master, "Informe para qual turno voc\u00ea se candidatou?", "", buttons);
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.DEPTO_PESSOAL)) {
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(452L)).getEstruturaUsuario());
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            wa.setAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(452L)).getEstruturaUsuario());
            this.sendService.sendMessageText(wa, master, "Obrigado pela informa\u00e7\u00e3o! Vou direcionar voc\u00ea para o respons\u00e1vel");
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.OUTROS_ASSUNTOS)) {
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(114L)).getEstruturaUsuario());
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            wa.setAtendente(this.whatsAppAtendenteService.getById(Long.valueOf(114L)).getEstruturaUsuario());
            this.sendService.sendMessageText(wa, master, "Obrigado pela informa\u00e7\u00e3o! Vou direcionar voc\u00ea para o respons\u00e1vel");
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    private void opcoes(WhatsAppAtendimento wa, EstruturaUsuario master, String msg) {
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("Quero Me candidatar!");
        buttons.add("Estou em Integra\u00e7\u00e3o");
        buttons.add("Departamento Pessoal");
        this.sendService.sendButton(wa, master, msg, "", buttons);
        buttons = new ArrayList();
        buttons.add("Outros assuntos");
        this.sendService.sendButton(wa, master, "Para outros assuntos, clique abaixo", "", buttons);
    }

    public void comercial(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            this.sendService.sendMessageText(wa, master, "Bem-vindo ao Agente Claro Televendas.");
            this.whatsAppSetoresService.sendSetor(w, wa, master, "Selecione a Op\u00e7\u00e3o desejada");
            w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.ESCOLHA_TIPO)) {
            WhatsAppSetores setor = this.whatsAppSetoresService.checkSetor(master.getEstrutura(), resposta);
            if (setor == null) {
                this.whatsAppSetoresService.sendSetor(w, wa, master, "Op\u00e7\u00e3o inv\u00e1lida, selecione o setor");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            EstruturaUsuario eu = this.whatsAppAtendenteService.getAtendenteOnline(w, master, setor);
            if (eu.getUsuario().isMaster()) {
                eu = this.whatsAppAtendenteService.getAtendenteOnline(w, master);
            }
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(eu);
            wa.setAtendente(eu);
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setFechado(false);
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            this.sendService.sendMessageText(wa, master, "Ok, em breve voc\u00ea ser\u00e1 atendido.");
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    public void lista(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            this.sendService.sendMessageText(wa, master, "Ol\u00e1,\n\nSeja bem vindo ao canal de atendimento Claro Empresas.\nPara darmos in\u00edcio ao seu atendimento, solicito algumas informa\u00e7\u00f5es:");
            this.sendService.sendMessageText(wa, master, "Informe seu Nome.");
            w.setEtapa(WhatsAppEtapaEnum.NOME);
            wa.setEtapa(WhatsAppEtapaEnum.NOME);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.NOME)) {
            String nome = resposta;
            if (nome.isEmpty()) {
                this.sendService.sendMessageText(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida, informe seu nome");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
            w.setNome(nome);
            wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
            this.sendService.sendMessageText(wa, master, "Informe o CNPJ que deseja atendimento.");
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.CPF_CNPJ)) {
            if (!ValidationUtil.isValidCnpjAndCpf((String)(resposta = StringUtil.numbersOnly((String)resposta)))) {
                this.sendService.sendMessageText(wa, master, "CPF-CNPJ inv\u00e1lido");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            w.setCpfCnpj(resposta);
            w.setCnpjEscolhido(resposta);
            wa.setCnpj(resposta);
            wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_TIPO);
            ArrayList<String> lista = new ArrayList<String>();
            lista.add("Novos Produtos");
            lista.add("Renova\u00e7\u00e3o Contratual");
            lista.add("Segunda via de Fatura");
            lista.add("Contesta\u00e7\u00e3o de Fatura");
            lista.add("Troca de Chip");
            lista.add("Transf. de Titularidade");
            lista.add("Atendimento Presencial");
            lista.add("Outros");
            this.sendService.sendListMenu(wa, master, lista);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.ESCOLHA_TIPO)) {
            EstruturaUsuario eu = this.eus.getById(Long.valueOf(56858L));
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            w.setUltimoAtendente(eu);
            wa.setAtendente(eu);
            wa.setEscolhaTipo(resposta);
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setFechado(false);
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            this.sendService.sendMessageText(wa, master, "Em breve um dos nossos especialistas entrar\u00e1 em contato");
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }
}

