/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.security;

import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import br.com.system.app.security.CustomUserDetails;
import br.com.system.app.security.Roles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    private final EstruturaUsuarioService eus;
    private final UsuarioRepository userRepository;
    private final EstruturaComplementoService ecs;

    public UserDetailsServiceImpl(UsuarioRepository userRepository, EstruturaUsuarioService eus, EstruturaComplementoService ecs) {
        this.userRepository = userRepository;
        this.ecs = ecs;
        this.eus = eus;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Usuario user = this.userRepository.findByLogin(username);
        if (user == null) {
            throw new UsernameNotFoundException("No user present with username: " + username);
        }
        EstruturaUsuario eu = this.eus.getFirstByUsuario(user);
        if (eu == null) {
            throw new UsernameNotFoundException("Usu\u00e1rio nao encontrado");
        }
        EstruturaComplemento ec = this.ecs.getComplementos(eu.getEstrutura());
        if (!ec.getCobrancaAssinatura().getAtivo().booleanValue() && !user.isMaster()) {
            throw new UsernameNotFoundException("Assinatura Inativa");
        }
        if (ec.getCobrancaAssinatura().isBloqueado() && !user.isMaster()) {
            throw new UsernameNotFoundException("Assinatura Bloqueada");
        }
        List gas = this.getAuthorities(user, eu);
        return new CustomUserDetails(eu.getUsuario().getEmail(), user.getNome(), user.getLogin(), user.getSenha(), Boolean.valueOf(true), (Collection)gas, eu);
    }

    private List<GrantedAuthority> getAuthorities(Usuario user, EstruturaUsuario eu) {
        ArrayList<GrantedAuthority> gas = new ArrayList<GrantedAuthority>();
        if (user.isMaster()) {
            gas.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_MASTER"));
            for (String role : new Roles().getAll()) {
                gas.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + role));
            }
        } else if (eu.getRules() != null) {
            String[] arrRules;
            for (String role : arrRules = eu.getRules().split(",")) {
                if (role.trim().isEmpty()) continue;
                gas.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + role.trim()));
            }
        }
        gas.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_HOME"));
        return gas;
    }
}

