/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static InputStream workbookToInputStream(Workbook workbook) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            workbook.write((OutputStream)out);
            workbook.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static String toString(InputStream is) throws IOException {
        return InputStreamUtil.toString((InputStream)is, (Charset)Charset.defaultCharset());
    }

    public static String toString(InputStream is, Charset charSet) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(is, charSet);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(InputStreamUtil.class).error("Erro ao ler InputStream", (Throwable)e);
        }
        return sb.toString();
    }

    public static File toFile(InputStream is, String prefixo, String sufixo) throws Exception {
        File somethingFile;
        try {
            somethingFile = new File("/tmp/" + prefixo + "." + sufixo);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)somethingFile);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            is.close();
        }
        return somethingFile;
    }

    public static File toFile(InputStream is, String filename) throws Exception {
        String[] arr = filename.split("\\.");
        if (arr.length != 2) {
            throw new Exception("Erro no nome do arquivo");
        }
        return InputStreamUtil.toFile((InputStream)is, (String)arr[0], (String)arr[1]);
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream buffer;
        try {
            int nRead;
            buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            is.close();
        }
        return buffer.toByteArray();
    }
}

