/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class ReflectionUtil {
    private static final String OBJECT_TREE_PATH_SEPARATOR = "\\.";

    public static Object getTreeChildObject(Object parentObj, String treePath) {
        if (parentObj == null) {
            return null;
        }
        if (treePath == null || treePath.isEmpty()) {
            return null;
        }
        String[] treeRoute = treePath.split(OBJECT_TREE_PATH_SEPARATOR);
        Object navObj = parentObj;
        for (String treeNode : treeRoute) {
            try {
                Field navField = navObj.getClass().getDeclaredField(treeNode);
                navField.setAccessible(true);
                navObj = navField.get(navObj);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                return null;
            }
        }
        return navObj;
    }

    public static boolean isPrimitiveArray(Object obj) {
        return obj instanceof boolean[] || obj instanceof double[] || obj instanceof byte[] || obj instanceof short[] || obj instanceof char[] || obj instanceof int[] || obj instanceof long[] || obj instanceof float[];
    }

    public static Object[] toObjectArray(Object objArray) {
        int lenght = Array.getLength(objArray);
        Object[] ret = new Object[lenght];
        for (int i = 0; i < lenght; ++i) {
            ret[i] = Array.get(objArray, i);
        }
        return ret;
    }
}

