/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.regex;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RegexUtil {
    public static final String REGEX_NON_NUMERS_AND_LETTERS_WITH_SPACE = "[^A-Za-z0-9 ]";
    public static final String ANYTHING = "[\\s\\S]+";
    public static final String IN_QUOTES = "(\\'[^\\']*\\')";
    public static final String IN_DOUBLE_QUOTES = "(\\'[^\\']*\\')";
    public static final String LETTERS_ONLY = "\\pL+";
    public static final String CURRENCY_BR = "R\\$";
    public static final String NEW_LINE = "\\r\\n|\\r|\\n";
    public static final String WORD_ONLY = "([A-Za-z])\\w+";
    public static final String NON_DIGIT = "[^0-9]+";
    public static final String WHITESPACES = "\\s+";
    public static final String NUMBERS = "([0-9]+)";
    public static final String BRACKETS = "(\\]|\\[)+";
    public static final String TELEFONE_CELULAR = "(\\+?[0-9]{2})?(\\(?[0-9]{2}\\)?)?([9]{1})?([1-9]{1})([0-9]{3})-?([0-9]{4})";
    public static final String TELEFONE_FIXO = "(\\+?[0-9]{2})?(\\(?[0-9]{2}\\)?)?([2-6]{1})([0-9]{3})-?([0-9]{4})$";
    public static final String TELEFONE = "^(\\d{2}[-\\s]?)?((\\(?0?[123456789][1-9]\\)?[-\\s]?(9[4-9]{1}[\\d]{3})[-\\s]?([\\d]{4}))|(\\(?0?[1-9][1-9]\\)?)[-\\s]?(([2-7]){1}[\\d]{3})[-\\s]?([\\d]{4})|(\\(?0?[3-9][1-9]\\)?)[-\\s]?([89]{1}[\\d]{3})[-\\s]?([\\d]{4})|(\\b((0[3859]00[-\\s]?)(\\d{3}[-\\s]?(\\d{4}|\\d{3})|(\\d{5}[-\\s]?\\d{2})))\\b)|(\\b(([3]003|[4]00[34])[-\\s]?\\d{4})\\b))$";
    public static final String TELEFONE_WITH_BRACKETS = "(\\(?\\d{2}\\)?\\s)?(\\d{4,5}\\-\\d{4})";
    public static final String TELEFONE_INTERNACIONAL = "^((\\+|00)?[1-9][0-9])(\\s|-)?((\\d{5}(\\s|-)?(\\d{4}|\\d{3}))|((\\d{1})?(\\d{3})(\\s|-)?(\\d{3})(\\s|-)?(\\d{3}|\\d{4}))|((\\d{4})(\\s|-)?(\\d{4})))$";
    public static final String DATA = "\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b";
    public static final String DATA_AA = "\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|))\\b";
    public static final String DATA_DIA_MES = "^((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012]))$";
    public static final String DATA_MES_ANO = "^((0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))$|(\\b([A-Z]{3}\\/\\d{4})\\b)|\\b(0[1-9]|1[0-2])[1|2]\\d{3}\\b";
    public static final String DATA_HORARIO = "\\b(([01][0-9]|2[0-3])[:])?(([0-5][0-9])|(0[0-9])|(([0-9])?[0-9][0-9]))[:]+([0-5][0-9])\\b";
    public static final String DATA_HORARIO_CORRETO = "\\b(([01][0-9]|2[0-3])[:])(([0-5][0-9])|(0[0-9])|(([0-9])?[0-9][0-9]))[:]+([0-5][0-9])\\b";
    public static final String DATA_MINUTOS = "\\b(\\d+[,.]\\d)\\b";
    public static final String DATA_HORARIO2 = "\\b(((([0-9]+[h][0-5][0-9][m])|([0-9]+)[m]))?(([0-5][0-9])[s]))\\b";
    public static final String VALOR_DECIMAL = "([+-]?([^0]\\d+|\\d{1,3}(\\.\\d{3})*),(\\d+))";
    public static final String VALOR_INTEIRO = "^([+-]?(\\d+|\\d{1,3}(\\.\\d{3})*))$";
    public static final String EMAIL = "\\b[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z]{2,20}\\b";
    public static final String UNIDADE_DADOS = "(?i)\\b(((\\d)(gb)\\s?)?(\\d)+((mb)\\s?|)[,.]?(\\d)*\\s?(b|kb|mb|mbps|kbps|gb|mega)|(\\d+|\\d{1,3}(\\.\\d{3}))[,]+(\\d{3}|\\d{5})\\s?(b|kb|mb|mbps|kbps|gb|mega)?)\\b";
    public static final String CEP = "\\b\\d{5} ?[-/] ?\\d{3}\\b";
    public static final String CPF = "(\\b([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})\\b)";
    public static final String CNPJ = "(\\b([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})\\b)";
    public static final String CPF_CNPJ = "(\\b([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})\\b)|(\\b([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})\\b)";
    public static final String SPECIAL_CHARS = "[^\\pL\\pN\\pM ]";
    public static final String WHOLE_MATCH = "\\\\$0";

    public static Pattern compileRegexes(String ... regexes) {
        return RegexUtil.compileRegexes(Arrays.asList(regexes));
    }

    public static Pattern compileRegexes(Collection<String> regexes) {
        String patternStr = RegexUtil.compileRegexesAsString(regexes);
        return Pattern.compile(patternStr, 2);
    }

    public static String compileRegexesAsString(String ... regexes) {
        return RegexUtil.compileRegexesAsString(Arrays.asList(regexes));
    }

    public static String compileRegexesAsString(Collection<String> regexes) {
        if (regexes == null || regexes.isEmpty()) {
            return null;
        }
        StringBuilder patternStr = new StringBuilder();
        for (String regex : regexes) {
            patternStr.append(regex).append('|');
        }
        patternStr.deleteCharAt(patternStr.length() - 1);
        return patternStr.toString();
    }

    public static String atomicGroup(String prefix, String regex, String suffix) {
        return prefix + "(?>" + regex + ")" + suffix;
    }

    public static String positiveLookbehind(String prefix, String regex, String suffix) {
        return prefix + "(?<=" + regex + ")" + suffix;
    }
}

