/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.features.layout.UIUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import java.io.Serializable;

public class ProgressBar
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final String TEXT_DEFAULT = "Processando, por favor aguarde...";
    private final Div div = new Div();
    private final com.vaadin.flow.component.progressbar.ProgressBar progressBar = new com.vaadin.flow.component.progressbar.ProgressBar();
    Button btnClose = UIUtils.createCloseButton((String)"Fechar");

    public ProgressBar() {
        this.create(Boolean.valueOf(false));
    }

    public ProgressBar(Boolean close) {
        this.create(close);
    }

    private void create(Boolean close) {
        this.progressBar.setIndeterminate(true);
        this.div.setText("Processando, por favor aguarde...");
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        this.btnClose.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Fechar", "Se voce fechar, o processo PODE ser interrompido. Confirma?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                this.close();
            });
        });
        this.add(new Component[]{this.div});
        this.add(new Component[]{this.progressBar});
        if (close.booleanValue()) {
            this.getFooter().add(new Component[]{this.btnClose});
        }
    }

    public ProgressBar setText(String texto) {
        this.div.setText(texto);
        return this;
    }

    public void close() {
        super.close();
        this.div.setText("Processando, por favor aguarde...");
    }
}

