/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.bots.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.analisefatura.model.BotTypeEnum;
import br.com.system.app.features.bots.model.BotProcess;
import br.com.system.app.features.bots.repository.BotProcessRepository;
import br.com.system.app.features.bots.service.BotStartThreads;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;

@Route(value="oportunidade-start", layout=MainLayout.class)
@PageTitle(value="Oportunidade Start")
@RolesAllowed(value={"MASTER"})
public class BotStartView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final BotStartThreads botStart;
    private final BotProcessRepository repository;
    private Grid<BotProcess> grid;
    private RadioButtonGroup<BotTypeEnum> rb;

    public BotStartView(BotStartThreads botStart, BotProcessRepository repository) {
        this.botStart = botStart;
        this.repository = repository;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Nao tem permiss\u00e3o");
        }
    }

    private void povoa() {
        this.grid.setItems((Collection)this.repository.findByProcessType((BotTypeEnum)this.rb.getValue()));
    }

    private Component createContent() {
        FlexBoxLayout mainContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]).setSpacingM();
        mainContainer.setWidthFull();
        mainContainer.setHeightFull();
        this.grid = new Grid(BotProcess.class);
        this.grid.setWidthFull();
        this.grid.setHeightFull();
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)c -> {
            Button stop = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STOP, (String)"Stop process");
            stop.addClickListener((ComponentEventListener & Serializable)e -> {
                ConfirmationDialog cd = new ConfirmationDialog("Stop", "Abortar esse processo?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.repository.delete(c);
                    this.povoa();
                    cd.close();
                });
            });
            return new HorizontalContainer(new Component[]{stop});
        })).setFlexGrow(0).setWidth("80px").setHeader("Stop");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)t -> String.valueOf(t.getId()))).setFlexGrow(0).setWidth("150px").setHeader("ID");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)t -> t.getProcessName())).setFlexGrow(0).setWidth("250px").setHeader("Nome");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHoraCriacao()))).setFlexGrow(0).setWidth("180px").setHeader("Cria\u00e7\u00e3o");
        this.rb = new RadioButtonGroup();
        this.rb.setItems((Object[])BotTypeEnum.values());
        this.rb.setValue((Object)BotTypeEnum.BOTFAT);
        this.rb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.povoa());
        NumberField qtos = new NumberField("Quantos");
        qtos.setStep(1.0);
        qtos.setMin(1.0);
        qtos.setMax(20.0);
        qtos.setValue((Number)1.0);
        NumberField id = new NumberField("Id");
        Button start = UIUtils.createSmallButton((String)"Start", (VaadinIcon)VaadinIcon.PLAY);
        start.setWidth("80px");
        start.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Iniciar processo", "Confirma start do processo?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirm -> {
                this.botStart.start((BotTypeEnum)this.rb.getValue(), ((Double)qtos.getValue()).intValue(), id.getValue() == null ? null : Long.valueOf(((Double)id.getValue()).longValue()));
                cd.close();
                this.showNotification("Iniciado com sucesso");
                this.povoa();
            });
        });
        mainContainer.add(new Component[]{this.rb, new HorizontalContainer(new Component[]{qtos, id, start}), this.grid});
        this.povoa();
        return mainContainer;
    }
}

