/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteLog;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.model.ClienteTagsActionEnum;
import br.com.system.app.features.cliente.repository.ClienteLogRepository;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pessoa.model.Pessoa;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.model.OperadoraEnum;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteLogService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteLogRepository clienteLogRepository;

    public List<ClienteLog> getLog(Cliente cliente) {
        return this.clienteLogRepository.findByClienteOrderByIdDesc(cliente);
    }

    public ClienteLog salvar(Cliente cliente, EstruturaUsuario eu, String log) {
        ClienteLog cLog = new ClienteLog();
        cLog.setCliente(cliente);
        cLog.setDataHora(LocalDateTime.now());
        cLog.setEstruturaUsuario(eu);
        cLog.setLog(log);
        return this.salvar(cLog);
    }

    public ClienteLog salvar(ClienteLog cl) {
        if (cl.getLog() == null || cl.getLog().isBlank()) {
            return null;
        }
        if (cl.getEstruturaUsuario() == null) {
            throw new BusinessException("EU obrigat\u00f3rio");
        }
        if (cl.getCliente() == null) {
            throw new BusinessException("Cliente \u00e9 obrigatorio");
        }
        if (cl.getDataHora() == null) {
            cl.setDataHora(LocalDateTime.now());
        }
        return (ClienteLog)this.clienteLogRepository.save((Object)cl);
    }

    public void log(Cliente novo, Cliente gravado, EstruturaUsuario eu) {
        StringBuilder log = new StringBuilder();
        if (gravado != null) {
            boolean existe;
            boolean existe2;
            if (!this.getValue(novo.getNome()).equals(this.getValue(gravado.getNome()))) {
                log.append("Nome alterado de ").append(gravado.getNome()).append(" para ").append(novo.getNome()).append("\n");
            }
            if (!this.getValue(novo.getCpfCnpj()).equals(this.getValue(gravado.getCpfCnpj()))) {
                log.append("CpfCnpj alterado de ").append(this.getValue(gravado.getCpfCnpj())).append(" para ").append(this.getValue(novo.getCpfCnpj())).append("\n");
            }
            if (!this.getValue(novo.getObservacao()).equals(this.getValue(gravado.getObservacao()))) {
                log.append("Observacao alterado de ").append(this.getValue(gravado.getObservacao())).append(" para ").append(this.getValue(novo.getObservacao())).append("\n");
            }
            if (!this.getValue(novo.getCep()).equals(this.getValue(gravado.getCep()))) {
                log.append("Cep alterado de ").append(this.getValue(gravado.getCep())).append(" para ").append(this.getValue(novo.getCep())).append("\n");
            }
            if (!this.getValue(novo.getLogradouro()).equals(this.getValue(gravado.getLogradouro()))) {
                log.append("Logradouro alterado de ").append(this.getValue(gravado.getLogradouro())).append(" para ").append(this.getValue(novo.getLogradouro())).append("\n");
            }
            if (!this.getValue(novo.getNumero()).equals(this.getValue(gravado.getNumero()))) {
                log.append("Numero alterado de ").append(this.getValue(gravado.getNumero())).append(" para ").append(this.getValue(novo.getNumero())).append("\n");
            }
            if (!this.getValue(novo.getComplemento()).equals(this.getValue(gravado.getComplemento()))) {
                log.append("Complemento alterado de ").append(this.getValue(gravado.getComplemento())).append(" para ").append(this.getValue(novo.getComplemento())).append("\n");
            }
            if (!this.getValue(novo.getBairro()).equals(this.getValue(gravado.getBairro()))) {
                log.append("Bairro alterado de ").append(this.getValue(gravado.getBairro())).append(" para ").append(this.getValue(novo.getBairro())).append("\n");
            }
            if (!this.getValue(novo.getCidade()).equals(this.getValue(gravado.getCidade()))) {
                log.append("Cidade alterado de ").append(this.getValue(gravado.getCidade())).append(" para ").append(this.getValue(novo.getCidade())).append("\n");
            }
            if (!this.getValue(novo.getEstado()).equals(this.getValue(gravado.getEstado()))) {
                log.append("Estado alterado de ").append(this.getValue(gravado.getEstado())).append(" para ").append(this.getValue(novo.getEstado())).append("\n");
            }
            if (!this.getValue(novo.getLoginContaOnline()).equals(this.getValue(gravado.getLoginContaOnline()))) {
                log.append("Login ContaOnline alterado de ").append(this.getValue(gravado.getLoginContaOnline())).append(" para ").append(this.getValue(novo.getLoginContaOnline())).append("\n");
            }
            if (!this.getValue(novo.getSenhaContaOnline()).equals(this.getValue(gravado.getSenhaContaOnline()))) {
                log.append("Senha ContaOnline alterado de ").append(this.getValue(gravado.getSenhaContaOnline())).append(" para ").append(this.getValue(novo.getSenhaContaOnline())).append("\n");
            }
            if (eu.getEstrutura().getEstruturaTipo().getOperadora().equals((Object)OperadoraEnum.VIVO) && !this.getValue(novo.getCpfContaOnline()).equals(this.getValue(gravado.getCpfContaOnline()))) {
                log.append("CPF ContaOnline alterado de ").append(this.getValue(gravado.getCpfContaOnline())).append(" para ").append(this.getValue(novo.getCpfContaOnline())).append("\n");
            }
            if (!this.getValue(novo.getLoginGestor()).equals(this.getValue(gravado.getLoginGestor()))) {
                log.append("Login Gestor alterado de ").append(this.getValue(gravado.getLoginGestor())).append(" para ").append(this.getValue(novo.getLoginGestor())).append("\n");
            }
            if (!this.getValue(novo.getSenhaGestor()).equals(this.getValue(gravado.getSenhaGestor()))) {
                log.append("Senha Gestor alterado de ").append(this.getValue(gravado.getSenhaGestor())).append(" para ").append(this.getValue(novo.getSenhaGestor())).append("\n");
            }
            if (novo.getClienteClassificacao() == null && gravado.getClienteClassificacao() != null || novo.getClienteClassificacao() != null && gravado.getClienteClassificacao() == null || novo.getClienteClassificacao() != null && gravado.getClienteClassificacao() != null && novo.getClienteClassificacao().equals(gravado.getClienteClassificacao())) {
                log.append("Classificacao alterado de ").append(gravado.getClienteClassificacao() == null ? "" : gravado.getClienteClassificacao().getNome()).append(" para ").append(novo.getClienteClassificacao() == null ? "" : novo.getClienteClassificacao().getNome()).append("\n");
            }
            if (EstruturaTipoEnum.getById((Long)eu.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.CLARO) && (novo.getTempoMedio() != null || gravado.getTempoMedio() == null || novo.getTempoMedio() != null && gravado.getTempoMedio() == null || novo.getTempoMedio() != null && gravado.getTempoMedio() != null && novo.getTempoMedio().equals(gravado.getTempoMedio()))) {
                log.append("Tempo M\u00e9dio alterado de ").append(gravado.getTempoMedio()).append(" para ").append(novo.getTempoMedio()).append("\n");
            }
            for (String tag : novo.getTags().split(",")) {
                existe2 = false;
                for (String tagG : gravado.getTags().split(",")) {
                    if (!tagG.equals(tag)) continue;
                    existe2 = true;
                    break;
                }
                if (existe2) continue;
                log.append("Tag ").append(tag).append(" inserida\n");
            }
            for (String tagG : gravado.getTags().split(",")) {
                existe2 = false;
                for (String tag : novo.getTags().split(",")) {
                    if (!tag.equals(tagG)) continue;
                    existe2 = true;
                    break;
                }
                if (existe2) continue;
                log.append("Tag ").append(tagG).append(" Excluida\n");
            }
            for (ClienteResponsavel cc : novo.getClienteResponsavel()) {
                existe = false;
                for (ClienteResponsavel ccAtual : gravado.getClienteResponsavel()) {
                    if (!cc.equals((Object)ccAtual)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Respons\u00e1vel ").append(cc.getEstruturaUsuario().getUsuario().getLogin()).append(" inserido\n");
            }
            for (ClienteResponsavel cAtual : gravado.getClienteResponsavel()) {
                existe = false;
                for (ClienteResponsavel cc : novo.getClienteResponsavel()) {
                    if (!cAtual.equals((Object)cc)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Respons\u00e1vel ").append(cAtual.getEstruturaUsuario().getUsuario().getLogin()).append(" exclu\u00eddo\n");
            }
            for (ClienteContato cc : novo.getClienteContato()) {
                existe = false;
                for (ClienteContato ccG : gravado.getClienteContato()) {
                    if (!cc.equals((Object)ccG)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Contato ").append(cc.getTipo().name()).append(" ").append(cc.getValor()).append(" inserido\n");
            }
            for (ClienteContato cAtual : gravado.getClienteContato()) {
                existe = false;
                for (ClienteContato cc : novo.getClienteContato()) {
                    if (!cc.equals((Object)cAtual)) continue;
                    if (!cc.getVerificado().equals((Object)cAtual.getVerificado())) {
                        log.append("Contato ").append(cAtual.getTipo().name()).append(" alterado de ").append(cAtual.getVerificado()).append(" para ").append(cc.getVerificado());
                    }
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Contato ").append(cAtual.getTipo().name()).append(" ").append(cAtual.getValor()).append(" exclu\u00eddo\n");
            }
            for (Pessoa p : novo.getPessoas()) {
                existe = false;
                for (Pessoa pAtual : gravado.getPessoas()) {
                    if (!pAtual.equals((Object)p)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Pessoa ").append(p.getNome()).append(" inserido\n");
            }
            for (Pessoa patual : gravado.getPessoas()) {
                existe = false;
                for (Pessoa p : novo.getPessoas()) {
                    if (!patual.equals((Object)p)) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                log.append("Pessoa ").append(patual.getNome()).append(" exclu\u00eddo\n");
            }
        } else {
            log.append("Inserindo Cliente");
        }
        ClienteLog cLog = new ClienteLog();
        cLog.setCliente(novo);
        cLog.setDataHora(LocalDateTime.now());
        cLog.setEstruturaUsuario(eu);
        cLog.setLog(log.toString());
        this.salvar(cLog);
        log = null;
    }

    private String getValue(String inf) {
        if (inf == null) {
            return "";
        }
        return inf.trim();
    }

    @Async
    @Transactional
    public void logTag(Set<ClienteDTO> clientes, ClienteTagsActionEnum action, EstruturaUsuario eu, String tags) {
        this.clienteLogRepository.tagLog(clientes, action, eu, tags);
    }

    @Transactional
    public void deleteByCliente(Cliente cliente) {
        this.clienteLogRepository.deleteByCliente(cliente);
    }
}

