/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cep.dto.CepResult;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaAssinaturaLog;
import br.com.system.app.features.cobranca.model.CobrancaTipoEnum;
import br.com.system.app.features.cobranca.model.ProprietarioEnum;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaLogService;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.estrutura.dto.EstruturaDadosDTO;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaDadosService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.whatsapp.util.WhatsAppUtil;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class CobrancaAssinaturaFormView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private CepService cepService;
    @Autowired
    private CobrancaAssinaturaService cas;
    @Autowired
    private CobrancaAssinaturaLogService cobrancaAssinaturaLogService;
    @Autowired
    private EstruturaDadosService estruturaDadosService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    private final Image aviso = new Image("images/error.png", "3CX");
    private ComboBox<CobrancaTipoEnum> cbTipo;
    private RadioButtonGroup<String> rbAtivo;
    private TextField txtCpfCnpj;
    private TextField txtNome;
    private TextField txtCep;
    private TextField txtLogradouro;
    private TextField txtNumero;
    private TextField txtCompl;
    private TextField txtBairro;
    private TextField txtCidade;
    private TextField txtEstado;
    private TextField txtCelular;
    private TextField txtCelular2;
    private TextArea txtObservacao;
    private ListField listaEmail;
    private DatePicker dpDesconto;
    private DatePicker dpProximoVencimento;
    private NumberField valorMensal;
    private NumberField valorDesconto;
    private NumberField periodoCobranca;
    private NumberField nroUsuarios;
    private NumberField nroLogins;
    private NumberField nroWhats;
    private NumberField nroRamais;
    private NumberField nroLeads;
    private TextField dataCriacao;
    private TextField vendedor;
    private Grid<CobrancaAssinaturaLog> grid;
    private CobrancaAssinatura ca;
    private CobrancaAssinatura caOriginal;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void abrir(CobrancaAssinatura cobrancaAssinatura) {
        try {
            this.setWidth("690px");
            this.ca = cobrancaAssinatura;
            try {
                this.caOriginal = this.ca.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeAll();
            if (this.ca == null) {
                UIUtils.showNotification((String)"Ca n\u00e3o pode ser nulo");
                return;
            }
            this.vendedor = new TextField("Vendedor");
            if (this.ca.getVendedor() != null) {
                this.vendedor.setValue(this.ca.getVendedor());
            }
            this.dataCriacao = new TextField("Data Cria\u00e7\u00e3o");
            this.dataCriacao.setReadOnly(true);
            if (this.ca.getDataCriacao() == null) {
                this.dataCriacao.setVisible(false);
            } else {
                this.dataCriacao.setValue(this.ca.getDataCriacao().toString());
            }
            this.cbTipo = new ComboBox("Tipo Cobranca", (Object[])CobrancaTipoEnum.values());
            this.cbTipo.setItemLabelGenerator(Enum::name);
            this.cbTipo.setValue(this.ca.getTipo() == null ? null : this.ca.getTipo());
            this.rbAtivo = new RadioButtonGroup();
            this.rbAtivo.setItems((Object[])new String[]{"Ativo", "Inativo"});
            if (this.ca.getId() == null || this.ca.getAtivo().booleanValue()) {
                this.rbAtivo.setValue((Object)"Ativo");
            } else {
                this.rbAtivo.setValue((Object)"Inativo");
            }
            this.dpDesconto = new DatePicker();
            this.dpDesconto.setLabel("Desconto At\u00e9");
            this.dpDesconto.setValue(this.ca.getDescontoAte() == null ? null : this.ca.getDescontoAte());
            this.dpDesconto.setLocale(UIUtils.getLocale());
            this.dpProximoVencimento = new DatePicker();
            this.dpProximoVencimento.setLabel("Pr\u00f3xima Cobran\u00e7a");
            this.dpProximoVencimento.setValue(this.ca.getProximoVencimento() == null ? LocalDate.now().plusMonths(1L) : this.ca.getProximoVencimento());
            this.dpProximoVencimento.setLocale(UIUtils.getLocale());
            this.dpProximoVencimento.setWidth("150px");
            this.valorMensal = new NumberField("Valor Mensal");
            this.valorMensal.setValue(this.ca.getValorMensal() == null ? null : Double.valueOf(this.ca.getValorMensal().doubleValue()));
            this.valorDesconto = new NumberField("Valor Desconto");
            this.valorDesconto.setValue(this.ca.getValorDesconto() == null ? null : Double.valueOf(this.ca.getValorDesconto().doubleValue()));
            this.periodoCobranca = new NumberField("Cobrar a cada(Meses)");
            this.periodoCobranca.setStep(1.0);
            this.periodoCobranca.setValue((Number)(this.ca.getPeriodoCobrancaMeses() == null ? 1.0 : this.ca.getPeriodoCobrancaMeses().doubleValue()));
            this.periodoCobranca.setWidth("170px");
            this.listaEmail = new ListField(ListFieldTypeEnum.EMAIL, "Lista E-mail");
            this.listaEmail.setWidthFull();
            this.listaEmail.setValue(this.ca.getListaEmail());
            this.txtCpfCnpj = new TextField("CPF-CNPJ");
            this.txtCpfCnpj.setValue(this.ca.getCpfCnpj() == null ? "" : this.ca.getCpfCnpj());
            this.txtCpfCnpj.setWidth("160px");
            this.txtNome = new TextField("Nome");
            this.txtNome.setValue(this.ca.getNome() == null ? "" : this.ca.getNome());
            this.txtNome.setWidth("250px");
            this.txtCep = new TextField("Cep");
            this.txtCep.setValue(this.ca.getCep() == null ? "" : this.ca.getCep());
            this.txtCep.setWidth("90px");
            this.txtLogradouro = new TextField("Logradouro");
            this.txtLogradouro.setValue(this.ca.getLogradouro() == null ? "" : this.ca.getLogradouro());
            this.txtLogradouro.setWidth("200px");
            this.txtNumero = new TextField("N\u00famero");
            this.txtNumero.setValue(this.ca.getNumero() == null ? "" : this.ca.getNumero());
            this.txtNumero.setWidth("90px");
            this.txtCompl = new TextField("Complemento");
            this.txtCompl.setValue(this.ca.getCompl() == null ? "" : this.ca.getCompl());
            this.txtBairro = new TextField("Bairro");
            this.txtBairro.setValue(this.ca.getBairro() == null ? "" : this.ca.getBairro());
            this.txtCidade = new TextField("Cidade");
            this.txtCidade.setValue(this.ca.getCidade() == null ? "" : this.ca.getCidade());
            this.txtCidade.setReadOnly(true);
            this.txtEstado = new TextField("Estado");
            this.txtEstado.setReadOnly(true);
            this.txtEstado.setValue(this.ca.getEstado() == null ? "" : this.ca.getEstado());
            this.txtCelular = new TextField("Celular");
            this.txtCelular.setValue(this.ca.getCelular() == null ? "" : this.ca.getCelular());
            this.txtCelular2 = new TextField("Celular2");
            this.txtCelular2.setValue(this.ca.getCelular2() == null ? "" : this.ca.getCelular2());
            this.txtObservacao = new TextArea("Observa\u00e7\u00e3o");
            this.txtObservacao.setWidthFull();
            this.txtObservacao.setMinHeight("150px");
            this.nroUsuarios = new NumberField("Usu\u00e1rios");
            this.nroUsuarios.setValue((Number)(this.ca.getNroUsuarios() == null ? 0.0 : this.ca.getNroUsuarios().doubleValue()));
            this.nroLogins = new NumberField("Logins Operadora");
            this.nroLogins.setValue((Number)(this.ca.getNroLoginsOperadora() == null ? 0.0 : this.ca.getNroLoginsOperadora().doubleValue()));
            this.nroWhats = new NumberField("Whatsapp");
            this.nroWhats.setValue((Number)(this.ca.getNroWhatsapp() == null ? 0.0 : this.ca.getNroWhatsapp().doubleValue()));
            this.nroRamais = new NumberField("Ramais");
            this.nroRamais.setValue((Number)(this.ca.getNroRamais() == null ? 0.0 : this.ca.getNroRamais().doubleValue()));
            this.nroLeads = new NumberField("Leads");
            this.nroLeads.setValue((Number)(this.ca.getNroLeads() == null ? 0.0 : this.ca.getNroLeads().doubleValue()));
            this.grid = new Grid();
            this.grid.setWidth("100%");
            this.grid.setHeight("400px");
            this.grid.addItemDoubleClickListener((ComponentEventListener & Serializable)e -> InformationDialog.show((String)"Movimenta\u00e7\u00e3o", (String)((CobrancaAssinaturaLog)e.getItem()).getMovimentacao()));
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getLogin()))).setHeader("Nome").setFlexGrow(0).setWidth("200px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getDataHora().format(FormatDate.DATETIME_BR.toDTF())))).setHeader("Data/Hora").setFlexGrow(0).setWidth("150px");
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getMovimentacao()))).setHeader("Movimenta\u00e7\u00e3o").setFlexGrow(0).setWidth("350px");
            this.txtCpfCnpj.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                String cc = StringUtil.numbersOnly((String)((String)e.getValue()));
                if (!cc.equals(e.getValue())) {
                    this.txtCpfCnpj.setValue(cc);
                }
                if (cc.length() != 11 && cc.length() != 14) {
                    return;
                }
                if (!ValidationUtil.isValidCnpjAndCpf((String)cc)) {
                    UIUtils.showNotification((String)"CPF-CNPJ Inv\u00e1lido");
                    return;
                }
                this.setMailing(cc);
            });
            this.txtCep.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                String cc = StringUtil.numbersOnly((String)((String)e.getValue()));
                if (!cc.equals(e.getValue())) {
                    this.txtCep.setValue(cc);
                }
                if (cc.length() == 8) {
                    this.setCep(cc);
                }
            });
            Button btnClose = UIUtils.createSmallButton((String)"Fechar");
            btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
            Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
            if (this.ca.getProprietario() == null && this.ca.getId() == null) {
                this.ca.setProprietario(this.getUsuario().getLogin().contains("ricardo") ? ProprietarioEnum.RICARDO : ProprietarioEnum.JERIAM);
                btnSalvar.setEnabled(true);
            } else if (this.getUsuario().getLogin().contains("ricardo") && this.ca.getProprietario().equals((Object)ProprietarioEnum.RICARDO) || this.getUsuario().getLogin().contains("jeriam") && this.ca.getProprietario().equals((Object)ProprietarioEnum.JERIAM)) {
                btnSalvar.setEnabled(true);
            } else {
                btnSalvar.setEnabled(false);
            }
            btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
                String erro = this.getErro();
                if (!erro.isEmpty()) {
                    UIUtils.showNotification((String)erro);
                    return;
                }
                if (this.ca.getId() == null && this.cas.getByCpfCnpj(this.txtCpfCnpj.getValue()) != null) {
                    ConfirmationDialog cd = new ConfirmationDialog("Ja existe", "Este CNPJ j\u00e1 est\u00e1 cadastrado, deseja criar uma nova assinatura?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        cd.close();
                        this.salvar();
                    });
                } else {
                    this.salvar();
                }
            });
            Anchor whats = new Anchor();
            whats.setVisible(TelefoneUtil.isValid((String)this.txtCelular.getValue()));
            whats.getElement().setProperty("innerHTML", "<span>" + WhatsAppUtil.getLink((String)this.txtCelular.getValue(), (String)"") + "</span>");
            Anchor whats2 = new Anchor();
            whats2.setVisible(TelefoneUtil.isValid((String)this.txtCelular2.getValue()));
            whats2.getElement().setProperty("innerHTML", "<span>" + WhatsAppUtil.getLink((String)this.txtCelular2.getValue(), (String)"") + "</span>");
            TextField dataPrimeiroPagamento = new TextField("Primeiro Pagamento");
            dataPrimeiroPagamento.setValue(this.ca.getPrimeiroPagamento() == null ? "" : this.ca.getPrimeiroPagamento().format(DateTimeFormatter.ISO_DATE));
            VerticalContainer v = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
            v.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Cobran\u00e7a Assinatura")});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.dataCriacao, dataPrimeiroPagamento})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbTipo, this.rbAtivo, this.aviso})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCpfCnpj, this.txtNome})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCep, this.txtLogradouro, this.txtNumero})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCompl, this.txtBairro})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCidade, this.txtEstado})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCelular, whats})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.txtCelular2, whats2})});
            v.add(new com.vaadin.flow.component.Component[]{this.listaEmail, this.vendedor});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.dpProximoVencimento, this.valorMensal, this.periodoCobranca})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.valorDesconto, this.dpDesconto})});
            v.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.nroUsuarios, this.nroLogins, this.nroRamais, this.nroWhats, this.nroLeads})});
            v.add(new com.vaadin.flow.component.Component[]{this.getDados()});
            v.add(new com.vaadin.flow.component.Component[]{this.txtObservacao});
            v.add(new com.vaadin.flow.component.Component[]{this.grid});
            v.add(new com.vaadin.flow.component.Component[]{new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSalvar})});
            this.add(new com.vaadin.flow.component.Component[]{v});
            this.open();
            this.povoaLog();
        }
        catch (Exception e2) {
            UIUtils.showError((String)("Erro ao abrir " + e2.getMessage()));
        }
    }

    private VerticalContainer getDados() {
        VerticalContainer cDados = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.aviso.setVisible(false);
        if (this.ca.getId() == null) {
            return cDados;
        }
        List estruturas = this.estruturaComplementoService.getByCobrancaAssinatura(this.ca);
        cDados.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Estruturas ligadas a essa assinatura")});
        Integer ramais = 0;
        Integer leads = 0;
        Integer usuarios = 0;
        Integer logins = 0;
        Integer whats = 0;
        for (EstruturaComplemento compl : estruturas) {
            HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
            EstruturaDadosDTO dados = this.estruturaDadosService.getDados(compl.getEstrutura());
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Estrutura", compl.getEstrutura().getNome())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Tipo", compl.getEstrutura().getEstruturaTipo().getNome())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Situa\u00e7\u00e3o", compl.getEstrutura().isAtivo() ? "ATIVA" : "INATIVA")});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Leads Di\u00e1rias", compl.getLimiteDiarioOportunidade() == null ? "0" : compl.getLimiteDiarioOportunidade().toString())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Usu\u00e1rios Ativos", dados.getQtUsuarioAtivos().toString())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Logins Ativos", dados.getQtLogins().toString())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Ramais Ativos", dados.getQtRamais().toString())});
            h.add(new com.vaadin.flow.component.Component[]{this.getField("Contas Whats", dados.getQtWhats().toString())});
            ramais = ramais + dados.getQtRamais();
            whats = whats + dados.getQtWhats();
            leads = leads + (compl.getLimiteDiarioOportunidade() == null ? 0 : compl.getLimiteDiarioOportunidade());
            usuarios = dados.getQtUsuarioAtivos();
            logins = logins + dados.getQtLogins();
            cDados.add(new com.vaadin.flow.component.Component[]{h});
        }
        if (!(ramais.equals(this.caOriginal.getNroRamais()) && whats.equals(this.caOriginal.getNroWhatsapp()) && leads.equals(this.caOriginal.getNroLeads()) && usuarios.equals(this.caOriginal.getNroUsuarios()) && logins.equals(this.caOriginal.getNroLoginsOperadora()))) {
            this.aviso.setVisible(true);
        }
        return cDados;
    }

    private void povoaLog() {
        if (this.ca.getId() == null) {
            return;
        }
        List logs = this.cobrancaAssinaturaLogService.getByAssinatura(this.ca);
        this.grid.setItems((Collection)logs);
    }

    private String getErro() {
        Object erro = "";
        if (!ValidationUtil.isValidCnpjAndCpf((String)this.txtCpfCnpj.getValue())) {
            erro = (String)erro + "CPF-CNPJ Inv\u00e1lido\n";
        }
        if (this.txtNome.getValue() == null || this.txtNome.getValue().isEmpty()) {
            erro = (String)erro + "Nome inv\u00e1lido\n";
        }
        if (this.txtCep.getValue() == null || this.txtCep.getValue().length() != 8 || this.txtCidade.getValue() == null || this.txtCidade.getValue().isEmpty() || this.txtEstado.getValue() == null || this.txtEstado.getValue().isEmpty()) {
            erro = (String)erro + "Cep Inv\u00e1lido\n";
        }
        if (this.txtLogradouro.getValue() == null || this.txtLogradouro.getValue().isEmpty()) {
            erro = (String)erro + "Logradouro Inv\u00e1lido\n";
        }
        if (this.txtBairro.getValue() == null || this.txtBairro.getValue().isEmpty()) {
            erro = (String)erro + "Bairro Inv\u00e1lido\n";
        }
        if (this.cbTipo.getValue() == null) {
            erro = (String)erro + "Selecione o tipo de Cobran\u00e7a\n";
        }
        if (this.valorMensal.getValue() == null || (Double)this.valorMensal.getValue() <= 0.0) {
            erro = (String)erro + "Valor mensal deve ser maior que zero\n";
        }
        if (this.periodoCobranca.getValue() == null || (Double)this.periodoCobranca.getValue() <= 0.0) {
            erro = (String)erro + "Periodo de cobran\u00e7a deve ser maior que zero\n";
        }
        if (this.dpProximoVencimento.getValue() == null || ((LocalDate)this.dpProximoVencimento.getValue()).isBefore(LocalDate.now().plusDays(2L))) {
            erro = (String)erro + "Proximo vencimento nao pode ser menor que hoje+2\n";
        }
        if (this.valorDesconto.getValue() != null && (Double)this.valorDesconto.getValue() > 0.0 && (this.dpDesconto.getValue() == null || ((LocalDate)this.dpDesconto.getValue()).isBefore((ChronoLocalDate)this.dpProximoVencimento.getValue()))) {
            erro = (String)erro + "Desconto At\u00e9 n\u00e3o pode ser antes da data do proximo vencimento\n";
        }
        if (this.listaEmail.getValue() == null || this.listaEmail.getValue().isEmpty()) {
            erro = (String)erro + "Lista E-mail obrigat\u00f3rio\n";
        }
        if (this.txtCelular.getValue() == null || this.txtCelular.getValue().isEmpty()) {
            erro = (String)erro + "Celular obrigat\u00f3rio\n";
        }
        if (this.txtCelular.getValue() != null && StringUtil.numbersOnly((String)this.txtCelular.getValue()).length() > 11) {
            erro = (String)erro + "Celular invalido\n";
        }
        if (this.txtCelular2.getValue() != null && StringUtil.numbersOnly((String)this.txtCelular2.getValue()).length() > 11) {
            erro = (String)erro + "Celular2 invalido\n";
        }
        BigDecimal vlAtual = BigDecimal.valueOf((Double)this.valorMensal.getValue());
        if (this.caOriginal.getValorMensal() != null && this.caOriginal.getValorMensal().compareTo(vlAtual) != 0 && this.txtObservacao.getValue().isEmpty()) {
            erro = (String)erro + "Altera\u00e7\u00e3o de valor exige uma explica\u00e7\u00e3o no campo observa\u00e7\u00e3o\n";
        }
        if (this.vendedor.getValue() == null || this.vendedor.getValue().isEmpty()) {
            erro = (String)erro + "Informe o nome do vendedor\n";
        }
        return erro;
    }

    private void setCep(String cepStr) {
        CepResult cep = this.cepService.findByCep(cepStr);
        if (cep != null) {
            this.txtLogradouro.setValue(cep.getLogradouro());
            this.txtBairro.setValue(cep.getBairro());
            this.txtCidade.setValue(cep.getCidade());
            this.txtEstado.setValue(cep.getEstado());
        }
    }

    private void setMailing(String cpfCnpj) {
        Mailing mailing = this.mailingService.buscarCnpj(cpfCnpj);
        if (mailing == null) {
            return;
        }
        this.txtNome.setValue(mailing.getNome());
        this.txtCep.setValue(mailing.getCep());
        this.txtLogradouro.setValue(mailing.getLogradouro());
        this.txtNumero.setValue(mailing.getNumero());
        this.txtCompl.setValue(mailing.getComplemento());
        this.txtBairro.setValue(mailing.getBairro());
        this.txtCidade.setValue(mailing.getCidade());
        this.txtEstado.setValue(mailing.getEstado());
    }

    private void salvar() {
        this.ca.setAtivo(Boolean.valueOf(((String)this.rbAtivo.getValue()).equals("Ativo")));
        this.ca.setBairro(this.txtBairro.getValue());
        this.ca.setCep(this.txtCep.getValue());
        this.ca.setCidade(this.txtCidade.getValue());
        this.ca.setCompl(this.txtCompl.getValue());
        this.ca.setCpfCnpj(this.txtCpfCnpj.getValue());
        if (this.ca.getDataCriacao() == null) {
            this.ca.setDataCriacao(LocalDate.now());
        }
        this.ca.setVendedor(this.vendedor.getValue());
        this.ca.setDescontoAte(this.valorDesconto.getValue() == null || (Double)this.valorDesconto.getValue() <= 0.0 ? null : (LocalDate)this.dpDesconto.getValue());
        this.ca.setEstado(this.txtEstado.getValue());
        this.ca.setListaEmail(StringUtils.join((Iterable)this.listaEmail.getValue(), (String)","));
        this.ca.setLogradouro(this.txtLogradouro.getValue());
        this.ca.setNome(this.txtNome.getValue());
        this.ca.setNumero(this.txtNumero.getValue());
        this.ca.setPeriodoCobrancaMeses(Integer.valueOf(((Double)this.periodoCobranca.getValue()).intValue()));
        this.ca.setProximoVencimento((LocalDate)this.dpProximoVencimento.getValue());
        this.ca.setTipo((CobrancaTipoEnum)this.cbTipo.getValue());
        this.ca.setCelular(this.txtCelular.getValue());
        this.ca.setCelular2(this.txtCelular2.getValue());
        this.ca.setNroUsuarios(Integer.valueOf(this.nroUsuarios.getValue() == null ? 0 : ((Double)this.nroUsuarios.getValue()).intValue()));
        this.ca.setNroLoginsOperadora(Integer.valueOf(this.nroLogins.getValue() == null ? 0 : ((Double)this.nroLogins.getValue()).intValue()));
        this.ca.setNroWhatsapp(Integer.valueOf(this.nroWhats.getValue() == null ? 0 : ((Double)this.nroWhats.getValue()).intValue()));
        this.ca.setNroRamais(Integer.valueOf(this.nroRamais.getValue() == null ? 0 : ((Double)this.nroRamais.getValue()).intValue()));
        this.ca.setNroLeads(Integer.valueOf(this.nroLeads.getValue() == null ? 0 : ((Double)this.nroLeads.getValue()).intValue()));
        if (this.valorDesconto.getValue() != null && (Double)this.valorDesconto.getValue() > 0.0) {
            this.ca.setValorDesconto(BigDecimal.valueOf((Double)this.valorDesconto.getValue()));
        } else {
            this.ca.setValorDesconto(null);
        }
        if ((Double)this.valorMensal.getValue() > 0.0) {
            this.ca.setValorMensal(BigDecimal.valueOf((Double)this.valorMensal.getValue()));
        } else {
            this.ca.setValorMensal(BigDecimal.ZERO);
        }
        this.cas.save(this.ca);
        this.log();
        this.close();
        UIUtils.showNotification((String)"Salvo com sucesso");
    }

    private void log() {
        if (this.caOriginal.getId() == null) {
            this.cobrancaAssinaturaLogService.create(this.getEu(), this.ca, "Inserindo assinatura");
            return;
        }
        StringBuilder log = new StringBuilder();
        if (this.caOriginal.getValorMensal() != null && this.caOriginal.getValorMensal().compareTo(this.ca.getValorMensal()) != 0) {
            log.append("Valor Mensal ").append(this.caOriginal.getValorMensal()).append("  para ").append(this.ca.getValorMensal()).append(" Explica\u00e7\u00e3o: ").append(this.txtObservacao.getValue());
        }
        if (!this.ca.getAtivo().equals(this.caOriginal.getAtivo())) {
            log.append("Ativo ").append(this.caOriginal.getAtivo()).append(" para ").append(this.ca.getAtivo());
        }
        if (!this.ca.getCpfCnpj().equals(this.caOriginal.getCpfCnpj())) {
            log.append("Cpf/Cnpj ").append(this.caOriginal.getCpfCnpj()).append(" para ").append(this.ca.getCpfCnpj()).append("\n");
        }
        if (!this.ca.getPeriodoCobrancaMeses().equals(this.caOriginal.getPeriodoCobrancaMeses())) {
            log.append("Periodo cobranca ").append(this.caOriginal.getPeriodoCobrancaMeses()).append(" para ").append(this.ca.getPeriodoCobrancaMeses()).append("\n");
        }
        if (this.ca.getDescontoAte() == null && this.caOriginal.getDescontoAte() != null) {
            log.append("Excluido periodo de desconto que estava ate ").append(this.caOriginal.getDescontoAte().format(DateTimeFormatter.ISO_DATE)).append("\n");
        } else if (this.ca.getDescontoAte() != null && this.caOriginal.getDescontoAte() == null) {
            log.append("Inserido periodo de desconto ate ").append(this.ca.getDescontoAte().format(DateTimeFormatter.ISO_DATE)).append("\n");
        } else if (this.ca.getDescontoAte() != null && this.caOriginal.getDescontoAte() != null && !this.ca.getDescontoAte().equals(this.caOriginal.getDescontoAte())) {
            log.append("Alterado periodo desconto ").append(this.ca.getDescontoAte().format(DateTimeFormatter.ISO_DATE)).append(" para ").append(this.caOriginal.getDescontoAte().format(DateTimeFormatter.ISO_DATE)).append("\n");
        }
        if (this.ca.getValorDesconto() == null && this.caOriginal.getValorDesconto() != null) {
            log.append("Excluido valor de desconto ").append(this.caOriginal.getValorDesconto().toString()).append("\n");
        } else if (this.ca.getValorDesconto() != null && this.caOriginal.getValorDesconto() == null) {
            log.append("Inserido valor de desconto ").append(this.ca.getValorDesconto().toString()).append("\n");
        } else if (this.ca.getValorDesconto() != null && this.caOriginal.getValorDesconto() != null && this.ca.getValorDesconto().compareTo(this.caOriginal.getValorDesconto()) != 0) {
            log.append("Alterado valor de desconto ").append(this.caOriginal.getValorDesconto()).append(" para ").append(this.ca.getValorDesconto()).append("\n");
        }
        if (this.caOriginal.getTipo() != null && !this.ca.getTipo().equals((Object)this.caOriginal.getTipo())) {
            log.append("Tipo alterado ").append(this.caOriginal.getTipo().name()).append(" para ").append(this.ca.getTipo().name()).append("\n");
        }
        if (this.caOriginal.getProximoVencimento() != null && !this.ca.getProximoVencimento().equals(this.caOriginal.getProximoVencimento())) {
            log.append("Alterado proximo vencimento ").append(this.caOriginal.getProximoVencimento().format(DateTimeFormatter.ISO_DATE)).append(" para ").append(this.ca.getProximoVencimento().format(DateTimeFormatter.ISO_DATE)).append("\n");
        }
        if (!this.ca.getListaEmail().equals(this.caOriginal.getListaEmail())) {
            log.append("Lista email alterada ").append(this.caOriginal.getListaEmail()).append(" para ").append(this.ca.getListaEmail()).append("\n");
        }
        if (!this.ca.getNroUsuarios().equals(this.caOriginal.getNroUsuarios())) {
            log.append("Nro usu\u00e1rios alterado ").append(this.caOriginal.getNroUsuarios()).append(" para ").append(this.ca.getNroUsuarios()).append("\n");
        }
        if (!this.ca.getNroLoginsOperadora().equals(this.caOriginal.getNroLoginsOperadora())) {
            log.append("Nro logins operadora ").append(this.caOriginal.getNroLoginsOperadora()).append(" para ").append(this.ca.getNroLoginsOperadora()).append("\n");
        }
        if (!this.ca.getNroWhatsapp().equals(this.caOriginal.getNroWhatsapp())) {
            log.append("Nro Whatsapp ").append(this.caOriginal.getNroWhatsapp()).append(" para ").append(this.ca.getNroWhatsapp()).append("\n");
        }
        if (!this.ca.getNroRamais().equals(this.caOriginal.getNroRamais())) {
            log.append("Nro Ramais ").append(this.caOriginal.getNroRamais()).append(" para ").append(this.ca.getNroRamais()).append("\n");
        }
        if (!this.ca.getNroLeads().equals(this.caOriginal.getNroLeads())) {
            log.append("Leads ").append(this.caOriginal.getNroLeads()).append(" para ").append(this.ca.getNroLeads()).append("\n");
        }
        if (this.ca.getVendedor() == null && this.caOriginal.getVendedor() != null) {
            log.append("Vendedor ").append(this.caOriginal.getVendedor()).append(" retirado");
        } else if (this.ca.getVendedor() != null && this.caOriginal.getVendedor() == null) {
            log.append("Vendedor ").append(this.ca.getVendedor()).append(" Inserido");
        } else if (this.ca.getVendedor() == null && this.caOriginal.getVendedor() == null) {
            log.append("Vendedor ").append(this.ca.getVendedor()).append(" nao inserido");
        } else if (!this.ca.getVendedor().equals(this.caOriginal.getVendedor())) {
            log.append("Vendedor ").append(this.caOriginal.getVendedor()).append(" para ").append(this.ca.getVendedor()).append("\n");
        }
        if (log.toString().length() > 0) {
            this.cobrancaAssinaturaLogService.create(this.getEu(), this.ca, log.toString());
        }
    }

    private TextField getField(String nome, String valor) {
        TextField t = new TextField(nome);
        t.setReadOnly(true);
        t.setWidth("150px");
        t.setValue(valor == null ? "" : valor);
        return t;
    }
}

