/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.service;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaFatura;
import br.com.system.app.features.cobranca.model.CobrancaFaturaEnotasDTO;
import br.com.system.app.features.cobranca.model.CobrancaTipoEnum;
import br.com.system.app.features.cobranca.model.StatusPagamento;
import br.com.system.app.features.cobranca.repository.CobrancaFaturaRepository;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaLogService;
import br.com.system.app.features.cobranca.service.EnotasService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.starkbank.StarkBankService;
import br.com.system.app.features.starkbank.StarkBankTipoEnum;
import br.com.system.app.features.starkbank.dto.StarkBankBoletoDTO;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import com.starkbank.Boleto;
import com.starkbank.Invoice;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CobrancaFaturaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private StarkBankService starkBankService;
    @Autowired
    private CobrancaFaturaRepository cobrancaFaturaRepository;
    @Autowired
    private EnotasService enotasService;
    @Autowired
    private CobrancaAssinaturaLogService logService;

    public CobrancaFatura getById(Long id) {
        return (CobrancaFatura)this.cobrancaFaturaRepository.findById((Object)id).get();
    }

    public void updateFatura(EstruturaUsuario eu, CobrancaFatura cf, String justificativa) {
        if (cf.getTipo().equals((Object)CobrancaTipoEnum.PIX)) {
            this.starkBankService.updateInvoice(cf, false);
        } else {
            this.starkBankService.deleteBoleto(cf.getStarkId());
        }
        cf.setObservacao((String)(cf.getObservacao() == null ? justificativa : cf.getObservacao() + "\n" + justificativa));
        this.salvar(cf);
        this.logService.create(eu, cf.getCobrancaAssinatura(), justificativa);
    }

    public void cancelarFatura(EstruturaUsuario eu, CobrancaFatura cf, String justificativa) {
        if (cf.getTipo().equals((Object)CobrancaTipoEnum.PIX)) {
            this.starkBankService.updateInvoice(cf, true);
        } else {
            this.starkBankService.deleteBoleto(cf.getStarkId());
        }
        if (cf.getEnotasId() != null && !cf.getEnotasId().isEmpty()) {
            this.enotasService.cancelarVenda(cf.getEnotasId());
            cf.setEnotasId(null);
            cf.setLinkPdfEnotas(null);
        }
        cf.setObservacao((String)(cf.getObservacao() == null ? justificativa : cf.getObservacao() + "\n" + justificativa));
        cf.setStatus(StatusPagamento.CANCELADO);
        this.salvar(cf);
        this.logService.create(eu, cf.getCobrancaAssinatura(), justificativa);
    }

    public CobrancaFatura criarFatura(CobrancaAssinatura ca) {
        return this.criarFatura(ca, false, null, null, null, null);
    }

    public CobrancaFatura criarFaturaAvulsa(CobrancaAssinatura ca, BigDecimal valor, CobrancaTipoEnum tipo, LocalDate dataVencimento, String observacao) {
        return this.criarFatura(ca, true, tipo, valor, dataVencimento, observacao);
    }

    private CobrancaFatura criarFatura(CobrancaAssinatura ca, boolean avulsa, CobrancaTipoEnum tipo, BigDecimal valor, LocalDate dataVencimento, String observacao) {
        CobrancaFatura cf = new CobrancaFatura();
        cf.setAvulsa(Boolean.valueOf(avulsa));
        cf.setCobrancaAssinatura(ca);
        cf.setObservacao(observacao);
        cf.setDataHoraCriacao(LocalDateTime.now());
        if (!avulsa) {
            valor = ca.getValorMensal();
            if (ca.getDescontoAte() != null && ca.getValorDesconto() != null && ca.getDescontoAte().isAfter(LocalDate.now()) && ca.getValorDesconto() != null) {
                cf.setDesconto(ca.getValorDesconto());
                valor = valor.subtract(ca.getValorDesconto());
            }
        } else if (valor == null || valor.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("Fatura avulsa precisa de valor");
        }
        cf.setStatus(StatusPagamento.EM_ABERTO);
        cf.setTipo(tipo != null ? tipo : ca.getTipo());
        cf.setValor(valor);
        cf.setDataVencimento(this.getVencimento(dataVencimento));
        if (cf.getTipo().equals((Object)CobrancaTipoEnum.PIX)) {
            Invoice invoice = this.starkBankService.createInvoice(StarkBankTipoEnum.MENSALIDADE, null, ca.getCpfCnpj(), ca.getNome(), ca.getListaEmail(), Double.valueOf(valor.doubleValue()), cf.getDataVencimento());
            cf.setStarkId(invoice.id);
        } else {
            StarkBankBoletoDTO dto = new StarkBankBoletoDTO();
            dto.setBairro(ca.getBairro());
            dto.setCep(ca.getCep());
            dto.setCidade(ca.getCidade());
            dto.setCompl(ca.getCompl());
            dto.setCpfCnpj(ca.getCpfCnpj());
            dto.setEndereco(ca.getLogradouro());
            dto.setEstado(ca.getEstado());
            dto.setNome(ca.getNome());
            dto.setNumero(ca.getNumero());
            dto.setListaEmail(ca.getListaEmail());
            dto.setValor(Double.valueOf(valor.doubleValue()));
            dto.setVencimento(cf.getDataVencimento());
            Boleto boleto = this.starkBankService.createBoleto(null, dto);
            cf.setStarkId(boleto.id);
        }
        return this.salvar(cf);
    }

    public CobrancaFatura salvar(CobrancaFatura cf) {
        if (cf.getCobrancaAssinatura() == null) {
            throw new BusinessException("Sem assiantura");
        }
        if (cf.getDataHoraCriacao() == null) {
            cf.setDataHoraCriacao(LocalDateTime.now());
        }
        if (cf.getValor().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("Valor nao pode ser zero");
        }
        return (CobrancaFatura)this.cobrancaFaturaRepository.save((Object)cf);
    }

    public List<CobrancaFaturaEnotasDTO> getNoLink() {
        return this.cobrancaFaturaRepository.findNotaEmitida();
    }

    public List<CobrancaFatura> getByCobrancaAssinatura(CobrancaAssinatura ca) {
        LocalDateTime ldt = DateTimeUtil.toDate((String)"2020-06-01", (FormatDate)FormatDate.US_DATE).atStartOfDay();
        return this.cobrancaFaturaRepository.findByCobrancaAssinaturaAndDataHoraCriacaoGreaterThanOrderByDataHoraCriacaoDesc(ca, ldt);
    }

    public List<CobrancaFatura> getAvencer(CobrancaAssinatura ca) {
        return this.cobrancaFaturaRepository.findByCobrancaAssinaturaAndStatusAndDataVencimentoGreaterThan(ca, StatusPagamento.EM_ABERTO, LocalDate.now().minusDays(1L));
    }

    public List<CobrancaFatura> getInadimplentes() {
        return this.cobrancaFaturaRepository.findInadimplentes();
    }

    public CobrancaFatura emitirNota(CobrancaFatura cf) {
        BigDecimal valor = cf.getValor();
        String vendaId = this.enotasService.emitirVenda(cf.getCobrancaAssinatura().getEnotasClienteId(), LocalDate.now(), valor, "Mensalidade");
        cf.setEnotasId(vendaId);
        return this.salvar(cf);
    }

    private LocalDate getVencimento(LocalDate dataVencimento) {
        LocalDate localDate = dataVencimento = dataVencimento == null ? LocalDate.now().plusDays(8L) : dataVencimento;
        while (dataVencimento.getDayOfWeek().equals(DayOfWeek.SATURDAY) || dataVencimento.getDayOfWeek().equals(DayOfWeek.SUNDAY)) {
            dataVencimento = dataVencimento.plusDays(1L);
        }
        return dataVencimento;
    }
}

