/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca.service;

import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaFatura;
import br.com.system.app.features.cobranca.model.CobrancaFaturaEnotasDTO;
import br.com.system.app.features.cobranca.model.CobrancaTipoEnum;
import br.com.system.app.features.cobranca.model.StatusPagamento;
import br.com.system.app.features.cobranca.repository.CobrancaFaturaRepository;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.cobranca.service.CobrancaFaturaService;
import br.com.system.app.features.cobranca.service.EnotasService;
import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.starkbank.StarkBankService;
import br.com.system.app.features.suportnumber.SuportNumberService;
import com.starkbank.Boleto;
import com.starkbank.Invoice;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CobrancaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(CobrancaService.class);
    @Autowired
    private CobrancaAssinaturaService assinaturaService;
    @Autowired
    private CobrancaFaturaService cobrancaFaturaService;
    @Autowired
    private CobrancaFaturaRepository cobrancaFaturaRepository;
    @Autowired
    private EnotasService enotasService;
    @Autowired
    private StarkBankService starkBankService;
    @Autowired
    private SendMailService sendMailService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private SuportNumberService suportNumber;

    public void validarPagamento(String starkId, Double valor) {
        CobrancaFatura cf = this.cobrancaFaturaRepository.findByStarkId(starkId);
        this.validarPagamento(cf, valor);
    }

    public void validarPagamento(CobrancaFatura cf, Double valor) {
        if (cf == null) {
            return;
        }
        if (!cf.getStatus().equals((Object)StatusPagamento.PAGO_INTEGRAL) && !cf.getStatus().equals((Object)StatusPagamento.PAGO_PARCIAL)) {
            BigDecimal vlBig = BigDecimal.valueOf(valor);
            if (cf.getValor().compareTo(vlBig) > 0) {
                cf.setStatus(StatusPagamento.PAGO_PARCIAL);
            } else {
                cf.setStatus(StatusPagamento.PAGO_INTEGRAL);
            }
            cf.setValorPago(vlBig);
            cf.setDataPagamento(LocalDate.now());
            try {
                if (cf.getEnotasId() == null || cf.getEnotasId().isEmpty()) {
                    String enotasId = this.enotasService.emitirVenda(cf.getCobrancaAssinatura().getEnotasClienteId(), LocalDate.now(), vlBig, "Mensalidade");
                    cf.setEnotasId(enotasId);
                }
            }
            catch (Exception e) {
                cf.setEnotasId(null);
            }
            this.cobrancaFaturaService.salvar(cf);
            if (cf.getCobrancaAssinatura().getPrimeiroPagamento() == null) {
                CobrancaAssinatura ass = cf.getCobrancaAssinatura();
                ass.setPrimeiroPagamento(LocalDate.now());
                this.assinaturaService.save(ass);
            }
            this.checarInadimplencia(cf.getCobrancaAssinatura().getCpfCnpj());
        }
    }

    public void gerarFaturas() {
    }

    public void checarNota() {
        List noLink = this.cobrancaFaturaService.getNoLink();
        for (CobrancaFaturaEnotasDTO cf : noLink) {
            CobrancaFatura cobrancaFatura = this.cobrancaFaturaService.getById(cf.getId());
            this.checarNota(cobrancaFatura);
        }
    }

    public CobrancaFatura checarNota(CobrancaFatura cf) {
        try {
            String linkNota = this.enotasService.getLinkNota(cf.getEnotasId());
            if (linkNota.isEmpty()) {
                return cf;
            }
            cf.setLinkPdfEnotas(linkNota);
            return this.cobrancaFaturaService.salvar(cf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void transferirInter() {
        try {
            this.starkBankService.transferirInter();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void checarInadimplencia(String cpfCnpj) {
        try {
            this.assinaturaService.checarInadimplencia(cpfCnpj);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void checarDivergencia(String cpfCnpj) {
        try {
            this.assinaturaService.checarDivergencia(cpfCnpj);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            this.sendMailService.sendNoReply(null, "jeriam.siqueira@gmail.com", "erro checar divergencia", e.getMessage());
        }
    }

    public void notificarInadimplencia() {
        Estrutura e = this.estruturaService.getByNome("neocrm");
        EstruturaUsuario eu = this.eus.getMasterEstrutura(e);
        List inadimplentes = this.assinaturaService.getAssinaturasInadimplentes();
        for (CobrancaAssinatura ca : inadimplentes) {
            StringBuilder s = new StringBuilder();
            s.append("Ol\u00e1 <strong>").append(ca.getNome()).append("</strong>.<BR><BR>Verificamos que sua empresa encontra-se inadimplente conosco.<BR>");
            s.append("<B>Evite o bloqueio do seu acesso</B>, fa\u00e7a agora mesmo o pagamento.<BR>");
            s.append("Para obter a fatura, acesse o sistema, no menu <strong>Cobran\u00e7as e Faturas</strong>, e efetue o pagamento.<BR>");
            s.append("Caso tenha duvidas, entre em contato com nosso suporte. <a href='https://wa.me/'" + this.suportNumber.getForWhats(ca.getProprietario()) + ">" + this.suportNumber.getFormmated(ca.getProprietario()) + "</a> (Whatsapp)<BR><BR>");
            s.append("Caso j\u00e1 tenha efetuado o pagamento favor desconsiderar esse e-mail.<BR><BR>");
            s.append("Obrigado e tenho um \u00f3timo dia.<BR>");
            s.append("Equipe Suporte.");
            this.sendMailService.sendNoReply(eu, ca.getListaEmail(), "NEO SALES - Cobran\u00e7a em atraso(sujeito a bloqueio)", s.toString());
        }
    }

    public void checarPagamentos() {
        List emAbertos = this.cobrancaFaturaRepository.findByCobrancaAssinaturaAtivoAndStatus(true, StatusPagamento.EM_ABERTO);
        for (CobrancaFatura emAberto : emAbertos) {
            try {
                Invoice i;
                if (emAberto.getStarkId() == null) continue;
                Boolean pago = null;
                if (emAberto.getTipo().equals((Object)CobrancaTipoEnum.BOLETO)) {
                    Boleto b = this.starkBankService.getBoleto(emAberto.getStarkId());
                    if (b != null) {
                        pago = b.status.equals("paid");
                    }
                } else if (emAberto.getTipo().equals((Object)CobrancaTipoEnum.PIX) && (i = this.starkBankService.getInvoice(emAberto.getStarkId())) != null) {
                    pago = i.status.equals("paid");
                }
                if (pago == null || !pago.booleanValue()) continue;
                this.validarPagamento(emAberto, Double.valueOf(emAberto.getValor().doubleValue()));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }
}

